/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.Tools;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.operator.features.IndividualOperator;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class AttributeGenerator
extends IndividualOperator {
    private double pGenerate;
    private int numberOfNewAttributes;
    private List generatorList;

    public AttributeGenerator(double pGenerate, int numberOfNewAttributes, List generatorList) {
        this.pGenerate = pGenerate;
        this.numberOfNewAttributes = numberOfNewAttributes;
        this.generatorList = generatorList;
    }

    public List operate(AttributeWeightedExampleSet exampleSet) throws Exception {
        ArrayList<FeatureGenerator> selectedGeneratorList = new ArrayList<FeatureGenerator>();
        for (int h = 0; h < this.numberOfNewAttributes; ++h) {
            FeatureGenerator generator;
            if (!(RandomGenerator.getGlobalRandomGenerator().nextDouble() < this.pGenerate) || (generator = FeatureGenerator.selectGenerator(exampleSet, this.generatorList, -1, new String[0])) == null) continue;
            generator = generator.newInstance();
            Attribute[] args = Tools.getRandomCompatibleAttributes(exampleSet, generator, -1, new String[0]);
            generator.setArguments(args);
            LinkedList generatorList = new LinkedList();
            selectedGeneratorList.add(generator);
        }
        if (selectedGeneratorList.size() > 0) {
            exampleSet.addAllAttributes(FeatureGenerator.generateAll(exampleSet.getExampleTable(), selectedGeneratorList));
        }
        LinkedList<AttributeWeightedExampleSet> result = new LinkedList<AttributeWeightedExampleSet>();
        result.add(exampleSet);
        return result;
    }
}

