/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.gui.SimplePropertyTable;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class WizardPropertyTable
extends SimplePropertyTable {
    private Operator[] operators;
    private ParameterType[] parameterTypes;

    public WizardPropertyTable() {
        this.setExperiment(null, null);
    }

    public void setExperiment(Experiment experiment, List parameters) {
        if (experiment == null) {
            parameters = new LinkedList();
        }
        this.updateTableData(parameters.size());
        this.operators = new Operator[parameters.size()];
        this.parameterTypes = new ParameterType[parameters.size()];
        Iterator i = parameters.iterator();
        int j = 0;
        while (i.hasNext()) {
            String[] parameter = (String[])i.next();
            this.operators[j] = experiment.getOperator(parameter[0]);
            this.parameterTypes[j] = WizardPropertyTable.getParameterType(this.operators[j], parameter[1]);
            this.getDefaultModel().setValueAt(this.operators[j].getName() + "." + this.parameterTypes[j].getKey(), j, 0);
            this.getDefaultModel().setValueAt(this.operators[j].getParameters().getParameter(this.parameterTypes[j].getKey()), j, 1);
            ++j;
        }
        this.updateEditorsAndRenderers();
        this.getDefaultModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                WizardPropertyTable.this.setValue(e.getFirstRow(), WizardPropertyTable.this.getDefaultModel().getValueAt(e.getFirstRow(), 1));
            }
        });
    }

    private static ParameterType getParameterType(Operator operator, String key) {
        Iterator i = operator.getParameterTypes().iterator();
        while (i.hasNext()) {
            ParameterType type = (ParameterType)i.next();
            if (!type.getKey().equals(key)) continue;
            return type;
        }
        return null;
    }

    public ParameterType getParameterType(int row) {
        return this.parameterTypes[row];
    }

    public Operator getOperator(int row) {
        return this.operators[row];
    }
}

