/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Template {
    private String name = "unnamed";
    private String description = "none";
    private String configFile;
    private List parameters = new LinkedList();
    private File templateFile = null;

    public Template() {
    }

    public Template(File file) throws IOException {
        this.templateFile = file;
        BufferedReader in = new BufferedReader(new FileReader(this.templateFile));
        this.name = in.readLine();
        this.description = in.readLine();
        this.configFile = in.readLine();
        String line = null;
        while ((line = in.readLine()) != null) {
            this.parameters.add(line.split("\\."));
        }
        in.close();
    }

    public Template(String name, String description, String configFile, List parameters) {
        this.name = name;
        this.description = description;
        this.configFile = configFile;
        this.parameters = parameters;
    }

    public File getFile() {
        return this.templateFile;
    }

    public String getFilename() {
        return this.configFile;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List getParameters() {
        return this.parameters;
    }

    public String toHTML() {
        return "<b>" + this.name + "</b><br />" + this.description;
    }

    public void save(File file) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(file));
        out.println(this.name);
        out.println(this.description);
        out.println(this.configFile);
        Iterator i = this.parameters.iterator();
        while (i.hasNext()) {
            String[] pair = (String[])i.next();
            out.println(pair[0] + "." + pair[1]);
        }
        out.close();
    }
}

