/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.gui.SettingsPropertyTable;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.tools.ParameterService;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class SettingsTabs
extends JTabbedPane {
    private List tables = new LinkedList();

    public SettingsTabs() {
        Set allProperties = Yale.getYaleProperties();
        TreeMap<String, LinkedList<ParameterType>> groups = new TreeMap<String, LinkedList<ParameterType>>();
        Iterator<Object> i = allProperties.iterator();
        while (i.hasNext()) {
            ParameterType type = (ParameterType)i.next();
            String key = type.getKey();
            String[] parts = key.split("\\.");
            String group = parts[1];
            LinkedList<ParameterType> list = (LinkedList<ParameterType>)groups.get(group);
            if (list == null) {
                list = new LinkedList<ParameterType>();
                groups.put(group, list);
            }
            list.add(type);
        }
        i = groups.keySet().iterator();
        while (i.hasNext()) {
            String group = (String)i.next();
            List groupList = (List)groups.get(group);
            SettingsPropertyTable table = new SettingsPropertyTable(groupList);
            this.tables.add(table);
            this.addTab(group, new JScrollPane(table));
        }
    }

    public void applyProperties() {
        Iterator i = this.tables.iterator();
        while (i.hasNext()) {
            ((SettingsPropertyTable)i.next()).applyProperties();
        }
    }

    public void save() throws IOException {
        File configFile = ParameterService.getUserConfigFile("yalerc." + System.getProperty("os.name"));
        PrintWriter out = new PrintWriter(new FileWriter(configFile));
        Iterator i = this.tables.iterator();
        while (i.hasNext()) {
            ((SettingsPropertyTable)i.next()).writeProperties(out);
        }
        out.close();
    }
}

