/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.gui.SettingsTabs;
import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.tools.ParameterService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class SettingsDialog
extends JDialog {
    private SettingsTabs tabs = new SettingsTabs();

    public SettingsDialog(JFrame owner) {
        super(owner, "Settings", true);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(5);
        borderLayout.setVgap(5);
        JPanel panel = new JPanel(borderLayout);
        JTextArea label = new JTextArea("You can edit the file '" + ParameterService.getConfigFile("yalerc") + "' to make system wide settings. This dialog will save all changes to '" + ParameterService.getUserConfigFile("yalerc." + System.getProperty("os.name")) + "'.", 3, 60);
        label.setLineWrap(true);
        label.setWrapStyleWord(true);
        label.setBackground(this.getBackground());
        label.setEditable(false);
        panel.add((Component)label, "North");
        panel.add((Component)this.tabs, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton ok = new JButton("Apply");
        ok.setToolTipText("Apply settings for this session.");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.tabs.applyProperties();
                SettingsDialog.this.dispose();
            }
        });
        buttonPanel.add(ok);
        JButton save = new JButton("Save");
        save.setToolTipText("Save settings for this and future sessions.");
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    SettingsDialog.this.tabs.save();
                    SettingsDialog.this.dispose();
                }
                catch (IOException ioe) {
                    SwingTools.showSimpleErrorMessage("Cannot save properties.", ioe);
                }
            }
        });
        buttonPanel.add(save);
        JButton cancel = new JButton("Cancel");
        cancel.setToolTipText("Do not change settings.");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.dispose();
            }
        });
        buttonPanel.add(cancel);
        panel.add((Component)buttonPanel, "South");
        panel.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        this.getContentPane().add(panel);
        this.pack();
        this.setLocationRelativeTo(owner);
    }
}

