/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.Statistics;
import edu.udo.cs.yale.gui.ColorPlotter;
import edu.udo.cs.yale.gui.Plotter;
import edu.udo.cs.yale.gui.SwingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class ScatterPlotter
extends JPanel
implements Plotter {
    private ColorPlotter[][] plotters = new ColorPlotter[0][0];
    private int plotDimension = -1;
    private Statistics statistics;
    private int plotterSize;

    public ScatterPlotter() {
        this.setBackground(Color.white);
        String sizeProperty = System.getProperty("yale.gui.plotter.scatterplot.size");
        this.plotterSize = Integer.parseInt(sizeProperty);
    }

    public ScatterPlotter(Statistics statistics) {
        this();
        this.setStatistics(statistics);
    }

    public void setStatistics(Statistics statistics) {
        this.statistics = statistics;
        statistics.addStatisticsListener(this);
        this.plotters = new ColorPlotter[statistics.getNumberOfColumns() - 1][statistics.getNumberOfColumns() - 1];
        for (int x = 0; x < this.plotters.length; ++x) {
            for (int y = 0; y < this.plotters[x].length; ++y) {
                this.plotters[x][y] = new ColorPlotter(statistics);
                this.plotters[x][y].setDrawAxes(false);
                this.plotters[x][y].getPlotter().setSize(new Dimension(this.plotterSize, this.plotterSize));
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        for (int x = 0; x < this.plotters.length; ++x) {
            for (int y = 0; y < this.plotters[x].length; ++y) {
                Graphics2D newSpace = (Graphics2D)graphics.create();
                newSpace.translate(x * this.plotterSize, y * this.plotterSize);
                this.plotters[x][y].paint2DPlots(newSpace);
            }
        }
    }

    private void updatePlotters() {
        if (this.plotDimension >= 0) {
            int firstIndex = 0;
            for (int x = 0; x < this.statistics.getNumberOfColumns(); ++x) {
                if (x == this.plotDimension) continue;
                int secondIndex = 0;
                for (int y = 0; y < this.statistics.getNumberOfColumns(); ++y) {
                    if (y == this.plotDimension) continue;
                    if (firstIndex == secondIndex) {
                        this.plotters[firstIndex][secondIndex].setAxis(0, -1);
                        this.plotters[firstIndex][secondIndex].setAxis(1, -1);
                        this.plotters[firstIndex][secondIndex].clearPlotColumns();
                    } else {
                        this.plotters[firstIndex][secondIndex].setAxis(0, x);
                        this.plotters[firstIndex][secondIndex].setAxis(1, y);
                        this.plotters[firstIndex][secondIndex].clearPlotColumns();
                        this.plotters[firstIndex][secondIndex].setPlotColumn(this.plotDimension, true);
                    }
                    ++secondIndex;
                }
                ++firstIndex;
            }
        } else {
            for (int x = 0; x < this.plotters.length; ++x) {
                for (int y = 0; y < this.plotters[x].length; ++y) {
                    this.plotters[x][y].setAxis(0, -1);
                    this.plotters[x][y].setAxis(1, -1);
                    this.plotters[x][y].clearPlotColumns();
                }
            }
        }
        this.revalidate();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.plotters.length * this.plotterSize, this.plotters.length * this.plotterSize);
    }

    public Component getPlotter() {
        return this;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public String getAxisName(int index) {
        return "none";
    }

    public int getValuePlotSelectionType() {
        return 0;
    }

    public Icon getIcon(int index) {
        return null;
    }

    public void statisticsUpdated(Statistics source) {
        for (int x = 0; x < this.plotters.length; ++x) {
            for (int y = 0; y < this.plotters[x].length; ++y) {
                this.plotters[x][y].statisticsUpdated(source);
            }
        }
    }

    public boolean isSaveable() {
        return true;
    }

    public void save() {
        JFileChooser chooser = SwingTools.createFileChooser(null, false, new FileFilter[0]);
        if (chooser.showSaveDialog(this) == 0) {
            File file = chooser.getSelectedFile();
            try {
                PrintWriter out = new PrintWriter(new FileWriter(file));
                this.statistics.write(out);
                out.close();
            }
            catch (Exception ex) {
                SwingTools.showErrorMessage("Cannot write to file '" + file + "'", ex);
            }
        }
    }

    public int getNumberOfAxes() {
        return 0;
    }

    public void setAxis(int index, int dimension) {
    }

    public int getAxis(int index) {
        return -1;
    }

    public boolean canHandleDrawAmount() {
        return true;
    }

    public void setDrawAmount(int amount) {
        for (int x = 0; x < this.plotters.length; ++x) {
            for (int y = 0; y < this.plotters[x].length; ++y) {
                this.plotters[x][y].setDrawAmount(amount);
            }
        }
        this.updatePlotters();
    }

    public void setPlotColumn(int index, boolean plot) {
        if (plot) {
            this.plotDimension = index;
        }
        this.updatePlotters();
    }

    public boolean getPlotColumn(int index) {
        return this.plotDimension == index;
    }

    public boolean hasOptionsDialog() {
        return false;
    }

    public void showOptionsDialog() {
    }

    public void setDrawRangeInPlotterSpace(double drawMinX, double drawMaxX, double drawMinY, double drawMaxY) {
    }

    public Point2D getPositionInDataSpace(Point point) {
        return null;
    }

    public void setDrawRange(double drawMinX, double drawMaxX, double drawMinY, double drawMaxY) {
    }

    public void setDragBounds(int dragX, int dragY, int dragWidth, int dragHeight) {
    }

    public void setMousePosInDataSpace(int mouseX, int mouseY) {
    }

    public String getIdForPos(int mouseX, int mouseY) {
        return null;
    }
}

