/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.gui.AttributeFileCellEditor;
import edu.udo.cs.yale.gui.ColorCellEditor;
import edu.udo.cs.yale.gui.ListCellEditor;
import edu.udo.cs.yale.gui.ParameterValueCellEditor;
import edu.udo.cs.yale.gui.PropertyCellEditor;
import edu.udo.cs.yale.gui.PropertyKeyRenderer;
import edu.udo.cs.yale.gui.SimpleFileCellEditor;
import edu.udo.cs.yale.gui.SimplePropertyCellEditor;
import edu.udo.cs.yale.gui.ValueCellEditor;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeAttributeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeColor;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeParameterValue;
import edu.udo.cs.yale.operator.parameter.ParameterTypePassword;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeValue;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class PropertyTable
extends JTable {
    private DefaultTableModel model;
    private ArrayList editors = new ArrayList();
    private ArrayList renderers = new ArrayList();
    private String[] columnNames = new String[]{"Key", "Value"};

    public PropertyTable() {
        this(new String[]{"Key", "Value"});
    }

    public PropertyTable(String[] columnNames) {
        this.columnNames = columnNames;
        this.setSelectionMode(0);
        this.setRowHeight(this.getRowHeight() + 8);
        this.getTableHeader().setReorderingAllowed(false);
    }

    public abstract ParameterType getParameterType(int var1);

    public abstract Operator getOperator(int var1);

    public DefaultTableModel getDefaultModel() {
        return this.model;
    }

    protected void updateEditorsAndRenderers() {
        this.editors.clear();
        this.renderers.clear();
        int numberOfRows = this.getDefaultModel().getRowCount();
        for (int i = 0; i < numberOfRows; ++i) {
            ParameterType type = this.getParameterType(i);
            this.editors.add(PropertyTable.createPropertyCellEditor(type, this.getOperator(i)));
            this.renderers.add(new PropertyKeyRenderer(type));
        }
    }

    protected void updateTableData(int rows) {
        this.model = new DefaultTableModel(this.columnNames, rows);
        this.setModel(this.model);
    }

    public TableCellEditor getCellEditor(int row, int column) {
        if (column == 1) {
            return (PropertyCellEditor)this.editors.get(row);
        }
        return super.getCellEditor(row, column);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 1) {
            PropertyCellEditor editor = (PropertyCellEditor)this.editors.get(row);
            if (!editor.useEditorAsRenderer()) {
                return super.getCellRenderer(row, column);
            }
            return editor;
        }
        return (TableCellRenderer)this.renderers.get(row);
    }

    private static PropertyCellEditor createPropertyCellEditor(ParameterType type, Operator operator) {
        if (type instanceof ParameterTypePassword) {
            return new SimplePropertyCellEditor((ParameterTypePassword)type);
        }
        if (type instanceof ParameterTypeColor) {
            return new ColorCellEditor((ParameterTypeColor)type);
        }
        if (type instanceof ParameterTypeCategory) {
            return new SimplePropertyCellEditor((ParameterTypeCategory)type);
        }
        if (type instanceof ParameterTypeStringCategory) {
            return new SimplePropertyCellEditor((ParameterTypeStringCategory)type);
        }
        if (type instanceof ParameterTypeBoolean) {
            return new SimplePropertyCellEditor((ParameterTypeBoolean)type);
        }
        if (type instanceof ParameterTypeInt) {
            return new SimplePropertyCellEditor((ParameterTypeInt)type);
        }
        if (type instanceof ParameterTypeDouble) {
            return new SimplePropertyCellEditor((ParameterTypeDouble)type);
        }
        if (type instanceof ParameterTypeAttributeFile) {
            return new AttributeFileCellEditor((ParameterTypeAttributeFile)type, operator);
        }
        if (type instanceof ParameterTypeFile) {
            return new SimpleFileCellEditor((ParameterTypeFile)type);
        }
        if (type instanceof ParameterTypeParameterValue) {
            return new ParameterValueCellEditor((ParameterTypeParameterValue)type, operator.getExperiment(), (OperatorChain)operator);
        }
        if (type instanceof ParameterTypeValue) {
            return new ValueCellEditor((ParameterTypeValue)type, operator.getExperiment());
        }
        if (type instanceof ParameterTypeList) {
            return new ListCellEditor((ParameterTypeList)type, operator);
        }
        return new SimplePropertyCellEditor(type);
    }
}

