/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

public class OperatorTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private static final Color SELECTED_COLOR = UIManager.getColor("Tree.selectionBackground");
    private static final Color NON_SELECTED_COLOR = UIManager.getColor("Tree.textBackground");
    private static final Color TEXT_SELECTED_COLOR = UIManager.getColor("Tree.selectionForeground");
    private static final Color TEXT_NON_SELECTED_COLOR = UIManager.getColor("Tree.textForeground");
    private static final Color BORDER_SELECTED_COLOR = UIManager.getColor("Tree.selectionBorderColor");
    private boolean hasFocus;
    private boolean isSelected;
    private JLabel mainLabel = new JLabel();
    private JLabel breakpoint = new JLabel();
    private JLabel error = new JLabel();

    public OperatorTreeCellRenderer() {
        this.mainLabel.setHorizontalAlignment(2);
        this.mainLabel.setFont(this.getFont().deriveFont(0));
        this.mainLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.setLayout(new FlowLayout(0));
        this.setBackground(new Color(0, 0, 0, 0));
        this.add(this.mainLabel);
        this.add(this.breakpoint);
        this.add(this.error);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.isSelected = selected;
        this.hasFocus = hasFocus;
        if (selected) {
            this.mainLabel.setForeground(TEXT_SELECTED_COLOR);
        } else {
            this.mainLabel.setForeground(TEXT_NON_SELECTED_COLOR);
        }
        if (value instanceof Operator) {
            Operator operator = (Operator)value;
            OperatorDescription descr = operator.getOperatorDescription();
            Image img = descr.getIcon();
            if (img != null) {
                this.mainLabel.setIcon(new ImageIcon(img));
            } else {
                this.mainLabel.setIcon(null);
            }
            this.mainLabel.setText("<html>" + operator.getName() + "<br><font size=-2>" + descr.getName() + "</font></html>");
            this.mainLabel.setEnabled(operator.isEnabled());
            if (!operator.isEnabled()) {
                this.mainLabel.setForeground(Color.gray);
            }
            if (operator.hasBreakpoint(0) || operator.hasBreakpoint(2)) {
                this.breakpoint.setIcon(new ImageIcon(Tools.getResource("icons/icon_stop2.gif")));
            } else {
                this.breakpoint.setIcon(null);
            }
            this.breakpoint.setEnabled(operator.isEnabled());
            List errors = operator.getErrorList();
            if (errors.size() > 0) {
                this.error.setIcon(new ImageIcon(Tools.getResource("icons/icon_error.gif")));
                this.setToolTipText("Error: " + (String)errors.get(0));
            } else {
                this.error.setIcon(null);
                this.setToolTipText(descr.getDescription());
            }
            this.error.setEnabled(operator.isEnabled());
            this.setEnabled(operator.isEnabled());
        } else {
            this.mainLabel.setIcon(null);
            this.mainLabel.setText(value.toString());
            this.setEnabled(tree.isEnabled());
        }
        return this;
    }

    public void paint(Graphics g) {
        if (this.isSelected) {
            g.setColor(SELECTED_COLOR);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.hasFocus) {
            g.setColor(BORDER_SELECTED_COLOR);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        super.paint(g);
    }
}

