/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.SimplePropertyTable;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class OperatorPropertyTable
extends SimplePropertyTable {
    private MainFrame mainFrame;
    private Operator operator;
    private ParameterType[] parameterTypes;
    private boolean expertMode = false;

    public OperatorPropertyTable(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.setOperator(null);
    }

    public void toggleExpertMode() {
        this.expertMode = !this.expertMode;
        this.setOperator(this.operator);
    }

    public void setExpertMode(boolean expertMode) {
        this.expertMode = expertMode;
    }

    public boolean isExpertMode() {
        return this.expertMode;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
        if (operator != null) {
            List parameters = operator.getParameterTypes();
            LinkedList<ParameterType> viewableParameters = new LinkedList<ParameterType>();
            Iterator i = parameters.iterator();
            while (i.hasNext()) {
                ParameterType type = (ParameterType)i.next();
                if (!this.expertMode && type.isExpert()) continue;
                viewableParameters.add(type);
            }
            this.parameterTypes = new ParameterType[viewableParameters.size()];
            viewableParameters.toArray(this.parameterTypes);
        } else {
            this.parameterTypes = new ParameterType[0];
        }
        this.updateTableData(this.parameterTypes.length);
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            ParameterType type = this.parameterTypes[i];
            this.getDefaultModel().setValueAt(this.parameterTypes[i].getKey(), i, 0);
            this.getDefaultModel().setValueAt(operator.getParameters().getParameter(this.parameterTypes[i].getKey()), i, 1);
        }
        this.updateEditorsAndRenderers();
        this.getDefaultModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                OperatorPropertyTable.this.setValue(e.getFirstRow(), OperatorPropertyTable.this.getDefaultModel().getValueAt(e.getFirstRow(), 1));
                OperatorPropertyTable.this.mainFrame.experimentChanged();
            }
        });
    }

    public ParameterType getParameterType(int row) {
        return this.parameterTypes[row];
    }

    public Operator getOperator(int row) {
        return this.operator;
    }
}

