/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.yale.BreakpointListener;
import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.gui.AboutBox;
import edu.udo.cs.yale.gui.AttributeEditorDialog;
import edu.udo.cs.yale.gui.Browser;
import edu.udo.cs.yale.gui.CheckForUpdatesThread;
import edu.udo.cs.yale.gui.ComponentPrinter;
import edu.udo.cs.yale.gui.ConditionalAction;
import edu.udo.cs.yale.gui.ExperimentEditor;
import edu.udo.cs.yale.gui.ExperimentInfoScreen;
import edu.udo.cs.yale.gui.ExperimentPanel;
import edu.udo.cs.yale.gui.ExperimentThread;
import edu.udo.cs.yale.gui.ManageTemplatesDialog;
import edu.udo.cs.yale.gui.MessageViewer;
import edu.udo.cs.yale.gui.MonitorPanel;
import edu.udo.cs.yale.gui.OperatorPropertyTable;
import edu.udo.cs.yale.gui.OperatorTree;
import edu.udo.cs.yale.gui.PlotterPanel;
import edu.udo.cs.yale.gui.ResultDisplay;
import edu.udo.cs.yale.gui.SaveAsTemplateDialog;
import edu.udo.cs.yale.gui.SettingsDialog;
import edu.udo.cs.yale.gui.StatusBar;
import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.gui.Template;
import edu.udo.cs.yale.gui.TotDDialog;
import edu.udo.cs.yale.gui.TreePanel;
import edu.udo.cs.yale.gui.Tutorial;
import edu.udo.cs.yale.gui.WizardDialog;
import edu.udo.cs.yale.gui.XMLEditor;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.operator.ExperimentOperator;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorCreationException;
import edu.udo.cs.yale.operator.io.ExampleSource;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeColor;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.OperatorService;
import edu.udo.cs.yale.tools.ParameterService;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.XMLException;
import edu.udo.cs.yale.tools.plugin.Plugin;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import org.freehep.util.export.ExportDialog;

public class MainFrame
extends JFrame
implements WindowListener,
ChangeListener,
BreakpointListener {
    private static final String TITLE = "YALE";
    public final Action NEW_ACTION = new NewAction();
    public final Action OPEN_ACTION = new OpenAction();
    public final Action SAVE_ACTION = new SaveAction();
    public final Action SAVE_AS_ACTION = new SaveAsAction();
    public final Action SAVE_AS_TEMPLATE_ACTION = new SaveAsTemplateAction();
    public final Action MANAGE_TEMPLATES_ACTION = new ManageTemplatesAction();
    public final Action PRINT_ACTION = new PrintAction();
    public final Action EXPORT_ACTION = new ExportAction();
    public final Action EXIT_ACTION = new ExitAction();
    public final Action RUN_ACTION = new RunAction();
    public final Action RESUME_ACTION = new ResumeAction();
    public final Action STOP_ACTION = new StopAction();
    public final Action VALIDATE_ACTION = new ValidateExperiment();
    public final Action WIZARD_ACTION = new WizardAction();
    public final Action SETTINGS_ACTION = new SettingsAction();
    public final Action TOGGLE_EXPERT_MODE_ACTION = new ToggleExpertModeAction();
    public final Action TUTORIAL_ACTION = new TutorialAction();
    public final Action TOTD_ACTION = new TotDAction();
    public final Action UNDO_ACTION = new UndoAction();
    public final Action REDO_ACTION = new RedoAction();
    public final Action ATTRIBUTE_EDITOR_ACTION = new AttributeEditorAction();
    public final Action JVITO_ACTION = new JViToAction();
    public final Action CHECK_FOR_UPDATES_ACTION = new CheckForUpdatesAction();
    private XMLEditor editor = new XMLEditor(this);
    private TreePanel treePanel = new TreePanel(this);
    private ExperimentPanel experimentPanel = new ExperimentPanel();
    private JTabbedPane editorTabs = new JTabbedPane();
    private ResultDisplay resultDisplay = new ResultDisplay();
    private MonitorPanel monitorPanel = new MonitorPanel();
    private MessageViewer messageViewer = new MessageViewer();
    private StatusBar statusBar = new StatusBar();
    private JMenu recentFilesMenu = new JMenu("Recent Files");
    private List conditionalActions = new LinkedList();
    private PrinterJob printerJob = PrinterJob.getPrinterJob();
    private PageFormat pageFormat = this.printerJob.defaultPage();
    private boolean changed = false;
    private ExperimentThread experimentThread = null;
    private CheckForUpdatesThread updateCheckThread = null;
    private ExperimentEditor currentExperimentEditor = this.treePanel;
    private boolean tutorialMode = false;
    private JSplitPane splitPaneV;
    private LinkedList undoList = new LinkedList();
    private int undoIndex;

    public MainFrame() {
        super(TITLE);
        try {
            this.setIconImage(ImageIO.read(Tools.getResource("yale_logo.gif")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Yale.setExperiment(new Experiment());
        Yale.getExperiment().addBreakpointListener(this);
        this.setTitle();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.setOperator(Yale.getExperiment().getRootOperator());
        this.editorTabs.addChangeListener(this);
        this.editorTabs.add((Component)this.treePanel, "Tree");
        this.editorTabs.add((Component)this.editor, "XML");
        this.editorTabs.add((Component)this.experimentPanel, "Box");
        this.editorTabs.add((Component)this.resultDisplay, "Results");
        this.editorTabs.add((Component)this.monitorPanel, "Monitor");
        this.splitPaneV = new JSplitPane(0, this.editorTabs, this.messageViewer);
        this.splitPaneV.setOneTouchExpandable(true);
        this.getContentPane().add((Component)this.splitPaneV, "Center");
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add(this.NEW_ACTION);
        fileMenu.add(this.WIZARD_ACTION);
        fileMenu.add(this.OPEN_ACTION);
        this.updateRecentFileList();
        fileMenu.add(this.recentFilesMenu);
        fileMenu.add(new JSeparator());
        fileMenu.add(this.SAVE_ACTION);
        fileMenu.add(this.SAVE_AS_ACTION);
        fileMenu.add(this.SAVE_AS_TEMPLATE_ACTION);
        fileMenu.add(new JSeparator());
        fileMenu.add(this.PRINT_ACTION);
        fileMenu.add(this.EXPORT_ACTION);
        fileMenu.add(new JSeparator());
        fileMenu.add(this.EXIT_ACTION);
        menuBar.add(fileMenu);
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic(69);
        editMenu.add(this.UNDO_ACTION);
        editMenu.add(this.REDO_ACTION);
        editMenu.add(new JSeparator());
        editMenu.add(this.treePanel.getOperatorTree().NEW_OPERATOR_ACTION);
        this.treePanel.getOperatorTree().createOperatorMenu(editMenu);
        menuBar.add(editMenu);
        JMenu expMenu = new JMenu("Experiment");
        expMenu.setMnemonic(88);
        expMenu.add(this.RUN_ACTION);
        expMenu.add(this.RESUME_ACTION);
        expMenu.add(this.STOP_ACTION);
        menuBar.add(expMenu);
        JMenu toolsMenu = new JMenu("Tools");
        toolsMenu.setMnemonic(84);
        toolsMenu.add(this.VALIDATE_ACTION);
        toolsMenu.add(this.TOGGLE_EXPERT_MODE_ACTION);
        toolsMenu.add(this.treePanel.getOperatorTree().INFO_OPERATOR_ACTION);
        toolsMenu.add(new JSeparator());
        toolsMenu.add(this.ATTRIBUTE_EDITOR_ACTION);
        toolsMenu.add(this.JVITO_ACTION);
        toolsMenu.add(new JSeparator());
        toolsMenu.add(this.messageViewer.CLEAR_MESSAGE_VIEWER_ACTION);
        toolsMenu.add(this.MANAGE_TEMPLATES_ACTION);
        toolsMenu.add(new JSeparator());
        toolsMenu.add(this.CHECK_FOR_UPDATES_ACTION);
        toolsMenu.add(this.SETTINGS_ACTION);
        menuBar.add(toolsMenu);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        JMenuItem aboutItem = new JMenuItem("About Yale...", new ImageIcon(Tools.getResource("icons/icon_about.gif")));
        aboutItem.setMnemonic(89);
        aboutItem.setToolTipText("Display information about Yale");
        aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    new AboutBox(MainFrame.this, MainFrame.TITLE, YaleGUI.getVersion(), "YALE - Yet Another Learning Environment\nCopyright (C) 2001-2005 Simon Fischer, Ralf Klinkenberg, Ingo Mierswa, Katharina Morik, Oliver Ritthoff\nArtificial Intelligence Unit, Computer Science Department, University of Dortmund, 44221 Dortmund, Germany\nemail: yale@ls8.cs.uni-dortmund.de, web: http://yale.cs.uni-dortmund.de/\n\nYale comes with ABSOLUTELY NO WARRANTY; This is free software,and you are welcome to redistribute it under certain conditions;see license information in the file named LICENSE.", new Image[]{ImageIO.read(Tools.getResource("yale_logo.gif"))}).setVisible(true);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        });
        helpMenu.add(aboutItem);
        helpMenu.add(this.TOTD_ACTION);
        helpMenu.add(this.TUTORIAL_ACTION);
        JMenuItem contents = new JMenuItem("Yale GUI Manual...", new ImageIcon(Tools.getResource("icons/icon_help.gif")));
        contents.setMnemonic(77);
        contents.setToolTipText("Browse the Yale GUI Manual.");
        contents.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Browser.showDialog(Tools.getResource("html/manual/YaleGUIManual.html"));
            }
        });
        helpMenu.add(contents);
        List allPlugins = Plugin.getAllPlugins();
        if (allPlugins.size() > 0) {
            helpMenu.addSeparator();
            Iterator i = allPlugins.iterator();
            while (i.hasNext()) {
                final Plugin plugin = (Plugin)i.next();
                JMenuItem aboutPluginItem = new JMenuItem("About " + plugin.getName() + "...");
                aboutPluginItem.setToolTipText("Display information about " + plugin.getName());
                aboutPluginItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        plugin.createAboutBox(MainFrame.this).setVisible(true);
                    }
                });
                helpMenu.add(aboutPluginItem);
            }
        }
        menuBar.add(helpMenu);
        JToolBar toolBar = new JToolBar();
        toolBar.setRollover(true);
        toolBar.removeNotify();
        toolBar.add(this.NEW_ACTION);
        toolBar.add(this.OPEN_ACTION);
        toolBar.add(this.SAVE_ACTION);
        toolBar.add(this.SAVE_AS_ACTION);
        toolBar.add(this.PRINT_ACTION);
        toolBar.addSeparator();
        toolBar.add(this.UNDO_ACTION);
        toolBar.add(this.REDO_ACTION);
        toolBar.addSeparator();
        toolBar.add(this.treePanel.getOperatorTree().NEW_OPERATOR_ACTION);
        toolBar.add(this.treePanel.getOperatorTree().COPY_ACTION);
        toolBar.add(this.treePanel.getOperatorTree().CUT_ACTION);
        toolBar.add(this.treePanel.getOperatorTree().PASTE_ACTION);
        toolBar.addSeparator();
        toolBar.add(this.RUN_ACTION);
        toolBar.add(this.RESUME_ACTION);
        toolBar.add(this.STOP_ACTION);
        toolBar.addSeparator();
        toolBar.add(this.VALIDATE_ACTION);
        toolBar.addSeparator();
        toolBar.add(this.TOGGLE_EXPERT_MODE_ACTION);
        this.getContentPane().add((Component)toolBar, "North");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.enableActions();
        this.addToUndoList();
        this.pack();
        this.splitPaneV.setDividerLocation(3 * this.splitPaneV.getHeight() / 4);
    }

    public void setTutorialMode(boolean mode) {
        this.tutorialMode = mode;
        if (this.tutorialMode) {
            this.SAVE_ACTION.setEnabled(false);
            this.SAVE_AS_ACTION.setEnabled(false);
        } else {
            this.SAVE_ACTION.setEnabled(false);
            this.SAVE_AS_ACTION.setEnabled(true);
        }
    }

    public MonitorPanel getMonitorPanel() {
        return this.monitorPanel;
    }

    public int getHorizontalDividerLocation() {
        return this.splitPaneV.getDividerLocation();
    }

    public int getVerticalDividerLocation() {
        return this.treePanel.getDividerLocation();
    }

    public void setDividerLocations(int h, int v) {
        this.splitPaneV.setDividerLocation(h);
        this.treePanel.setDividerLocation(v);
    }

    public void updateToggleExpertModeIcon() {
        ToggleExpertModeAction toggleAction = (ToggleExpertModeAction)this.TOGGLE_EXPERT_MODE_ACTION;
        toggleAction.updateIcon();
    }

    public OperatorPropertyTable getPropertyTable() {
        return this.treePanel.getPropertyTable();
    }

    public MessageViewer getMessageViewer() {
        return this.messageViewer;
    }

    public OperatorTree getOperatorTree() {
        return this.treePanel.getOperatorTree();
    }

    public ResultDisplay getResultDisplay() {
        return this.resultDisplay;
    }

    public void experimentEnded(IOContainer results) {
        if (results != null) {
            this.resultDisplay.setData(results, "Experiment results:");
            this.editorTabs.setSelectedComponent(this.resultDisplay);
            this.resultDisplay.showSomething();
        }
        this.statusBar.experimentEnded();
        this.experimentThread = null;
        this.enableActions();
    }

    public void breakpointReached(Operator operator, IOContainer ioContainer, int location) {
        LinkedList<JButton> additionalButtons = new LinkedList<JButton>();
        additionalButtons.add(new JButton(this.RESUME_ACTION));
        additionalButtons.add(new JButton(this.STOP_ACTION));
        this.resultDisplay.setData(ioContainer, "Results in application " + operator.getApplyCount() + " of " + operator.getName() + ":");
        this.editorTabs.setSelectedComponent(this.resultDisplay);
        this.resultDisplay.showSomething();
        ExperimentThread.beep("breakpoint");
    }

    public void resume() {
    }

    public void setExperiment(Experiment experiment) {
        if (this.experimentThread != null) {
            this.experimentThread.stopExperiment();
            this.experimentThread = null;
        }
        Yale.setExperiment(experiment);
        Yale.getExperiment().addBreakpointListener(this);
        Yale.getExperiment().addBreakpointListener(this.statusBar);
        Yale.getExperiment().getRootOperator().addExperimentListener(this.monitorPanel);
        Yale.getExperiment().getRootOperator().addExperimentListener(this.statusBar);
        this.setOperator(Yale.getExperiment().getRootOperator());
        this.enableActions();
        this.setTitle();
    }

    private void setOperator(Operator root) {
        this.treePanel.experimentChanged(root);
        this.editor.experimentChanged(root);
        this.experimentPanel.experimentChanged(root);
    }

    public void experimentChanged() {
        boolean oldValue = this.changed;
        this.changed = true;
        this.addToUndoList();
        if (!oldValue) {
            this.setTitle();
        }
        if (Yale.getExperiment().getExperimentFile() != null && !this.tutorialMode) {
            this.SAVE_ACTION.setEnabled(true);
        }
    }

    private void addToUndoList() {
        String lastStateXML = this.undoList.size() != 0 ? (String)this.undoList.get(this.undoList.size() - 1) : null;
        String currentStateXML = Yale.getExperiment().getRootOperator().getXML("");
        if (lastStateXML == null || !lastStateXML.equals(currentStateXML)) {
            if (this.undoIndex < this.undoList.size() - 1) {
                while (this.undoList.size() > this.undoIndex + 1) {
                    this.undoList.removeLast();
                }
            }
            this.undoList.add(currentStateXML);
            String maxSizeProperty = System.getProperty("yale.gui.undolist.size");
            int maxSize = Integer.parseInt(maxSizeProperty);
            while (this.undoList.size() > maxSize) {
                this.undoList.removeFirst();
            }
            this.undoIndex = this.undoList.size() - 1;
            this.enableUndoAction();
        }
    }

    private void undo() {
        if (this.undoIndex > 0) {
            --this.undoIndex;
            this.setExperimentIntoStateAt(this.undoIndex);
        }
        this.enableUndoAction();
    }

    private void redo() {
        if (this.undoIndex < this.undoList.size()) {
            ++this.undoIndex;
            this.setExperimentIntoStateAt(this.undoIndex);
        }
        this.enableUndoAction();
    }

    private void setExperimentIntoStateAt(int undoIndex) {
        String stateXML = (String)this.undoList.get(undoIndex);
        try {
            Yale.getExperiment().setupFromXML(stateXML);
            this.setExperiment(Yale.getExperiment());
            this.changed = true;
            this.setTitle();
            if (Yale.getExperiment().getExperimentFile() != null && !this.tutorialMode) {
                this.SAVE_ACTION.setEnabled(true);
            }
        }
        catch (Exception e) {
            SwingTools.showErrorMessage("While changing experiment:", e);
        }
    }

    private void enableUndoAction() {
        if (this.undoIndex > 0) {
            this.UNDO_ACTION.setEnabled(true);
        } else {
            this.UNDO_ACTION.setEnabled(false);
        }
        if (this.undoIndex < this.undoList.size() - 1) {
            this.REDO_ACTION.setEnabled(true);
        } else {
            this.REDO_ACTION.setEnabled(false);
        }
    }

    private void setTitle() {
        File file = null;
        if (Yale.getExperiment() != null) {
            file = Yale.getExperiment().getExperimentFile();
        }
        if (file != null) {
            this.setTitle("YALE (" + file.getName() + (this.changed ? "*" : "") + ")");
        } else {
            this.setTitle(TITLE);
        }
    }

    private String getBaseName() {
        if (Yale.getExperiment() != null) {
            File file = Yale.getExperiment().getExperimentFile();
            String base = file.getName();
            int dot = base.lastIndexOf(".");
            if (dot == -1) {
                return base;
            }
            return base.substring(0, dot);
        }
        return "unnamed";
    }

    private boolean close() {
        if (this.changed) {
            File file = Yale.getExperiment().getExperimentFile();
            if (file == null) {
                file = new File("unnamed.xml");
            }
            int choice = JOptionPane.showConfirmDialog(this, "Save changes to '" + file + "'?", "Save changes", 1);
            switch (choice) {
                case 0: {
                    this.save();
                    return true;
                }
                case 1: {
                    if (this.experimentThread != null) {
                        this.experimentThread.stopExperiment();
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    protected void open() {
        if (this.close()) {
            File file = SwingTools.chooseFile(this, null, true);
            if (file == null) {
                return;
            }
            this.open(file);
        }
    }

    protected void open(File file) {
        this.open(file, true);
    }

    protected void open(File file, boolean showInfo) {
        String text;
        try {
            try {
                YaleGUI.readExperimentFile(file);
                this.setExperiment(Yale.getExperiment());
            }
            catch (XMLException ex) {
                SwingTools.showErrorMessage("While loading '" + file + "'", ex);
                Experiment experiment = new Experiment();
                experiment.setExperimentFile(file);
                YaleGUI.setExperiment(experiment);
                this.setExperiment(experiment);
                this.editorTabs.setSelectedComponent(this.editor);
                try {
                    this.editor.updateText(Tools.readOutput(new BufferedReader(new FileReader(file))));
                }
                catch (BadLocationException e) {
                    SwingTools.showSimpleErrorMessage("While loading '" + file + "'", e);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            SwingTools.showErrorMessage("While loading '" + file + "'", ex);
            return;
        }
        this.resultDisplay.clear();
        this.SAVE_ACTION.setEnabled(false);
        this.changed = false;
        YaleGUI.useExperimentFile();
        this.updateRecentFileList();
        this.addToUndoList();
        this.setTitle();
        if (showInfo && Tools.booleanValue(System.getProperty("yale.gui.experimentinfo.show"), true) && (text = Yale.getExperiment().getRootOperator().getUserDescription()) != null && text.length() != 0) {
            ExperimentInfoScreen infoScreen = new ExperimentInfoScreen((Frame)this, file.getName(), text);
            infoScreen.setVisible(true);
        }
    }

    private void save() {
        try {
            File file = Yale.getExperiment().getExperimentFile();
            if (file == null) {
                file = SwingTools.chooseFile(this, new File("."), false);
                if (file == null) {
                    return;
                }
                Yale.getExperiment().setExperimentFile(file);
            }
            Yale.getExperiment().save();
            this.SAVE_ACTION.setEnabled(false);
            this.changed = false;
            this.setTitle();
            YaleGUI.useExperimentFile();
            this.updateRecentFileList();
            this.currentExperimentEditor.experimentChanged(Yale.getExperiment().getRootOperator());
        }
        catch (IOException ex) {
            SwingTools.showErrorMessage("Cannot save experiment file!", ex);
        }
    }

    private void exit() {
        block8: {
            block7: {
                if (!this.changed) break block7;
                File file = Yale.getExperiment().getExperimentFile();
                if (file == null) {
                    file = new File("unnamed.xml");
                }
                switch (JOptionPane.showConfirmDialog(this, "Save changes to '" + file + "'?", "Save changes", 1)) {
                    case 0: {
                        this.save();
                        if (this.changed) {
                            return;
                        }
                        break block8;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
                break block8;
            }
            if (JOptionPane.showConfirmDialog(this, "Really exit?", "Exit Yale", 0) != 0) {
                return;
            }
        }
        this.dispose();
        System.exit(0);
    }

    public void updateRecentFileList() {
        this.recentFilesMenu.removeAll();
        List recentFiles = YaleGUI.getRecentFiles();
        Iterator i = recentFiles.iterator();
        int j = 1;
        while (i.hasNext()) {
            final File recentFile = (File)i.next();
            JMenuItem menuItem = new JMenuItem(j + " " + recentFile.getPath());
            menuItem.setMnemonic(48 + j);
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.open(recentFile);
                }
            });
            this.recentFilesMenu.add(menuItem);
            ++j;
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.exit();
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void stateChanged(ChangeEvent e) {
        ExperimentEditor newEditor = (ExperimentEditor)((Object)this.editorTabs.getSelectedComponent());
        if (newEditor.equals(this.currentExperimentEditor)) {
            return;
        }
        try {
            this.currentExperimentEditor.validateExperiment();
            newEditor.experimentChanged(Yale.getExperiment().getRootOperator());
            this.currentExperimentEditor = newEditor;
        }
        catch (Exception ex) {
            switch (JOptionPane.showConfirmDialog(this, ex.toString() + "\nCancel to ignore changes, Ok to go on editing.", "Error", 2, 0)) {
                case 0: {
                    this.editorTabs.setSelectedComponent((Component)((Object)this.currentExperimentEditor));
                    break;
                }
                default: {
                    this.currentExperimentEditor.experimentChanged(Yale.getExperiment().getRootOperator());
                    this.currentExperimentEditor = newEditor;
                }
            }
        }
        this.enableActions();
    }

    public void enableActions() {
        boolean[] currentStates = new boolean[5];
        Operator op = this.treePanel.getOperatorTree().getSelectedOperator();
        if (op != null) {
            currentStates[0] = true;
            if (op instanceof OperatorChain) {
                currentStates[1] = true;
            }
            if (op.getParent() == null) {
                currentStates[2] = true;
            }
        }
        currentStates[4] = this.experimentThread != null && this.experimentThread.isAlive();
        currentStates[3] = this.treePanel.getOperatorTree().getClipBoard() != null;
        ConditionalAction.updateAll(currentStates);
    }

    public void checkForUpdates(boolean showFailureDialog) {
        this.updateCheckThread = new CheckForUpdatesThread(this, showFailureDialog);
        this.updateCheckThread.start();
    }

    static {
        Yale.registerYaleProperty(new ParameterTypeInt("yale.gui.fractiondigits.numbers", "The number of fraction digits of formatted numbers.", 0, Integer.MAX_VALUE, 3));
        Yale.registerYaleProperty(new ParameterTypeInt("yale.gui.fractiondigits.percent", "The number of fraction digits of formatted percent values.", 0, Integer.MAX_VALUE, 2));
        Yale.registerYaleProperty(new ParameterTypeStringCategory("yale.gui.plotter.default", "The default plotter which is used for plotting purposes.", PlotterPanel.PLOTTER_NAMES, PlotterPanel.PLOTTER_NAMES[0]));
        Yale.registerYaleProperty(new ParameterTypeInt("yale.gui.plotter.scatterplot.size", "The pixel size of each plot in the scatter plot.", 1, Integer.MAX_VALUE, 150));
        Yale.registerYaleProperty(new ParameterTypeInt("yale.gui.undolist.size", "Maximum number of states in the undo list.", 1, Integer.MAX_VALUE, 10));
        Yale.registerYaleProperty(new ParameterTypeInt("yale.gui.attributeeditor.rowlimit", "Maximum number of examples to use for the attribute editor. -1 for no limit.", -1, Integer.MAX_VALUE, 50));
        Yale.registerYaleProperty(new ParameterTypeBoolean("yale.gui.beep.success", "Beep on experiment success?", false));
        Yale.registerYaleProperty(new ParameterTypeBoolean("yale.gui.beep.error", "Beep on error?", false));
        Yale.registerYaleProperty(new ParameterTypeBoolean("yale.gui.beep.breakpoint", "Beep when breakpoint reached?", false));
        Yale.registerYaleProperty(new ParameterTypeInt("yale.gui.resultviewer.attributelimit", "Limit number of displayed attributes to this number. -1 for no limit.", -1, Integer.MAX_VALUE, 100));
        Yale.registerYaleProperty(new ParameterTypeInt("yale.gui.resultviewer.examplelimit", "Limit number of displayed examples in plot view to this number. -1 for no limit.", -1, Integer.MAX_VALUE, 1000));
        Yale.registerYaleProperty(new ParameterTypeInt("yale.gui.messageviewer.rowlimit", "Limit number of displayed rows in the message viewer. -1 for no limit.", -1, Integer.MAX_VALUE, 1000));
        Yale.registerYaleProperty(new ParameterTypeColor("yale.gui.messageviewer.highlight.warnings", "The color for warnings in the message viewer.", Color.blue));
        Yale.registerYaleProperty(new ParameterTypeColor("yale.gui.messageviewer.highlight.errors", "The color for errors in the message viewer.", Color.red));
        Yale.registerYaleProperty(new ParameterTypeBoolean("yale.gui.experimentinfo.show", "Shows experiment info screen after loading?", true));
        Yale.registerYaleProperty(new ParameterTypeColor("yale.gui.xml.highlight.main", "The color for the main keywords like operator and parameter.", Color.red));
        Yale.registerYaleProperty(new ParameterTypeColor("yale.gui.xml.highlight.other", "The color for other keywords like name, key, and value.", Color.blue));
        Yale.registerYaleProperty(new ParameterTypeColor("yale.gui.xml.highlight.quote", "The color for quoted text.", Color.pink));
        UIManager.LookAndFeelInfo[] plafInfos = UIManager.getInstalledLookAndFeels();
        String[] plafs = new String[plafInfos.length + 2];
        plafs[0] = "system";
        plafs[1] = "cross_platform";
        for (int i = 0; i < plafInfos.length; ++i) {
            plafs[i + 2] = plafInfos[i].getClassName();
        }
        Yale.registerYaleProperty(new ParameterTypeStringCategory("yale.gui.plaf", "The pluggable look and feel to use. Specify 'system', 'cross_platform' or a classname.", plafs, "system"));
        Yale.registerYaleProperty(new ParameterTypeBoolean("yale.gui.tip.show", "Show Tip of the Day at start up time?", true));
    }

    private class CheckForUpdatesAction
    extends AbstractAction {
        private CheckForUpdatesAction() {
            super("Check for updates...", new ImageIcon(Tools.getResource("icons/icon_updates.gif")));
            this.putValue("ShortDescription", "Check for new Yale versions.");
            this.putValue("MnemonicKey", new Integer(85));
        }

        public void actionPerformed(ActionEvent e) {
            MainFrame.this.checkForUpdates(true);
        }
    }

    private class JViToAction
    extends AbstractAction {
        private JViToAction() {
            super("Start JViTo...", new ImageIcon(Tools.getResource("icons/icon_jvito.gif")));
            this.putValue("ShortDescription", "Starts JViTo (Java Visualization Tool).");
            this.putValue("MnemonicKey", new Integer(86));
        }

        public void actionPerformed(ActionEvent e) {
            if (!JViTo.isApplicationOpen()) {
                JViTo.loadResources();
                JViTo.setPreferencesFile(ParameterService.getUserYaleDir() + File.separator + "jvito_preferences.xml");
                JViTo.initApplication(true);
            }
            JViTo.getApplication().setVisible(true);
        }
    }

    private class AttributeEditorAction
    extends AbstractAction {
        private AttributeEditorAction() {
            super("Start Attribute Editor...", new ImageIcon(Tools.getResource("icons/icon_attribute_editor.gif")));
            this.putValue("ShortDescription", "Starts the Attribute Editor (can be used for XML meta data creation for data files).");
            this.putValue("MnemonicKey", new Integer(65));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ExampleSource exampleSource = (ExampleSource)OperatorService.createOperator("ExampleSource");
                AttributeEditorDialog dialog = new AttributeEditorDialog(MainFrame.this, exampleSource, null);
                dialog.setVisible(true);
            }
            catch (OperatorCreationException ex) {
                SwingTools.showVerySimpleErrorMessage("Cannot start attribute editor: not possible to create an ExampleSource operator!");
            }
        }
    }

    private class RedoAction
    extends AbstractAction {
        private RedoAction() {
            super("Redo", new ImageIcon(Tools.getResource("icons/icon_redo.gif")));
            this.putValue("ShortDescription", "Perform the next action.");
            this.putValue("MnemonicKey", new Integer(82));
        }

        public void actionPerformed(ActionEvent e) {
            MainFrame.this.redo();
        }
    }

    private class UndoAction
    extends AbstractAction {
        private UndoAction() {
            super("Undo", new ImageIcon(Tools.getResource("icons/icon_undo.gif")));
            this.putValue("ShortDescription", "Roll back the last action.");
            this.putValue("MnemonicKey", new Integer(85));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 2));
        }

        public void actionPerformed(ActionEvent e) {
            MainFrame.this.undo();
        }
    }

    private class TotDAction
    extends AbstractAction {
        private TotDAction() {
            super("Tip of the Day...", new ImageIcon(Tools.getResource("icons/icon_totd.gif")));
            this.putValue("ShortDescription", "Shows a short tip for Yale users.");
            this.putValue("MnemonicKey", new Integer(68));
        }

        public void actionPerformed(ActionEvent e) {
            new TotDDialog().setVisible(true);
        }
    }

    private class TutorialAction
    extends AbstractAction {
        private TutorialAction() {
            super("Yale Tutorial...", new ImageIcon(Tools.getResource("icons/icon_tutorial.gif")));
            this.putValue("ShortDescription", "Starts the Yale online tutorial.");
            this.putValue("MnemonicKey", new Integer(84));
        }

        public void actionPerformed(ActionEvent e) {
            if (MainFrame.this.close()) {
                new Tutorial(MainFrame.this).setVisible(true);
            }
        }
    }

    private class ToggleExpertModeAction
    extends AbstractAction {
        private ImageIcon expertModeIcon = new ImageIcon(Tools.getResource("icons/icon_expert_mode_on.gif"));
        private ImageIcon beginnerModeIcon = new ImageIcon(Tools.getResource("icons/icon_expert_mode_off.gif"));

        private ToggleExpertModeAction() {
            super("Toggle expert mode...");
            this.putValue("ShortDescription", "Toggles between expert and beginner mode.");
            this.putValue("MnemonicKey", new Integer(84));
            this.putValue("SmallIcon", this.expertModeIcon);
        }

        public void actionPerformed(ActionEvent e) {
            MainFrame.this.getPropertyTable().toggleExpertMode();
            this.updateIcon();
        }

        public void updateIcon() {
            if (MainFrame.this.getPropertyTable().isExpertMode()) {
                this.putValue("SmallIcon", this.beginnerModeIcon);
            } else {
                this.putValue("SmallIcon", this.expertModeIcon);
            }
        }
    }

    private class SettingsAction
    extends AbstractAction {
        private SettingsAction() {
            super("Preferences...", new ImageIcon(Tools.getResource("icons/icon_preferences.gif")));
            this.putValue("ShortDescription", "Edit Yale settings.");
            this.putValue("MnemonicKey", new Integer(80));
        }

        public void actionPerformed(ActionEvent e) {
            new SettingsDialog(MainFrame.this).setVisible(true);
        }
    }

    private class ExitAction
    extends AbstractAction {
        private ExitAction() {
            super("Exit", new ImageIcon(Tools.getResource("icons/icon_exit.gif")));
            this.putValue("ShortDescription", "Exit Yale");
            this.putValue("MnemonicKey", new Integer(88));
        }

        public void actionPerformed(ActionEvent e) {
            MainFrame.this.exit();
        }
    }

    private class ExportAction
    extends AbstractAction {
        private ExportAction() {
            super("Export...", new ImageIcon(Tools.getResource("icons/icon_export.gif")));
            this.putValue("ShortDescription", "Export experiment");
            this.putValue("MnemonicKey", new Integer(69));
        }

        public void actionPerformed(ActionEvent e) {
            ExportDialog exportDialog = new ExportDialog(MainFrame.TITLE);
            exportDialog.showExportDialog((Component)MainFrame.this, "Export", ((ExperimentEditor)((Object)MainFrame.this.editorTabs.getSelectedComponent())).getMainComponent(), MainFrame.this.getBaseName() + "_" + MainFrame.this.editorTabs.getTitleAt(MainFrame.this.editorTabs.getSelectedIndex()));
        }
    }

    private class PrintAction
    extends AbstractAction {
        private PrintAction() {
            super("Print...", new ImageIcon(Tools.getResource("icons/icon_print.gif")));
            this.putValue("ShortDescription", "Print experiment");
            this.putValue("MnemonicKey", new Integer(80));
        }

        public void actionPerformed(ActionEvent e) {
            MainFrame.this.printerJob.setPrintable(new ComponentPrinter(((ExperimentEditor)((Object)MainFrame.this.editorTabs.getSelectedComponent())).getMainComponent()));
            if (MainFrame.this.printerJob.printDialog()) {
                try {
                    MainFrame.this.printerJob.print();
                }
                catch (PrinterException pe) {
                    SwingTools.showSimpleErrorMessage("Printer error", pe);
                }
            }
        }
    }

    private class ManageTemplatesAction
    extends AbstractAction {
        private ManageTemplatesAction() {
            super("Manage Templates...", new ImageIcon(Tools.getResource("icons/icon_manage_templates.gif")));
            this.putValue("ShortDescription", "Manage previously saved templates...");
            this.putValue("MnemonicKey", new Integer(77));
        }

        public void actionPerformed(ActionEvent e) {
            ManageTemplatesDialog dialog = new ManageTemplatesDialog(MainFrame.this);
            dialog.setVisible(true);
        }
    }

    private class SaveAsTemplateAction
    extends AbstractAction {
        private SaveAsTemplateAction() {
            super("Save as Template...", new ImageIcon(Tools.getResource("icons/icon_saveas.gif")));
            this.putValue("ShortDescription", "Save experiment file as template...");
            this.putValue("MnemonicKey", new Integer(84));
        }

        public void actionPerformed(ActionEvent e) {
            ExperimentOperator rootOperator = Yale.getExperiment().getRootOperator();
            SaveAsTemplateDialog dialog = new SaveAsTemplateDialog(MainFrame.this, rootOperator);
            dialog.setVisible(true);
            if (dialog.isOk()) {
                Template template = dialog.getTemplate(rootOperator);
                String name = template.getName();
                try {
                    File templateFile = ParameterService.getUserConfigFile(name + ".template");
                    template.save(templateFile);
                    File templateXmlFile = ParameterService.getUserConfigFile(name + ".xml");
                    Yale.getExperiment().save(templateXmlFile);
                }
                catch (IOException ioe) {
                    SwingTools.showSimpleErrorMessage("Cannot write template files:", ioe);
                }
            }
        }
    }

    private class SaveAsAction
    extends AbstractAction {
        private SaveAsAction() {
            super("Save as...", new ImageIcon(Tools.getResource("icons/icon_saveas.gif")));
            this.putValue("ShortDescription", "Save experiment file as...");
            this.putValue("MnemonicKey", new Integer(65));
        }

        public void actionPerformed(ActionEvent e) {
            File file = SwingTools.chooseFile(MainFrame.this, null, false);
            if (file != null) {
                Yale.getExperiment().setExperimentFile(file);
                MainFrame.this.save();
            }
        }
    }

    private class SaveAction
    extends AbstractAction {
        private SaveAction() {
            super("Save", new ImageIcon(Tools.getResource("icons/icon_save.gif")));
            this.setEnabled(false);
            this.putValue("ShortDescription", "Save experiment file");
            this.putValue("MnemonicKey", new Integer(83));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
        }

        public void actionPerformed(ActionEvent e) {
            MainFrame.this.save();
        }
    }

    private class OpenAction
    extends AbstractAction {
        private OpenAction() {
            super("Open...", new ImageIcon(Tools.getResource("icons/icon_open.gif")));
            this.putValue("ShortDescription", "Open experiment file");
            this.putValue("MnemonicKey", new Integer(79));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
        }

        public void actionPerformed(ActionEvent e) {
            MainFrame.this.open();
        }
    }

    private class NewAction
    extends AbstractAction {
        private NewAction() {
            super("New", new ImageIcon(Tools.getResource("icons/icon_new.gif")));
            this.putValue("ShortDescription", "Create empty experiment");
            this.putValue("MnemonicKey", new Integer(78));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 2));
        }

        public void actionPerformed(ActionEvent e) {
            if (MainFrame.this.close()) {
                MainFrame.this.resultDisplay.clear();
                MainFrame.this.setExperiment(new Experiment());
                MainFrame.this.addToUndoList();
            }
        }
    }

    private class StopAction
    extends ConditionalAction {
        private StopAction() {
            super("Stop", new ImageIcon(Tools.getResource("icons/icon_stop.gif")));
            this.putValue("ShortDescription", "Stop experiment execution");
            this.putValue("MnemonicKey", new Integer(83));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 2));
            this.setCondition(4, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            MainFrame.this.experimentThread.stopExperiment();
            ExperimentThread experimentThread = MainFrame.this.experimentThread;
            synchronized (experimentThread) {
                MainFrame.this.experimentThread.notify();
            }
            try {
                LogService.logMessage("Waiting for experiment thread to die.", 2);
                if (MainFrame.this.experimentThread != null) {
                    MainFrame.this.experimentThread.join();
                }
                LogService.logMessage("Experiment thread died.", 2);
            }
            catch (InterruptedException ex) {
                SwingTools.showErrorMessage("While waiting for death of experiment thread:", ex);
            }
            MainFrame.this.enableActions();
        }
    }

    private class ResumeAction
    extends ConditionalAction {
        private ResumeAction() {
            super("Resume", new ImageIcon(Tools.getResource("icons/icon_resume.gif")));
            this.putValue("ShortDescription", "Resume experiment");
            this.putValue("MnemonicKey", new Integer(85));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
            this.setCondition(4, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            ExperimentThread experimentThread = MainFrame.this.experimentThread;
            synchronized (experimentThread) {
                MainFrame.this.experimentThread.notify();
            }
        }
    }

    private class RunAction
    extends ConditionalAction {
        private RunAction() {
            super("Run", new ImageIcon(Tools.getResource("icons/icon_run.gif")));
            this.putValue("ShortDescription", "Run experiment");
            this.putValue("MnemonicKey", new Integer(82));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
            this.setCondition(4, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if ((MainFrame.this.changed || Yale.getExperiment().getExperimentFile() == null) && !MainFrame.this.tutorialMode && JOptionPane.showConfirmDialog(MainFrame.this, "Save experiment file?", "Save?", 0) == 0) {
                MainFrame.this.save();
            }
            MainFrame.this.experimentThread = new ExperimentThread(Yale.getExperiment());
            try {
                LogService.initGUI();
                MainFrame.this.resultDisplay.clear();
                MainFrame.this.experimentThread.start();
            }
            catch (Throwable t) {
                SwingTools.showSimpleErrorMessage("Cannot start experiment!", t);
            }
            finally {
                MainFrame.this.enableActions();
            }
        }
    }

    private class WizardAction
    extends AbstractAction {
        private WizardAction() {
            super("Wizard...", new ImageIcon(Tools.getResource("icons/icon_wizard.gif")));
            this.putValue("ShortDescription", "Start the YALE wizard");
            this.putValue("MnemonicKey", new Integer(87));
        }

        public void actionPerformed(ActionEvent e) {
            new WizardDialog(MainFrame.this).setVisible(true);
        }
    }

    private class ValidateExperiment
    extends ConditionalAction {
        private ValidateExperiment() {
            super("Validate experiment", new ImageIcon(Tools.getResource("icons/icon_check_experiment.gif")));
            this.putValue("ShortDescription", "Validate input/output and experiment structure");
            this.putValue("MnemonicKey", new Integer(86));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(115, 0));
            this.setCondition(4, -1);
        }

        public void actionPerformed(ActionEvent e) {
            Yale.getExperiment().checkExperiment();
            MainFrame.this.treePanel.getOperatorTree().refresh();
        }
    }
}

