/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import javax.swing.JPanel;

public class InfoBox
extends JPanel {
    public static final Paint NORTH_PAINT = new Color(99, 99, 156);
    public static final int RAINBOW_THICKNESS = 4;
    private static final Paint[] RAINBOW_COLORS = new Paint[]{new Color(156, 0, 49), new Color(206, 156, 156), new Color(206, 206, 99), new Color(155, 156, 0)};
    private static final Font PRODUCT_NAME_FONT = new Font("LucidaSans", 0, 12);
    private static final Paint PRODUCT_NAME_PAINT = Color.white;
    private static final Paint PRODUCT_NAME_BACKGROUND = Color.black;
    public static final int PRODUCT_NAME_X = 15;
    private int northHeight;
    private int width;
    private int height;
    private String productName;
    private String version;
    private int productFontSize;
    private int productNameHeight;
    private int versionFontSize;

    public InfoBox(int width, int height, int northHeight, String productName, int productNameHeight, String version, int versionHeight) {
        this.width = width;
        this.height = height;
        this.northHeight = northHeight;
        this.productFontSize = (int)((double)productNameHeight * 0.8);
        this.productName = productName;
        this.productNameHeight = productNameHeight;
        this.version = version;
        this.versionFontSize = (int)((double)versionHeight * 0.8);
        this.setPreferredSize(new Dimension(width, height));
        this.setMaximumSize(new Dimension(width, height));
        this.setMinimumSize(new Dimension(width, height));
    }

    protected void drawNorth(Graphics2D g) {
        g.setPaint(NORTH_PAINT);
        g.fillRect(0, 0, this.width, this.northHeight);
    }

    private void drawRainbow(Graphics2D g) {
        for (int i = 0; i < RAINBOW_COLORS.length; ++i) {
            g.setPaint(RAINBOW_COLORS[i]);
            g.fillRect(i * this.width / RAINBOW_COLORS.length, 0, this.width / RAINBOW_COLORS.length + 1, 4);
        }
    }

    private void drawProductName(Graphics2D g) {
        g.setPaint(PRODUCT_NAME_BACKGROUND);
        g.fillRect(0, 0, this.width, this.productNameHeight);
        Font productFont = PRODUCT_NAME_FONT.deriveFont((float)this.productFontSize);
        g.setFont(productFont);
        g.setPaint(PRODUCT_NAME_PAINT);
        g.drawString(this.productName, 15, this.productNameHeight / 2 + this.productFontSize / 3);
        g.setFont(PRODUCT_NAME_FONT.deriveFont((float)this.versionFontSize));
        int width = (int)productFont.getStringBounds(this.productName + " ", g.getFontRenderContext()).getWidth();
        g.drawString(this.version, 15 + width, this.productNameHeight / 2 + this.productFontSize / 3);
    }

    public void drawMain(Graphics2D g) {
    }

    public static void drawLogos(Graphics g, Image[] logos) {
        int x = 15;
        for (int i = 0; i < logos.length; ++i) {
            g.drawImage(logos[i], x, 0, null);
            x += logos[i].getWidth(null) + 11;
        }
    }

    public static Dimension getLogoSize(Image[] logos) {
        int w = 15;
        int h = 0;
        for (int i = 0; i < logos.length; ++i) {
            w += 15 + logos[i].getWidth(null);
            h = Math.max(h, logos[i].getHeight(null));
        }
        return new Dimension(w, h);
    }

    public int getMainHeight() {
        return this.height - (this.northHeight + 4 + this.productNameHeight);
    }

    public void paint(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        Graphics2D tempG = (Graphics2D)g.create(0, 0, this.width, this.northHeight);
        this.drawNorth(g);
        tempG.dispose();
        tempG = (Graphics2D)g.create(0, this.northHeight, this.width, 4);
        this.drawRainbow(tempG);
        tempG.dispose();
        tempG = (Graphics2D)g.create(0, this.northHeight + 4, this.width, this.productNameHeight);
        this.drawProductName(tempG);
        tempG.dispose();
        tempG = (Graphics2D)g.create(0, this.northHeight + 4 + this.productNameHeight, this.width, this.getMainHeight());
        this.drawMain(tempG);
        tempG.dispose();
    }
}

