/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.NoBugError;
import edu.udo.cs.yale.gui.BugAssistant;
import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.XMLException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ErrorDialog
extends JDialog {
    JButton editButton = new JButton("Edit");

    private ErrorDialog(String title, String mainText, Icon icon, final Throwable error, boolean bugReport) {
        super((Frame)YaleGUI.getMainFrame(), title);
        this.setTitle(title);
        if (JDialog.isDefaultLookAndFeelDecorated() && UIManager.getLookAndFeel().getSupportsWindowDecorations()) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(4);
        }
        this.getContentPane().setLayout(new BorderLayout());
        JPanel box = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        box.setLayout(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 11, 5, 11);
        c.gridwidth = -1;
        JLabel iconLabel = new JLabel(icon);
        iconLabel.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        gbl.setConstraints(iconLabel, c);
        box.add(iconLabel);
        c.gridwidth = 0;
        c.weightx = 1.0;
        JLabel text = new JLabel(mainText);
        text.setFont(text.getFont().deriveFont(0));
        text.setPreferredSize(new Dimension((int)((double)YaleGUI.getMainFrame().getWidth() * 0.5), Math.max(150, (int)((double)YaleGUI.getMainFrame().getHeight() * 0.15))));
        gbl.setConstraints(text, c);
        box.add(text);
        final Box detailBox = new Box(1);
        final StackTraceList stl = new StackTraceList(error);
        JScrollPane detailPane = new JScrollPane(stl);
        detailPane.setPreferredSize(new Dimension((int)((double)YaleGUI.getMainFrame().getWidth() * 0.5), Math.max(150, (int)((double)YaleGUI.getMainFrame().getHeight() * 0.25))));
        detailBox.add(detailPane);
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                stl.edit();
            }
        });
        JPanel detailButtonPanel = new JPanel(new FlowLayout(2));
        detailButtonPanel.add(this.editButton);
        detailBox.add(detailButtonPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton detailButton = new JButton(){
            private boolean more = true;
            {
                this.setText("Details >>");
                this.addActionListener(new ActionListener(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent e) {
                        if (3.access$400(this.this$1)) {
                            3.access$600(this.this$1).getContentPane().add((Component)3.access$500(this.this$1), "South");
                            this.this$1.setText("<< Hide");
                        } else {
                            3.access$600(this.this$1).getContentPane().remove(3.access$500(this.this$1));
                            this.this$1.setText("Details >>");
                        }
                        3.access$600(this.this$1).pack();
                        3.access$402(this.this$1, !3.access$400(this.this$1));
                    }
                });
            }

            static /* synthetic */ boolean access$400(3 x0) {
                return x0.more;
            }

            static /* synthetic */ Box access$500(3 x0) {
                return x0.detailBox;
            }

            static /* synthetic */ ErrorDialog access$600(3 x0) {
                return x0.ErrorDialog.this;
            }

            static /* synthetic */ boolean access$402(3 x0, boolean x1) {
                x0.more = x1;
                return x0.more;
            }
        };
        buttonPanel.add(detailButton);
        if (bugReport) {
            JButton report = new JButton("Send bug report...");
            report.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new BugAssistant(error).setVisible(true);
                }
            });
            buttonPanel.add(report);
        }
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ErrorDialog.this.dispose();
            }
        });
        buttonPanel.add(close);
        c.weighty = 0.0;
        gbl.setConstraints(buttonPanel, c);
        box.add(buttonPanel);
        this.getContentPane().add((Component)box, "Center");
        this.pack();
    }

    public static ErrorDialog create(String message, Throwable t) {
        if (t instanceof NoBugError) {
            NoBugError ue = (NoBugError)((Object)t);
            return new ErrorDialog("Error " + ue.getCode() + ": " + ue.getErrorName(), ue.getHTMLMessage(), UIManager.getIcon("OptionPane.warningIcon"), t, false);
        }
        return new ErrorDialog("Exception occured", "<html><b>" + Tools.classNameWOPackage(t.getClass()) + "</b><br>" + Tools.escapeHTML(message) + "<br>" + "Message: " + Tools.escapeHTML(t.getMessage()) + "</html>", UIManager.getIcon("OptionPane.errorIcon"), t, !(t instanceof XMLException));
    }

    private static void appendAllStackTraces(JTextArea text, Throwable throwable) {
        while (throwable != null) {
            ErrorDialog.appendStackTrace(text, throwable);
            if ((throwable = throwable.getCause()) == null) continue;
            text.append("\nCause:\n");
        }
    }

    private static void appendStackTrace(JTextArea text, Throwable throwable) {
        text.append("Exception:\t" + throwable.getClass().getName() + "\n");
        text.append("Message:\t" + throwable.getMessage() + "\n");
        text.append("Stack trace:\n");
        for (int i = 0; i < throwable.getStackTrace().length; ++i) {
            text.append("  " + throwable.getStackTrace()[i] + "\n");
        }
    }

    private class StackTraceList
    extends JList {
        public StackTraceList(Throwable t) {
            super(new DefaultListModel());
            this.setFont(this.getFont().deriveFont(0));
            this.setSelectionMode(0);
            this.appendAllStackTraces(t);
            this.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ StackTraceList this$1;
                {
                    this.this$1 = this$1;
                }

                public void valueChanged(ListSelectionEvent e) {
                    if (this.this$1.getSelectedIndex() >= 0) {
                        if (!(this.this$1.getSelectedValue() instanceof FormattedStackTraceElement)) {
                            StackTraceList.access$000((StackTraceList)this.this$1).editButton.setEnabled(false);
                        } else {
                            StackTraceList.access$000((StackTraceList)this.this$1).editButton.setEnabled(true);
                        }
                    } else {
                        StackTraceList.access$000((StackTraceList)this.this$1).editButton.setEnabled(true);
                    }
                }
            });
        }

        private DefaultListModel model() {
            return (DefaultListModel)this.getModel();
        }

        private void appendAllStackTraces(Throwable throwable) {
            while (throwable != null) {
                this.appendStackTrace(throwable);
                if ((throwable = throwable.getCause()) == null) continue;
                this.model().addElement("");
                this.model().addElement("Cause");
            }
        }

        private void appendStackTrace(Throwable throwable) {
            this.model().addElement("Exception: " + throwable.getClass().getName());
            this.model().addElement("Message: " + throwable.getMessage());
            this.model().addElement("Stack trace:\n");
            for (int i = 0; i < throwable.getStackTrace().length; ++i) {
                this.model().addElement(new FormattedStackTraceElement(throwable.getStackTrace()[i]));
            }
        }

        private void edit() {
            try {
                Object o = this.getSelectedValue();
                if (o == null) {
                    return;
                }
                if (!(o instanceof FormattedStackTraceElement)) {
                    return;
                }
                StackTraceElement ste = ((FormattedStackTraceElement)o).ste;
                File file = Tools.findSourceFile(ste);
                if (file != null) {
                    Tools.launchFileEditor(file, ste.getLineNumber());
                }
            }
            catch (Throwable t) {
                SwingTools.showSimpleErrorMessage("Cannot launch editor.", t);
            }
        }

        static /* synthetic */ ErrorDialog access$000(StackTraceList x0) {
            return x0.ErrorDialog.this;
        }
    }

    private class FormattedStackTraceElement {
        private StackTraceElement ste;

        private FormattedStackTraceElement(StackTraceElement ste) {
            this.ste = ste;
        }

        public String toString() {
            return "  " + this.ste;
        }
    }
}

