/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.gui.PropertyCellEditor;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.operator.parameter.ParameterTypeColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JTable;

public class ColorCellEditor
extends AbstractCellEditor
implements PropertyCellEditor {
    private ParameterTypeColor type;
    private JButton button = new JButton("Choose color...");

    public ColorCellEditor(ParameterTypeColor type) {
        this.type = type;
        this.button.setToolTipText(type.getDescription());
        this.button.setBackground(this.transformString2Color((String)type.getDefaultValue()));
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorCellEditor.this.buttonPressed();
            }
        });
    }

    private void buttonPressed() {
        Color newColor = JColorChooser.showDialog(YaleGUI.getMainFrame(), "Choose Color", this.transformString2Color((String)this.type.getDefaultValue()));
        if (newColor != null) {
            this.button.setBackground(newColor);
            this.fireEditingStopped();
        } else {
            this.fireEditingCanceled();
        }
    }

    public Object getCellEditorValue() {
        Color color = this.button.getBackground();
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        if (value == null) {
            this.button.setBackground(this.transformString2Color((String)this.type.getDefaultValue()));
        } else {
            Color color = this.transformString2Color((String)value);
            this.button.setBackground(color);
        }
        return this.button;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public boolean useEditorAsRenderer() {
        return true;
    }

    private Color transformString2Color(String value) {
        String[] colors = value.split(",");
        Color color = new Color(Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]));
        return color;
    }
}

