/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class Browser
extends JEditorPane
implements HyperlinkListener {
    public Browser() {
        this.setEditable(false);
        this.setMargin(new Insets(5, 5, 5, 5));
        this.addHyperlinkListener(this);
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)this.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                try {
                    this.setPage(e.getURL());
                }
                catch (Throwable t) {
                    SwingTools.showErrorMessage("While following link:", t);
                }
            }
        }
    }

    private JMenuItem createItem(String name, final URL url) {
        JMenuItem item = new JMenuItem(name);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Browser.this.setPage(url);
                }
                catch (IOException t) {
                    SwingTools.showErrorMessage("Cannot find '" + url + "'", t);
                }
            }
        });
        return item;
    }

    public static void showDialog(URL url) {
        Browser browser = new Browser();
        JDialog dialog = new JDialog();
        dialog.setTitle("Yale Browser");
        JMenuBar menuBar = new JMenuBar();
        JMenu visitMenu = new JMenu("Browse");
        visitMenu.add(browser.createItem("Yale GUI Manual", Tools.getResource("html/manual/Manual.html")));
        try {
            visitMenu.add(browser.createItem("Yale@WWW", new URL("http://yale.cs.uni-dortmund.de")));
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        visitMenu.add(browser.createItem("License", Tools.getResource("LICENSE.html")));
        menuBar.add(visitMenu);
        dialog.setJMenuBar(menuBar);
        JScrollPane editorScrollPane = new JScrollPane(browser);
        editorScrollPane.setPreferredSize(new Dimension(600, 500));
        dialog.getContentPane().add(editorScrollPane);
        dialog.pack();
        dialog.setVisible(true);
        try {
            browser.setPage(url);
        }
        catch (Throwable e) {
            SwingTools.showErrorMessage("Cannot find '" + url + "'!", e);
        }
    }
}

