/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.gui.AttributeWeightsTableModel;
import edu.udo.cs.yale.gui.SwingTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class AttributeWeightsDialog
extends JDialog {
    private boolean ok = false;
    private AttributeWeightsTableModel attributeTableModel;
    private JTextField minWeightField = new JTextField("0.0");
    private JCheckBox minWeightCheckBox = new JCheckBox("Show smaller weights");
    private JLabel selectionCount = new JLabel();

    public AttributeWeightsDialog(AttributeWeights weights) {
        super((Frame)null, "Attribute Weights", true);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributeWeightsDialog.this.ok = true;
                AttributeWeightsDialog.this.dispose();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributeWeightsDialog.this.ok = false;
                AttributeWeightsDialog.this.dispose();
            }
        });
        buttonPanel.add(cancelButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.attributeTableModel = new AttributeWeightsTableModel(weights);
        JTable weightTable = new JTable(){

            public TableCellEditor getCellEditor(int row, int column) {
                if (column == 1) {
                    return AttributeWeightsDialog.this.attributeTableModel.getWeightEditor(row);
                }
                return super.getCellEditor(row, column);
            }

            public TableCellRenderer getCellRenderer(int row, int column) {
                if (column == 1) {
                    return AttributeWeightsDialog.this.attributeTableModel.getWeightEditor(row);
                }
                return super.getCellRenderer(row, column);
            }
        };
        weightTable.setColumnSelectionAllowed(false);
        weightTable.setSelectionMode(0);
        weightTable.setRowHeight(weightTable.getRowHeight() + 8);
        weightTable.getTableHeader().setReorderingAllowed(false);
        weightTable.setModel(this.attributeTableModel);
        this.attributeTableModel.addMouseListenerToHeaderInTable(weightTable);
        JScrollPane scrollPane = new JScrollPane(weightTable);
        this.getContentPane().add((Component)scrollPane, "Center");
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(layout);
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(11, 11, 11, 11);
        final JComboBox<String> viewModes = new JComboBox<String>(AttributeWeightsTableModel.VIEW_MODES);
        viewModes.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AttributeWeightsDialog.this.attributeTableModel.setViewMode(viewModes.getSelectedIndex());
                AttributeWeightsDialog.this.update();
            }
        });
        layout.setConstraints(viewModes, c);
        controlPanel.add(viewModes);
        JButton updateButton = new JButton("Update");
        updateButton.setToolTipText("Click to update the view.");
        updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributeWeightsDialog.this.update();
            }
        });
        layout.setConstraints(updateButton, c);
        controlPanel.add(updateButton);
        JLabel minWeightLabel = new JLabel("Min weight:");
        c.weightx = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(minWeightLabel, c);
        controlPanel.add(minWeightLabel);
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.minWeightField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributeWeightsDialog.this.update();
            }
        });
        layout.setConstraints(this.minWeightField, c);
        controlPanel.add(this.minWeightField);
        this.minWeightCheckBox.setToolTipText("If not marked only weights greater than min weight will be shown.");
        this.minWeightCheckBox.setSelected(true);
        this.minWeightCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributeWeightsDialog.this.update();
            }
        });
        layout.setConstraints(this.minWeightCheckBox, c);
        controlPanel.add(this.minWeightCheckBox);
        layout.setConstraints(this.selectionCount, c);
        controlPanel.add(this.selectionCount);
        this.updateSelectionCounter();
        JPanel dummy = new JPanel();
        c.weighty = 1.0;
        layout.setConstraints(dummy, c);
        controlPanel.add(dummy);
        c.weighty = 0.0;
        final JCheckBox overwriteCheckBox = new JCheckBox("overwrite");
        overwriteCheckBox.setToolTipText("If marked loaded weights will overwrite the current ones (weight of 0 does always overwrite).");
        overwriteCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributeWeightsDialog.this.attributeTableModel.setOverwriteMode(overwriteCheckBox.isSelected());
            }
        });
        layout.setConstraints(overwriteCheckBox, c);
        controlPanel.add(overwriteCheckBox);
        JButton loadButton = new JButton("Load");
        loadButton.setToolTipText("Load weights from file.");
        loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributeWeightsDialog.this.load();
            }
        });
        layout.setConstraints(loadButton, c);
        controlPanel.add(loadButton);
        JButton saveButton = new JButton("Save");
        saveButton.setToolTipText("Save current weights to file.");
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributeWeightsDialog.this.save();
            }
        });
        layout.setConstraints(saveButton, c);
        controlPanel.add(saveButton);
        controlPanel.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        this.getContentPane().add((Component)controlPanel, "West");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void updateSelectionCounter() {
        this.selectionCount.setText(this.attributeTableModel.getNumberOfSelected() + " selected / " + this.attributeTableModel.getTotalNumber() + " total");
    }

    private void update() {
        double minWeight = Double.NEGATIVE_INFINITY;
        try {
            minWeight = Double.parseDouble(this.minWeightField.getText().trim());
        }
        catch (NumberFormatException e) {
            this.minWeightField.setText(this.attributeTableModel.getMinWeight() + "");
        }
        if (!this.minWeightCheckBox.isSelected()) {
            this.attributeTableModel.setMinWeight(minWeight);
        } else {
            this.attributeTableModel.setMinWeight(Double.NEGATIVE_INFINITY);
        }
        this.attributeTableModel.updateTable();
        this.updateSelectionCounter();
    }

    private void load() {
        File file = SwingTools.chooseFile(null, null, true);
        try {
            AttributeWeights fileWeights = AttributeWeights.load(file);
            this.attributeTableModel.mergeWeights(fileWeights);
        }
        catch (IOException e) {
            SwingTools.showSimpleErrorMessage("Cannot load attribute weights from file '" + file + ".", e);
        }
        this.update();
    }

    private void save() {
        File file = SwingTools.chooseFile(null, null, true);
        try {
            this.attributeTableModel.getAttributeWeights().save(file);
        }
        catch (IOException e) {
            SwingTools.showSimpleErrorMessage("Cannot write attribute weights to file '" + file + ".", e);
        }
    }

    public boolean isOk() {
        return this.ok;
    }

    public AttributeWeights getAttributeWeights() {
        return this.attributeTableModel.getAttributeWeights();
    }
}

