/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.gui.AttributeEditorDialog;
import edu.udo.cs.yale.gui.FileCellEditor;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.parameter.ParameterTypeAttributeFile;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;

public class AttributeFileCellEditor
extends FileCellEditor {
    private Operator exampleSource;

    public AttributeFileCellEditor(ParameterTypeAttributeFile type, Operator exampleSource) {
        super(type);
        this.exampleSource = exampleSource;
        JButton button = new JButton("Edit");
        button.setMargin(new Insets(0, 0, 0, 0));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributeFileCellEditor.this.buttonPressed();
            }
        });
        button.setToolTipText("Edit or create attribute description file (XML).");
        this.addButton(button, -1);
        this.addButton(this.createFileChooserButton(), 0);
    }

    private void buttonPressed() {
        Object value = this.getCellEditorValue();
        File file = value == null ? null : Yale.getExperiment().resolveFileName(value.toString());
        AttributeEditorDialog dialog = new AttributeEditorDialog(YaleGUI.getMainFrame(), this.exampleSource, file);
        dialog.setVisible(true);
        this.setText(dialog.getFile());
        this.fireEditingStopped();
    }
}

