/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.tools.LogService;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class YaleLineReader {
    private Pattern separatorPattern;
    private String[] commentChars;
    private boolean useQuotes = false;
    private int lineNumber = 1;

    public YaleLineReader(String separatorsRegExpr, char[] commentChars, boolean useQuotes) {
        this.separatorPattern = Pattern.compile(separatorsRegExpr);
        this.commentChars = new String[commentChars.length];
        for (int i = 0; i < commentChars.length; ++i) {
            this.commentChars[i] = Character.toString(commentChars[i]);
        }
        this.useQuotes = useQuotes;
    }

    public String[] readLine(BufferedReader in, int expectedNumberOfColumns) throws IOException {
        String line = null;
        while (line == null && (line = in.readLine()) != null) {
            line = line.trim();
            for (int c = 0; c < this.commentChars.length; ++c) {
                if (line.indexOf(this.commentChars[c]) < 0) continue;
                line = line.substring(0, line.indexOf(this.commentChars[c]));
            }
            if (line.trim().length() != 0) continue;
            line = null;
        }
        if (line == null) {
            return null;
        }
        String[] columns = this.separatorPattern.split(line);
        if (this.useQuotes) {
            columns = this.quote(columns);
        }
        if (expectedNumberOfColumns != -1) {
            if (columns.length < expectedNumberOfColumns) {
                throw new IOException("Data format error in line " + this.lineNumber + ": the line does not provide the expected number of columns (was: " + columns.length + ", expected: " + expectedNumberOfColumns + ")! Stop reading...");
            }
            if (columns.length > expectedNumberOfColumns) {
                LogService.logMessage("Possible data format error: a line did not provide the expected number of columns (was: " + columns.length + ", expected: " + expectedNumberOfColumns + ")!", 4);
            }
        }
        ++this.lineNumber;
        return columns;
    }

    private String[] quote(String[] columns) throws IOException {
        LinkedList<String> tokens = new LinkedList<String>();
        int start = -1;
        int end = -1;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].startsWith("\"")) {
                start = i;
            }
            if (start >= 0) {
                StringBuffer current = new StringBuffer(columns[i].substring(1));
                while (end < 0 && i < columns.length) {
                    if (columns[i].endsWith("\"")) {
                        end = i;
                        break;
                    }
                    ++i;
                }
                if (end < 0) {
                    throw new IOException("Error during reading: open quote \" is not ended!");
                }
                for (int a = start + 1; a < end; ++a) {
                    current.append(" ");
                    current.append(columns[a]);
                }
                if (columns[end].length() > 1) {
                    current.append(" " + columns[end].substring(0, columns[end].length() - 1));
                }
                tokens.add(current.toString());
                start = -1;
                end = -1;
                continue;
            }
            tokens.add(columns[i]);
        }
        String[] quoted = new String[tokens.size()];
        tokens.toArray(quoted);
        return quoted;
    }
}

