/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;

public class SkipNANExampleReader
implements ExampleReader {
    private ExampleReader reader;
    private Example currentExample;

    public SkipNANExampleReader(ExampleReader reader) {
        this.reader = reader;
        this.currentExample = null;
    }

    public boolean hasNext() {
        if (this.currentExample == null) {
            while (this.reader.hasNext()) {
                Example e = this.reader.next();
                if (this.containsNAN(e)) continue;
                this.currentExample = e;
                return true;
            }
            return false;
        }
        return true;
    }

    public Example next() {
        this.hasNext();
        Example dummy = this.currentExample;
        this.currentExample = null;
        return dummy;
    }

    private boolean containsNAN(Example e) {
        for (int i = 0; i < e.getNumberOfAttributes(); ++i) {
            if (!Double.isNaN(e.getValue(i))) continue;
            return true;
        }
        return false;
    }
}

