/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.PartitionBuilder;
import edu.udo.cs.yale.tools.LogService;
import java.util.Iterator;
import java.util.LinkedList;

public class Partition
implements Cloneable {
    private boolean[] mask;
    private int[] partitionSizes;
    private int[] splitPartition;
    private int[] tableIndexMap = null;

    public Partition(double[] ratio, int size, PartitionBuilder builder) {
        this.init(ratio, size, builder);
    }

    public Partition(int noPartitions, int size, PartitionBuilder builder) {
        double[] ratio = new double[noPartitions];
        for (int i = 0; i < ratio.length; ++i) {
            ratio[i] = 1.0 / (double)noPartitions;
        }
        this.init(ratio, size, builder);
    }

    public Partition(int[] splitPartition, int numberOfPartitions) {
        this.init(splitPartition, numberOfPartitions);
    }

    private Partition(Partition p) {
        this.partitionSizes = (int[])p.partitionSizes.clone();
        this.mask = (boolean[])p.mask.clone();
        this.splitPartition = (int[])p.splitPartition.clone();
        this.recalculateTableIndices();
    }

    private void init(double[] ratio, int size, PartitionBuilder builder) {
        LogService.logMessage("Create new partition using a '" + builder.getClass().getName() + "'.", 2);
        this.splitPartition = builder.createPartition(ratio, size);
        this.init(this.splitPartition, ratio.length);
    }

    private void init(int[] elements, int noOfPartitions) {
        int i;
        LogService.logMessage("Create new partition with " + elements.length + " elements and " + noOfPartitions + " partitions.", 2);
        this.partitionSizes = new int[noOfPartitions];
        this.splitPartition = elements;
        for (i = 0; i < this.splitPartition.length; ++i) {
            if (this.splitPartition[i] < 0) continue;
            int n = this.splitPartition[i];
            this.partitionSizes[n] = this.partitionSizes[n] + 1;
        }
        this.mask = new boolean[noOfPartitions];
        for (i = 0; i < this.mask.length; ++i) {
            this.mask[i] = true;
        }
        this.recalculateTableIndices();
    }

    public void clearSelection() {
        this.mask = new boolean[this.mask.length];
        this.recalculateTableIndices();
    }

    public void selectSubset(int i) {
        this.mask[i] = true;
        this.recalculateTableIndices();
    }

    public void deselectSubset(int i) {
        this.mask[i] = false;
        this.recalculateTableIndices();
    }

    public int getNumberOfSubsets() {
        return this.partitionSizes.length;
    }

    public int getSelectionSize() {
        int s = 0;
        for (int i = 0; i < this.partitionSizes.length; ++i) {
            if (!this.mask[i]) continue;
            s += this.partitionSizes[i];
        }
        return s;
    }

    public int getTotalSize() {
        return this.splitPartition.length;
    }

    public boolean isSelected(int index) {
        return this.mask[this.splitPartition[index]];
    }

    private void recalculateTableIndices() {
        LinkedList<Integer> indices = new LinkedList<Integer>();
        for (int i = 0; i < this.splitPartition.length; ++i) {
            if (!this.mask[this.splitPartition[i]]) continue;
            indices.add(new Integer(i));
        }
        this.tableIndexMap = new int[indices.size()];
        Iterator i = indices.iterator();
        int counter = 0;
        while (i.hasNext()) {
            this.tableIndexMap[counter++] = (Integer)i.next();
        }
    }

    public int mapIndex(int index) {
        return this.tableIndexMap[index];
    }

    public String toString() {
        String str = "(";
        for (int i = 0; i < this.partitionSizes.length; ++i) {
            str = str + (i != 0 ? "/" : "") + this.partitionSizes[i];
        }
        str = str + ")";
        return str;
    }

    public Object clone() {
        return new Partition(this);
    }
}

