/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.WeightApplier;
import edu.udo.cs.yale.tools.Ontology;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class Example {
    public static final String SEPARATOR = " ";
    public static final String SPARSE_SEPARATOR = ":";
    private DataRow data;
    private Attribute[] attributes;
    private Map specialAttributes;
    private AttributeWeights attributeWeights;
    private WeightApplier weightApplier;

    public Example(DataRow data, Attribute[] attributes, Map specialAttributes) {
        this(data, attributes, specialAttributes, null, null);
    }

    public Example(DataRow data, Attribute[] attributes, Map specialAttributes, AttributeWeights attributeWeights, WeightApplier weightApplier) {
        this.data = data;
        this.attributes = attributes;
        this.specialAttributes = specialAttributes;
        this.attributeWeights = attributeWeights;
        this.weightApplier = weightApplier;
    }

    public DataRow getDataRow() {
        return this.data;
    }

    public Attribute getAttribute(int i) {
        return this.attributes[i];
    }

    public Attribute getAttribute(String name) {
        Attribute attribute = (Attribute)this.specialAttributes.get(name);
        if (attribute == null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                if (!this.attributes[i].getName().equals(name)) continue;
                attribute = this.attributes[i];
                break;
            }
        }
        return attribute;
    }

    public int getNumberOfAttributes() {
        return this.attributes.length;
    }

    public Collection getSpecialAttributeNames() {
        return this.specialAttributes.keySet();
    }

    public void copySpecialAttributesTo(Example other) {
        Iterator i = this.specialAttributes.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            other.setValue(other.getAttribute(key), this.getValue(this.getAttribute(key)));
        }
    }

    public double getValue(int index) {
        return this.getValue(this.attributes[index]);
    }

    public double getValue(Attribute a) {
        if (!a.isNumerical() || this.attributeWeights == null || this.weightApplier == null) {
            return this.getUnweightedValue(a);
        }
        double weight = this.attributeWeights.getWeight(a.getName());
        return this.weightApplier.applyWeight(this.getUnweightedValue(a), Double.isNaN(weight) ? 1.0 : weight);
    }

    public double getUnweightedValue(Attribute a) {
        return this.data.get(a);
    }

    public void setValue(Attribute a, double value) {
        this.data.set(a, value);
    }

    public void setValue(Attribute a, String str) {
        if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(a.getValueType(), 1)) {
            throw new IllegalArgumentException("setValue(Attribute, String) only supported for nominal values!");
        }
        if (str != null) {
            this.setValue(a, a.mapString(str));
        } else {
            this.setValue(a, Double.NaN);
        }
    }

    public String getValueAsString(Attribute attribute) {
        return this.getValueAsString(attribute, -1);
    }

    public String getValueAsString(Attribute attribute, int fractionDigits) {
        return attribute.getAsString(this.getValue(attribute), fractionDigits);
    }

    public double getLabel() {
        Attribute label = this.getAttribute("label");
        if (label == null) {
            return Double.NaN;
        }
        return this.getValue(label);
    }

    public void setLabel(double value) {
        Attribute label = this.getAttribute("label");
        this.setValue(label, value);
    }

    public double getPredictedLabel() {
        Attribute prediction = this.getAttribute("prediction");
        if (prediction == null) {
            return Double.NaN;
        }
        return this.getValue(prediction);
    }

    public void setPredictedLabel(double value) {
        Attribute prediction = this.getAttribute("prediction");
        this.setValue(prediction, value);
    }

    public double getConfidence(String value) {
        Attribute confidenceAttribute = this.getAttribute("confidence(" + value + ")");
        if (confidenceAttribute == null) {
            return Double.NaN;
        }
        return this.getValue(confidenceAttribute);
    }

    public void setConfidence(String value, double confidence) {
        Attribute confidenceAttribute = this.getAttribute("confidence(" + value + ")");
        if (confidenceAttribute != null) {
            this.setValue(confidenceAttribute, confidence);
        }
    }

    public double getWeight() {
        Attribute weight = this.getAttribute("weight");
        if (weight == null) {
            return Double.NaN;
        }
        return this.getValue(weight);
    }

    public void setWeight(double value) {
        Attribute weight = this.getAttribute("weight");
        this.setValue(weight, value);
    }

    public String getAttributesAsString() {
        return this.getAttributesAsString(SEPARATOR);
    }

    public String getAttributesAsString(String sep) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
            if (i > 0) {
                str.append(sep);
            }
            str.append(this.getValueAsString(this.attributes[i]));
        }
        return str.toString();
    }

    public String getAttributesAsSparseString() {
        return this.getAttributesAsSparseString(SEPARATOR, SPARSE_SEPARATOR);
    }

    public String getAttributesAsSparseString(String separator, String indexValueSeparator) {
        StringBuffer str = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
            double value;
            Attribute attr = this.getAttribute(i);
            if (attr.isDefault(value = this.getValue(i))) continue;
            if (!first) {
                str.append(separator);
            }
            first = false;
            str.append(i + 1 + indexValueSeparator + this.getValueAsString(attr));
        }
        return str.toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getAttributesAsString() + SEPARATOR);
        Iterator i = this.specialAttributes.keySet().iterator();
        while (i.hasNext()) {
            result.append(this.getValueAsString(this.getAttribute((String)i.next())) + SEPARATOR);
        }
        return result.toString();
    }

    public String toSparseString(int format) {
        Attribute weightAttribute;
        Attribute idAttribute;
        StringBuffer str = new StringBuffer();
        Attribute labelAttribute = this.getAttribute("label");
        if (format == 1 && labelAttribute != null) {
            str.append(this.getValueAsString(labelAttribute) + SEPARATOR);
        }
        if ((idAttribute = this.getAttribute("id")) != null) {
            str.append("id:" + this.getValueAsString(idAttribute) + SEPARATOR);
        }
        if ((weightAttribute = this.getAttribute("weight")) != null) {
            str.append("w:" + this.getValueAsString(weightAttribute) + SEPARATOR);
        }
        str.append(this.getAttributesAsSparseString() + SEPARATOR);
        if (format == 2 && labelAttribute != null) {
            str.append("l:" + this.getValueAsString(labelAttribute));
        }
        if (format == 0 && labelAttribute != null) {
            str.append(this.getValueAsString(labelAttribute));
        }
        return str.toString();
    }
}

