/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.tools.DatabaseHandler;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DatabaseDataRow
implements DataRow {
    private ResultSet resultSet;
    private int row;

    public DatabaseDataRow(ResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        this.row = resultSet.getRow();
    }

    private void ensureRowCorrect() throws SQLException {
        if (this.row != this.resultSet.getRow()) {
            throw new RuntimeException("ResultSet was modified!");
        }
    }

    public double get(Attribute attribute) {
        Object dbData = null;
        try {
            this.ensureRowCorrect();
            return DatabaseDataRow.readColumn(this.resultSet, attribute);
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot read data: " + e);
        }
    }

    public void set(Attribute attribute, double value) {
        try {
            this.ensureRowCorrect();
            String name = DatabaseHandler.getDatabaseName(attribute);
            if (Double.isNaN(value)) {
                this.resultSet.updateNull(name);
            } else if (attribute.isNominal()) {
                this.resultSet.updateString(name, attribute.mapIndex((int)value));
            } else {
                this.resultSet.updateDouble(name, value);
            }
            this.resultSet.updateRow();
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot update data: " + e, e);
        }
    }

    public void ensureNumberOfColumns(int numberOfColumns) {
    }

    public void trim() {
    }

    public static double readColumn(ResultSet resultSet, Attribute attribute) throws SQLException {
        String name = DatabaseHandler.getDatabaseName(attribute);
        if (attribute.isNominal()) {
            String dbString = resultSet.getString(name);
            if (dbString == null) {
                return Double.NaN;
            }
            return attribute.mapString(dbString);
        }
        double value = resultSet.getDouble(name);
        if (resultSet.wasNull()) {
            return Double.NaN;
        }
        return value;
    }
}

