/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.SparseArrayDataRow;
import edu.udo.cs.yale.example.SparseMapDataRow;
import edu.udo.cs.yale.tools.LogService;

public class DataRowFactory {
    public static final String[] TYPE_NAMES = new String[]{"double_array", "sparse_map", "sparse_array"};
    public static final int FIRST_TYPE_INDEX = 0;
    public static final int TYPE_DOUBLE_ARRAY = 0;
    public static final int TYPE_SPARSE_MAP = 1;
    public static final int TYPE_SPARSE_ARRAY = 2;
    public static final int LAST_TYPE_INDEX = 2;
    private int type;

    public DataRowFactory(int type) {
        if (type < 0 || type > 2) {
            throw new IllegalArgumentException("Illegal data row type: " + type);
        }
        this.type = type;
    }

    public DataRow create(int size) {
        DataRow row = null;
        switch (this.type) {
            case 0: {
                row = new DoubleArrayDataRow(new double[size]);
                break;
            }
            case 1: {
                row = new SparseMapDataRow();
                break;
            }
            case 2: {
                row = new SparseArrayDataRow(size);
                break;
            }
        }
        return row;
    }

    public DataRow create(String[] strings, Attribute[] attributes) {
        DataRow dataRow = this.create(strings.length);
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i] != null) {
                strings[i] = strings[i].trim();
            }
            if (strings[i] != null && strings[i].length() > 0 && !strings[i].equals("?")) {
                if (attributes[i].isNominal()) {
                    dataRow.set(attributes[i], attributes[i].mapString(strings[i]));
                    continue;
                }
                dataRow.set(attributes[i], DataRowFactory.string2Double(strings[i]));
                continue;
            }
            dataRow.set(attributes[i], Double.NaN);
        }
        dataRow.trim();
        return dataRow;
    }

    public DataRow create(Object[] data, Attribute[] attributes) {
        DataRow dataRow = this.create(data.length);
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != null) {
                if (attributes[i].isNominal()) {
                    dataRow.set(attributes[i], attributes[i].mapString(((String)data[i]).trim()));
                    continue;
                }
                dataRow.set(attributes[i], ((Number)data[i]).doubleValue());
                continue;
            }
            dataRow.set(attributes[i], Double.NaN);
        }
        dataRow.trim();
        return dataRow;
    }

    public int getType() {
        return this.type;
    }

    public static final double string2Double(String str) {
        if (str == null) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            LogService.logMessage("DataRowFactory.string2Double(String): '" + str + "' is not a valid number!", 6);
            return Double.NaN;
        }
    }
}

