/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Condition;
import edu.udo.cs.yale.example.ConditionCreationException;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.tools.Tools;
import java.lang.reflect.Constructor;

public class ConditionExampleReader
implements ExampleReader {
    public static final String[] KNOWN_CONDITION_NAMES = new String[]{"attribute_value_condition", "unknown_attributes", "unknown_labels"};
    public static final String[] KNOWN_CONDITION_IMPLEMENTATIONS = new String[]{(class$edu$udo$cs$yale$example$AttributeValueFilter == null ? (class$edu$udo$cs$yale$example$AttributeValueFilter = ConditionExampleReader.class$("edu.udo.cs.yale.example.AttributeValueFilter")) : class$edu$udo$cs$yale$example$AttributeValueFilter).getName(), (class$edu$udo$cs$yale$example$LegalNumberCondition == null ? (class$edu$udo$cs$yale$example$LegalNumberCondition = ConditionExampleReader.class$("edu.udo.cs.yale.example.LegalNumberCondition")) : class$edu$udo$cs$yale$example$LegalNumberCondition).getName(), (class$edu$udo$cs$yale$example$LegalLabelCondition == null ? (class$edu$udo$cs$yale$example$LegalLabelCondition = ConditionExampleReader.class$("edu.udo.cs.yale.example.LegalLabelCondition")) : class$edu$udo$cs$yale$example$LegalLabelCondition).getName()};
    public static final String[] KNOWN_CONDITION_DESCRIPTIONS = new String[]{"Checks if the examples fulfill a given condition with respect to an attribute's value.", "Checks if the examples contain unknown attribute values.", "Checks if the label is unknown.", "Checks if this example was already used."};
    private ExampleReader parent;
    private Condition condition;
    private Example currentExample;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$AttributeValueFilter;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$LegalNumberCondition;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$LegalLabelCondition;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$Condition;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;
    static /* synthetic */ Class class$java$lang$String;

    public ConditionExampleReader(ExampleReader parent, Condition condition) {
        this.parent = parent;
        this.currentExample = null;
        this.condition = condition;
    }

    public boolean hasNext() {
        while (this.currentExample == null) {
            if (!this.parent.hasNext()) {
                return false;
            }
            Example e = this.parent.next();
            if (!this.condition.conditionOk(e)) continue;
            this.currentExample = e;
        }
        return true;
    }

    public Example next() {
        this.hasNext();
        Example dummy = this.currentExample;
        this.currentExample = null;
        return dummy;
    }

    public static Condition createCondition(String name, ExampleSet exampleSet, String parameterString) throws ConditionCreationException {
        String className = name;
        for (int i = 0; i < KNOWN_CONDITION_NAMES.length; ++i) {
            if (!KNOWN_CONDITION_NAMES[i].equals(name)) continue;
            className = KNOWN_CONDITION_IMPLEMENTATIONS[i];
            break;
        }
        try {
            Class clazz = Tools.classForName(className);
            if (!(class$edu$udo$cs$yale$example$Condition == null ? (class$edu$udo$cs$yale$example$Condition = ConditionExampleReader.class$("edu.udo.cs.yale.example.Condition")) : class$edu$udo$cs$yale$example$Condition).isAssignableFrom(clazz)) {
                throw new ConditionCreationException("'" + className + "' does not implement Condition!");
            }
            Constructor constructor = clazz.getConstructor(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = ConditionExampleReader.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet, class$java$lang$String == null ? (class$java$lang$String = ConditionExampleReader.class$("java.lang.String")) : class$java$lang$String);
            return (Condition)constructor.newInstance(exampleSet, parameterString);
        }
        catch (ClassNotFoundException e) {
            throw new ConditionCreationException("Cannot find class '" + className + "'. Check your classpath.");
        }
        catch (NoSuchMethodException e) {
            throw new ConditionCreationException("'" + className + "' must implement two argument constructor " + className + "(ExampleSet, String)!");
        }
        catch (IllegalAccessException e) {
            throw new ConditionCreationException("'" + className + "' cannot access two argument constructor " + className + "(ExampleSet, String)!");
        }
        catch (InstantiationException e) {
            throw new ConditionCreationException(className + ": cannot create condition (" + e.getMessage() + ").");
        }
        catch (Throwable e) {
            throw new ConditionCreationException(className + ": cannot invoke condition (" + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage()) + ").");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

