/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.operator.Saveable;
import edu.udo.cs.yale.tools.math.Averagable;
import edu.udo.cs.yale.tools.math.AverageVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AttributeWeights
extends AverageVector
implements Saveable {
    public static final int ASCENDING = 1;
    public static final int DESCENDING = -1;
    private int sorttype = -1;
    public static final int WEIGHT = 0;
    public static final int WEIGHT_ABSOLUTE = 1;
    private int weighttype = 0;
    private JPanel vispanel;
    private Component viscomp;
    private Map weightMap = new LinkedHashMap();

    public AttributeWeights() {
    }

    private AttributeWeights(AttributeWeights weights) {
        Iterator i = weights.getAttributeNames().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            this.setWeight(name, weights.getWeight(name));
        }
    }

    public String getName() {
        return "AttributeWeights";
    }

    public void setWeight(String name, double weight) {
        AttributeWeight oldWeight = (AttributeWeight)this.weightMap.get(name);
        if (Double.isNaN(weight)) {
            this.weightMap.remove(name);
            super.removeAveragable(oldWeight);
        }
        if (oldWeight == null) {
            AttributeWeight attWeight = new AttributeWeight(name, weight);
            super.addAveragable(attWeight);
            this.weightMap.put(name, attWeight);
        } else {
            oldWeight.setWeight(weight);
        }
    }

    public double getWeight(String name) {
        AttributeWeight weight = (AttributeWeight)this.weightMap.get(name);
        if (weight == null) {
            return Double.NaN;
        }
        return weight.getWeight();
    }

    public int size() {
        return this.weightMap.size();
    }

    public Set getAttributeNames() {
        return this.weightMap.keySet();
    }

    public int compareTo(Object o) {
        return 0;
    }

    public void sortByWeight(String[] attributeNames, int direction, int value) {
        Arrays.sort(attributeNames, new WeightComparator(this, direction, value));
    }

    public void save(File file) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(file));
        Iterator i = this.weightMap.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            double weight = ((AttributeWeight)this.weightMap.get(key)).getWeight();
            out.println(key + ": \t" + weight);
        }
        out.close();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("AttributeWeights:\n");
        Iterator i = this.weightMap.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            result.append(key + ": " + ((AttributeWeight)this.weightMap.get(key)).getWeight() + "\n");
        }
        return result.toString();
    }

    private Iterator getSortedWeights() {
        LinkedList<AttributeWeight> allWeights = new LinkedList<AttributeWeight>();
        Iterator i = this.weightMap.keySet().iterator();
        while (i.hasNext()) {
            AttributeWeight attweight = (AttributeWeight)this.weightMap.get((String)i.next());
            allWeights.add(attweight);
        }
        Collections.sort(allWeights);
        return allWeights.iterator();
    }

    public String toHTML() {
        StringBuffer result = new StringBuffer("<h1>" + this.getName() + "</h1>");
        result.append("<table bgcolor=\"#E3D8C3\" border=\"1\">");
        result.append("<tr bgcolor=\"#ccccff\"><th>Name</th><th>Weight</th></tr>");
        int counter = 0;
        Iterator i = this.getSortedWeights();
        String maxNumberProperty = System.getProperty("yale.gui.resultviewer.attributelimit");
        int maxNumberOfWeights = Integer.parseInt(maxNumberProperty);
        while (i.hasNext()) {
            AttributeWeight weight = (AttributeWeight)i.next();
            result.append("<tr><td>" + weight.getName() + "</td><td>" + weight.getWeight() + "</td></tr>");
            if (++counter <= maxNumberOfWeights) continue;
            result.append("<tr><td colspan=\"2\">... " + (this.weightMap.size() - (maxNumberOfWeights + 1)) + " attributes ... </td></tr>");
            break;
        }
        result.append("</table>");
        return result.toString();
    }

    public static AttributeWeights load(File file) throws IOException {
        AttributeWeights result = new AttributeWeights();
        BufferedReader in = new BufferedReader(new FileReader(file));
        String line = null;
        while ((line = in.readLine()) != null) {
            String name = line.substring(0, line.indexOf(":")).trim();
            String weightString = line.substring(line.indexOf(":") + 1).trim();
            double weight = 1.0;
            try {
                weight = Double.parseDouble(weightString);
            }
            catch (NumberFormatException e) {
                throw new IOException("Cannot parse weight from weight file " + file + ": " + e.getMessage());
            }
            result.setWeight(name, weight);
        }
        in.close();
        return result;
    }

    public Object clone() {
        return new AttributeWeights(this);
    }

    public Component getVisualisationComponent() {
        this.vispanel = new JPanel();
        this.vispanel.setLayout(new BorderLayout());
        JRadioButton ascending = new JRadioButton("ascending");
        JRadioButton descending = new JRadioButton("descending");
        JRadioButton value = new JRadioButton("weight");
        JRadioButton value_absolute = new JRadioButton("abs(weight)");
        ButtonGroup typegroup = new ButtonGroup();
        typegroup.add(ascending);
        typegroup.add(descending);
        descending.setSelected(true);
        ButtonGroup valuegroup = new ButtonGroup();
        valuegroup.add(value);
        value.setSelected(true);
        valuegroup.add(value_absolute);
        SortListener listener = new SortListener(ascending, descending, value, value_absolute);
        ascending.addActionListener(listener);
        descending.addActionListener(listener);
        value.addActionListener(listener);
        value_absolute.addActionListener(listener);
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(1, 6));
        JLabel sorttype = new JLabel("sort type:");
        sorttype.setHorizontalAlignment(0);
        buttons.add(sorttype);
        buttons.add(ascending);
        buttons.add(descending);
        JLabel valuetype = new JLabel("value:");
        valuetype.setHorizontalAlignment(0);
        buttons.add(valuetype);
        buttons.add(value);
        buttons.add(value_absolute);
        JPanel toppanel = new JPanel();
        toppanel.setLayout(new BorderLayout());
        toppanel.add((Component)buttons, "West");
        this.vispanel.add((Component)toppanel, "North");
        this.viscomp = super.getVisualisationComponent();
        this.vispanel.add(this.viscomp, "Center");
        return this.vispanel;
    }

    private class AttributeWeight
    extends Averagable {
        private String name;
        private double weight;

        public AttributeWeight(String name, double weight) {
            this.name = name;
            this.weight = weight;
        }

        public String getName() {
            return this.name;
        }

        public double getWeight() {
            return this.weight;
        }

        public void setWeight(double weight) {
            this.weight = weight;
        }

        public double getVariance() {
            return this.getMakroVariance();
        }

        public double getValue() {
            return this.getWeight();
        }

        public int compareTo(Object o) {
            if (o instanceof AttributeWeight) {
                double w1 = this.weight;
                double w2 = ((AttributeWeight)o).weight;
                if (AttributeWeights.this.weighttype == 1) {
                    w1 = Math.abs(w1);
                    w2 = Math.abs(w2);
                }
                return Double.compare(w1, w2) * AttributeWeights.this.sorttype;
            }
            return -1;
        }

        public boolean equals(Object o) {
            if (o instanceof AttributeWeight) {
                return false;
            }
            AttributeWeight w = (AttributeWeight)o;
            return this.name.equals(w.name) && this.weight == w.weight;
        }

        public void cloneAveragable(Averagable avg) {
            AttributeWeight weight = (AttributeWeight)avg;
            this.name = weight.name;
            this.weight = weight.weight;
        }

        public void buildSingleAverage(Averagable avg) {
            AttributeWeight other = (AttributeWeight)avg;
            this.weight += other.weight;
        }
    }

    private class SortListener
    implements ActionListener {
        JRadioButton asc;
        JRadioButton desc;
        JRadioButton weight;
        JRadioButton abs_weight;

        public SortListener(JRadioButton asc, JRadioButton desc, JRadioButton weight, JRadioButton abs_weight) {
            this.asc = asc;
            this.desc = desc;
            this.weight = weight;
            this.abs_weight = abs_weight;
        }

        public void actionPerformed(ActionEvent event) {
            if (this.asc.isSelected()) {
                AttributeWeights.this.sorttype = 1;
            } else {
                AttributeWeights.this.sorttype = -1;
            }
            if (this.weight.isSelected()) {
                AttributeWeights.this.weighttype = 0;
            } else {
                AttributeWeights.this.weighttype = 1;
            }
            AttributeWeights.this.vispanel.remove(AttributeWeights.this.viscomp);
            AttributeWeights.this.viscomp = new JLabel("<html>" + AttributeWeights.this.toHTML() + "</html>");
            ((JLabel)AttributeWeights.this.viscomp).setFont(((JLabel)AttributeWeights.this.viscomp).getFont().deriveFont(0));
            AttributeWeights.this.vispanel.add(AttributeWeights.this.viscomp);
        }
    }

    private class WeightComparator
    implements Comparator {
        private int value;
        private int direction;
        private AttributeWeights weights;

        public WeightComparator(AttributeWeights weights, int direction, int value) {
            this.value = value;
            this.weights = weights;
            this.direction = direction;
        }

        public int compare(Object o1, Object o2) {
            int result = 0;
            if (o1 instanceof String && o2 instanceof String) {
                double w1 = ((AttributeWeight)this.weights.weightMap.get((String)o1)).weight;
                double w2 = ((AttributeWeight)this.weights.weightMap.get((String)o2)).weight;
                if (this.value == 1) {
                    w1 = Math.abs(w1);
                    w2 = Math.abs(w2);
                }
                result = Double.compare(w1, w2) * -1 * this.direction;
            }
            return result;
        }
    }
}

