/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Condition;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;

public class AttributeValueFilter
implements Condition {
    private static final String[] COMPARISON_TYPES = new String[]{"<=", ">=", "!=", "=", "<", ">"};
    public static final int LEQ = 0;
    public static final int GEQ = 1;
    public static final int NEQ = 2;
    public static final int EQUALS = 3;
    public static final int LESS = 4;
    public static final int GREATER = 5;
    private int comparisonType = 3;
    private Attribute attribute;
    private double value;

    public AttributeValueFilter(Attribute attribute, int comparisonType, String value) {
        this.attribute = attribute;
        this.comparisonType = comparisonType;
        this.setValue(value);
    }

    public Condition duplicate() {
        return this;
    }

    public AttributeValueFilter(ExampleSet exampleSet, String parameterString) {
        if (parameterString == null || parameterString.length() == 0) {
            throw new IllegalArgumentException("Parameter string must not be empty!");
        }
        int compIndex = -1;
        this.comparisonType = 0;
        while (this.comparisonType < COMPARISON_TYPES.length && (compIndex = parameterString.indexOf(COMPARISON_TYPES[this.comparisonType])) == -1) {
            ++this.comparisonType;
        }
        if (compIndex == -1) {
            throw new IllegalArgumentException("Parameter string must have the form 'attribute {=|<|>|<=|>=|!=} value'");
        }
        String attName = parameterString.substring(0, compIndex).trim();
        String valueStr = parameterString.substring(compIndex + COMPARISON_TYPES[this.comparisonType].length()).trim();
        if (attName.length() == 0 || valueStr.length() == 0) {
            throw new IllegalArgumentException("Parameter string must have the form 'attribute {=|<|>|<=|>=|!=} value'");
        }
        this.attribute = exampleSet.getAttribute(attName);
        if (this.attribute == null) {
            throw new IllegalArgumentException("Unknown attribute: '" + attName + "'");
        }
        this.setValue(valueStr);
    }

    private void setValue(String value) {
        if (this.attribute.isNominal()) {
            if (this.comparisonType != 3 && this.comparisonType != 2) {
                throw new IllegalArgumentException("For nominal attributes only '=' and '!=' is allowed!");
            }
            this.value = this.attribute.mapString(value);
        } else {
            try {
                this.value = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Value for attribute '" + this.attribute.getName() + "' must be numerical!");
            }
        }
    }

    public String toString() {
        return this.attribute.getName() + " " + COMPARISON_TYPES[this.comparisonType] + " " + (this.attribute.isNominal() ? this.attribute.mapIndex((int)this.value) : "" + this.value);
    }

    public boolean conditionOk(Example e) {
        switch (this.comparisonType) {
            case 0: {
                return e.getValue(this.attribute) <= this.value;
            }
            case 1: {
                return e.getValue(this.attribute) >= this.value;
            }
            case 2: {
                return e.getValue(this.attribute) != this.value;
            }
            case 3: {
                return e.getValue(this.attribute) == this.value;
            }
            case 4: {
                return e.getValue(this.attribute) < this.value;
            }
            case 5: {
                return e.getValue(this.attribute) > this.value;
            }
        }
        return false;
    }
}

