/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractAttribute;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.BinaryAttribute;
import edu.udo.cs.yale.example.NominalAttribute;
import edu.udo.cs.yale.example.NumericalAttribute;
import edu.udo.cs.yale.tools.Ontology;
import java.io.DataInput;
import java.io.IOException;

public class AttributeFactory {
    private static final String GENSYM_PREFIX = "gensym";
    private static int genSym;

    public static Attribute createAttribute(String name, int valueType) {
        String attributeName;
        String string = attributeName = name != null ? name : AttributeFactory.createName();
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 8)) {
            return new BinaryAttribute(attributeName);
        }
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 1)) {
            return new NominalAttribute(attributeName);
        }
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 2)) {
            return new NumericalAttribute(attributeName, valueType);
        }
        throw new RuntimeException("AttributeFactory: cannot create attribute with value type '" + Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(valueType) + "' (" + valueType + ")!");
    }

    public static Attribute createAttribute(int valueType) {
        return AttributeFactory.createAttribute(AttributeFactory.createName(), valueType);
    }

    public static Attribute createAttribute(String functionName, Attribute[] arguments) {
        return AttributeFactory.createAttribute(2, 3, -1, functionName, arguments, null);
    }

    public static Attribute createAttribute(int valueType, int blockType, int blockNumber, String functionName, Attribute[] arguments, String units) {
        Attribute attribute = AttributeFactory.createAttribute(valueType);
        attribute.setBlockType(blockType);
        attribute.setBlockNumber(blockNumber);
        attribute.setUnits(units);
        attribute.setFunctionName(functionName);
        attribute.setArguments(arguments);
        return attribute;
    }

    public static Attribute createAttribute(String name, int valueType, int blockType, int blockNumber, String units) {
        Attribute attribute = AttributeFactory.createAttribute(name, valueType);
        attribute.setBlockType(blockType);
        attribute.setBlockNumber(blockNumber);
        attribute.setUnits(units);
        return attribute;
    }

    public static Attribute createAttribute(int valueType, int blockType, int blockNumber, String units) {
        Attribute attribute = AttributeFactory.createAttribute(valueType);
        attribute.setBlockType(blockType);
        attribute.setBlockNumber(blockNumber);
        attribute.setUnits(units);
        return attribute;
    }

    public static Attribute createAttribute(Attribute attribute) {
        return AttributeFactory.createAttribute(attribute, null);
    }

    public static Attribute createAttribute(Attribute attribute, String functionName) {
        Attribute result = (Attribute)attribute.clone();
        if (functionName == null) {
            result.setName(attribute.getName());
        } else {
            result.setName(functionName + "(" + attribute.getName() + ")");
            result.setFunctionName(functionName);
            result.setArguments(new Attribute[]{attribute});
        }
        return result;
    }

    public static Attribute changeValueType(Attribute attribute, int valueType) {
        Attribute result = AttributeFactory.createAttribute(attribute.getName(), valueType);
        result.copyProperties(attribute);
        return result;
    }

    public static Attribute readAttribute(DataInput in) throws IOException {
        String name = in.readUTF();
        int valueType = in.readInt();
        Attribute attribute = AttributeFactory.createAttribute(name, valueType);
        attribute.readAttributeData(in);
        return attribute;
    }

    public static void resetNameCounter() {
        genSym = 1;
    }

    public static String createName() {
        return AttributeFactory.createName(GENSYM_PREFIX);
    }

    public static String createName(String prefix) {
        return prefix + genSym++;
    }

    public static int getNextFreeBlockNumber() {
        return AbstractAttribute.HIGHEST_BLOCK_NUMBER + 1;
    }

    static {
        AttributeFactory.resetNameCounter();
    }
}

