/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.doc;

import edu.udo.cs.yale.tools.Tools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class CommentStripper {
    private File sourceDir;

    public CommentStripper(File sourceDir) {
        this.sourceDir = sourceDir;
    }

    public String stripClassComment(Class clazz) throws IOException {
        File sourceFile = new File(this.sourceDir, clazz.getName().replaceAll("\\.", File.separator) + ".java");
        if (!sourceFile.exists()) {
            throw new FileNotFoundException("No source file found for class " + clazz.getName() + "; source was expected in '" + sourceFile + "'.");
        }
        StringBuffer comment = null;
        BufferedReader reader = new BufferedReader(new FileReader(sourceFile));
        String line = null;
        boolean SCANNING_FOR_COMMENT = false;
        boolean READING_COMMENT = true;
        int FINISHED_COMMENT = 2;
        int currentState = 0;
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            switch (currentState) {
                case 0: {
                    if (!line.startsWith("/**")) break;
                    comment = new StringBuffer();
                    line = line.substring("/**".length());
                    currentState = 1;
                }
                case 1: {
                    int end = line.indexOf("*/");
                    if (end != -1) {
                        line = line.substring(0, end);
                        currentState = 2;
                    }
                    if ((line = CommentStripper.stripAsteriks(line)).startsWith("@")) break;
                    comment.append(line + " ");
                    break;
                }
                case 2: {
                    if (line.length() <= 0) break;
                    int classIndex = line.indexOf("class");
                    int nameIndex = line.indexOf(Tools.classNameWOPackage(clazz));
                    if (classIndex != -1 && nameIndex > classIndex + "class".length()) {
                        return comment.toString().trim();
                    }
                    comment = null;
                }
            }
        }
        reader.close();
        return null;
    }

    private static String stripAsteriks(String string) {
        while (string.startsWith("*")) {
            string = string.substring(1).trim();
        }
        return string.trim();
    }
}

