/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.doc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.Taglet;
import edu.udo.cs.yale.doc.CiteTaglet;
import edu.udo.cs.yale.doc.MathTaglet;
import edu.udo.cs.yale.doc.OperatorDocGenerator;
import edu.udo.cs.yale.doc.RefTaglet;
import edu.udo.cs.yale.doc.TexTaglet;
import edu.udo.cs.yale.doc.XMLExampleTaglet;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorCreationException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.learner.Learner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.OperatorService;
import edu.udo.cs.yale.tools.Tools;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractOperatorDocGenerator
implements OperatorDocGenerator {
    public static final int OPERATOR = 0;
    public static final int OPERATOR_NAME = 1;
    public static final int GROUP_NAME = 2;
    public static final int PARAMETER_LIST = 3;
    public static final int PARAMETER_ITEM = 4;
    public static final int PARAMETER_NAME_REQ = 5;
    public static final int PARAMETER_NAME_OPT = 6;
    public static final int PARAMETER_DESCRIPTION = 7;
    public static final int SHORT_DESCRIPTION = 8;
    public static final int OPERATOR_DESCRIPTION = 9;
    public static final int INPUT_CLASSES_LIST = 10;
    public static final int OUTPUT_CLASSES_LIST = 11;
    public static final int IO_CLASS = 12;
    public static final int VALUE_LIST = 13;
    public static final int VALUE_ITEM = 14;
    public static final int VALUE_NAME = 15;
    public static final int VALUE_DESCRIPTION = 16;
    public static final int INDEX_ENTRY = 17;
    public static final int REFERENCE_SECTION = 18;
    public static final int REFERENCE_ENTRY = 19;
    public static final int DEPRECATION_INFO = 20;
    public static final int LEARNER_CAPABILITIES = 21;
    private Map yaleTagletMap = new HashMap();
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$Operator;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$IOObject;

    public abstract String transformHTMLJavadocComment(String var1, Class var2, String var3);

    public abstract String escape(String var1);

    public abstract String getOpenTag(int var1);

    public abstract String getCloseTag(int var1);

    public abstract String marginIcon(String var1);

    public AbstractOperatorDocGenerator() {
        CiteTaglet.register(this.yaleTagletMap);
        MathTaglet.register(this.yaleTagletMap);
        RefTaglet.register(this.yaleTagletMap);
        XMLExampleTaglet.register(this.yaleTagletMap);
    }

    public void generateDoc(Operator op, RootDoc rootDoc, PrintWriter out) {
        Collection values;
        List parameters;
        Class[] output;
        Class[] input;
        ClassDoc opDoc = rootDoc.classNamed(op.getClass().getName());
        out.println(this.getOpenTag(0));
        this.printTags(out, op.getOperatorDescription().getName(), 1);
        out.println();
        if (op.getOperatorDescription().getIconName() != null) {
            out.println(this.marginIcon(op.getOperatorDescription().getIconName()));
        }
        this.printTags(out, op.getOperatorDescription().getGroup(), 2);
        Tag[] indexTags = opDoc.tags("yale.index");
        for (int i = 0; i < indexTags.length; ++i) {
            this.printTags(out, indexTags[i].text(), 17);
        }
        if (op.getDeprecationInfo() != null) {
            this.printTags(out, op.getDeprecationInfo(), 20);
            out.println();
        }
        if ((input = op.getInputClasses()) != null && input.length > 0) {
            out.println(this.getOpenTag(10));
            for (int i = 0; i < input.length; ++i) {
                this.printTags(out, Tools.classNameWOPackage(input[i]), 12);
                out.println();
            }
            out.println(this.getCloseTag(10));
        }
        if ((output = op.getOutputClasses()) != null && output.length > 0) {
            out.println(this.getOpenTag(11));
            for (int i = 0; i < output.length; ++i) {
                this.printTags(out, Tools.classNameWOPackage(output[i]), 12);
                out.println();
            }
            out.println(this.getCloseTag(11));
        }
        if ((parameters = op.getParameterTypes()).size() > 0) {
            out.println(this.getOpenTag(3));
            Iterator i = parameters.iterator();
            while (i.hasNext()) {
                ParameterType type = (ParameterType)i.next();
                out.print(this.getOpenTag(4));
                if (type.isOptional()) {
                    this.printTags(out, type.getKey(), 6);
                } else {
                    this.printTags(out, type.getKey(), 5);
                }
                if (type instanceof ParameterTypeCategory || type instanceof ParameterTypeStringCategory) {
                    this.printTags(out, type.getDescription(), 7);
                } else {
                    this.printTags(out, type.getDescription() + " (" + type.getRange() + ")", 7);
                }
                out.println(this.getCloseTag(4));
            }
            out.println(this.getCloseTag(3));
        }
        if ((values = op.getValues()).size() > 0) {
            out.println(this.getOpenTag(13));
            Iterator i = values.iterator();
            while (i.hasNext()) {
                Value value = (Value)i.next();
                out.print(this.getOpenTag(14));
                this.printTags(out, value.getKey(), 15);
                this.printTags(out, value.getDescription(), 16);
                out.println(this.getCloseTag(14));
            }
            out.println(this.getCloseTag(13));
        }
        if (op instanceof Learner) {
            String result;
            Learner learner = (Learner)((Object)op);
            StringBuffer learnerCapabilities = new StringBuffer();
            Iterator i = LearnerCapability.getAllCapabilities().iterator();
            boolean first = true;
            while (i.hasNext()) {
                LearnerCapability capability = (LearnerCapability)i.next();
                try {
                    if (!learner.supportsCapability(capability)) continue;
                    if (!first) {
                        learnerCapabilities.append(", ");
                    }
                    learnerCapabilities.append(capability.getDescription());
                    first = false;
                }
                catch (Exception e) {
                    break;
                }
            }
            if ((result = learnerCapabilities.toString()).length() > 0) {
                out.print(this.getOpenTag(21));
                out.print(result);
                out.print(this.getCloseTag(21));
            }
        }
        StringBuffer classComment = new StringBuffer();
        Tag[] inlineTags = opDoc.inlineTags();
        for (int i = 0; i < inlineTags.length; ++i) {
            if (inlineTags[i] instanceof SeeTag) {
                try {
                    Class<?> referencedClass = Class.forName(((SeeTag)inlineTags[i]).referencedClass().qualifiedName());
                    if ((class$edu$udo$cs$yale$operator$Operator == null ? AbstractOperatorDocGenerator.class$("edu.udo.cs.yale.operator.Operator") : class$edu$udo$cs$yale$operator$Operator).isAssignableFrom(referencedClass)) {
                        if (Modifier.isAbstract(referencedClass.getModifiers())) {
                            classComment.append("\\op{" + Tools.classNameWOPackage(referencedClass) + "}");
                            continue;
                        }
                        try {
                            Operator refOp = OperatorService.createOperator(referencedClass);
                            classComment.append("\\refop{" + refOp.getOperatorDescription().getName() + "}");
                        }
                        catch (OperatorCreationException e) {
                            classComment.append("\\op{" + Tools.classNameWOPackage(referencedClass) + "}");
                        }
                        continue;
                    }
                    if ((class$edu$udo$cs$yale$operator$IOObject == null ? AbstractOperatorDocGenerator.class$("edu.udo.cs.yale.operator.IOObject") : class$edu$udo$cs$yale$operator$IOObject).isAssignableFrom(referencedClass)) {
                        classComment.append("\\ioobj{" + Tools.classNameWOPackage(referencedClass) + "}");
                        continue;
                    }
                    classComment.append("\\java{" + Tools.classNameWOPackage(referencedClass) + "}");
                }
                catch (Throwable e) {
                    LogService.logMessage("In see tag '" + inlineTags[i] + "' of " + op.getClass().getName() + ": " + e, 6);
                }
                continue;
            }
            Taglet taglet = (Taglet)this.yaleTagletMap.get(inlineTags[i].name().substring(1));
            if (taglet instanceof TexTaglet) {
                classComment.append(((TexTaglet)taglet).toTex(inlineTags[i]));
                continue;
            }
            classComment.append(this.escape(inlineTags[i].text()));
        }
        out.println(this.getOpenTag(8) + this.transformHTMLJavadocComment(op.getOperatorDescription().getDescription(), op.getClass(), op.getOperatorDescription().getName()) + this.getCloseTag(8));
        out.println();
        out.println(this.getOpenTag(9) + this.transformHTMLJavadocComment(classComment.toString(), op.getClass(), op.getOperatorDescription().getName()) + this.getCloseTag(9));
        out.println();
        Tag[] citeTags = opDoc.tags("yale.cite");
        if (citeTags.length > 0) {
            out.println(this.getOpenTag(18));
        }
        for (int i = 0; i < citeTags.length; ++i) {
            this.printTags(out, citeTags[i].text(), 19);
        }
        out.println(this.getCloseTag(0));
    }

    private void printTags(PrintWriter out, String text, int tagNo) {
        out.print(this.getOpenTag(tagNo) + this.escape(text) + this.getCloseTag(tagNo));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

