/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.util;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;

public class Resources {
    private static Vector resources = new Vector();
    private static Vector resourceNames = new Vector();
    private static Toolkit kit = Toolkit.getDefaultToolkit();
    static /* synthetic */ Class class$edu$udo$cs$jvito$util$Resources;

    public static void addResource(String name) {
        if (resourceNames.indexOf(name) == -1) {
            resources.add(ResourceBundle.getBundle(name));
            resourceNames.add(name);
        }
    }

    public static String getString(String key) {
        String r = null;
        for (int i = resources.size() - 1; i >= 0; --i) {
            try {
                r = ((ResourceBundle)resources.get(i)).getString(key);
                return r;
            }
            catch (MissingResourceException e1) {
                continue;
            }
        }
        return key;
    }

    public static URL getURL(String key) {
        String r = null;
        for (int i = resources.size() - 1; i >= 0; --i) {
            try {
                r = ((ResourceBundle)resources.get(i)).getString(key);
                return new URL(r);
            }
            catch (MissingResourceException e1) {
                continue;
            }
            catch (MalformedURLException error) {
                return null;
            }
        }
        return null;
    }

    public static URL getURLByClassLoader(String key) {
        String r = null;
        for (int i = resources.size() - 1; i >= 0; --i) {
            try {
                r = ((ResourceBundle)resources.get(i)).getString(key);
                return (class$edu$udo$cs$jvito$util$Resources == null ? (class$edu$udo$cs$jvito$util$Resources = Resources.class$("edu.udo.cs.jvito.util.Resources")) : class$edu$udo$cs$jvito$util$Resources).getClassLoader().getResource(r);
            }
            catch (MissingResourceException e1) {
                continue;
            }
        }
        return null;
    }

    public static String getImagePath(String key) {
        String path = Resources.getString(key + "_ICON");
        if (path.equals(key + "_ICON")) {
            path = Resources.getString("STANDARD_ICON");
        }
        return path;
    }

    public static char getChar(String key) {
        return Resources.getString(key).charAt(0);
    }

    public static int getInt(String key) {
        return Character.getNumericValue(Resources.getString(key).charAt(0));
    }

    public static float getFloat(String key) {
        return Float.parseFloat(key);
    }

    public static double getDouble(String key) {
        return Double.parseDouble(key);
    }

    public static boolean getBoolean(String key) {
        return Boolean.getBoolean(key);
    }

    public static Color getColor(String key) {
        String[] colorArray = Resources.getString(key).split(",");
        Color color = new Color(Integer.parseInt(colorArray[0]), Integer.parseInt(colorArray[1]), Integer.parseInt(colorArray[2]));
        return color;
    }

    public static Image getImageByDir(String path) {
        return Resources.getImageIconByDir(path).getImage();
    }

    public static Image getImage(String key) {
        return Resources.getImageIcon(key).getImage();
    }

    public static ImageIcon getImageIconByDir(String path) {
        return new ImageIcon((class$edu$udo$cs$jvito$util$Resources == null ? (class$edu$udo$cs$jvito$util$Resources = Resources.class$("edu.udo.cs.jvito.util.Resources")) : class$edu$udo$cs$jvito$util$Resources).getClassLoader().getResource(path));
    }

    public static ImageIcon getImageIcon(String key) {
        String path = Resources.getImagePath(key);
        path = path.substring(1);
        ImageIcon icon = new ImageIcon((class$edu$udo$cs$jvito$util$Resources == null ? (class$edu$udo$cs$jvito$util$Resources = Resources.class$("edu.udo.cs.jvito.util.Resources")) : class$edu$udo$cs$jvito$util$Resources).getClassLoader().getResource(path));
        return icon;
    }

    public static String getToolTipText(String key) {
        return Resources.getString("TOOLTIP_" + key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

