/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.jvito.plot.PlotPanel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class ZoomingListener
implements MouseListener,
MouseMotionListener {
    private boolean mousepressed = false;
    private PlotPanel panel;
    private int starty;

    public ZoomingListener(PlotPanel panel) {
        this.panel = panel;
        this.starty = 0;
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent event) {
        if (!event.isShiftDown()) {
            return;
        }
        if (event.getButton() == 1) {
            this.mousepressed = true;
            this.starty = event.getY();
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (event.getButton() == 1) {
            this.mousepressed = false;
            this.starty = 0;
        }
    }

    public void mouseDragged(MouseEvent event) {
        if (event.isShiftDown() && this.mousepressed) {
            int dy = event.getY() - this.starty;
            dy = -dy;
            Dimension dim = this.panel.getDimension();
            float factor = (float)dy / (float)dim.getHeight();
            int dx = (int)((float)dim.width * factor);
            this.panel.setDimension(new Dimension(dim.width + dx, dim.height + dy));
            Point p = this.panel.getOrigin();
            this.panel.setOrigin(new Point(p.x - dx / 2, p.y - dy / 2));
            this.panel.repaint();
            this.starty = event.getY();
        }
    }

    public void mouseMoved(MouseEvent event) {
    }
}

