/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.parameter.ParameterTypeColor;
import edu.udo.cs.jvito.parameter.ParameterTypeDynamicCategory;
import edu.udo.cs.jvito.plot.ColorPanel;
import edu.udo.cs.jvito.plot.Plot;
import edu.udo.cs.jvito.plot.PlotPanel;
import edu.udo.cs.jvito.plot.RectangularGridLayout;
import edu.udo.cs.jvito.plot.SurveyAttributePanel;
import edu.udo.cs.jvito.util.Logger;
import edu.udo.cs.jvito.util.Utils;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.border.LineBorder;

public class SurveyPlot
extends Plot
implements AdjustmentListener,
MouseListener,
MouseMotionListener {
    private int sort1_attr = 0;
    private int sort2_attr = 0;
    private int sort3_attr;
    private JComboBox sort1_cbox;
    private JComboBox sort2_cbox;
    private JComboBox sort3_cbox;
    protected int CurX = 0;
    protected int CurY = 0;
    private int oldX;
    private int oldY;
    protected int NumVisX;
    protected int NumVisY = 1;
    protected int LABEL_WIDTH = 10;
    protected int LABEL_HEIGHT = 20;
    protected static final int MIN_VIS_WIDTH = 50;
    protected static final int MIN_VIS_HEIGHT = 50;
    protected int DEFAULT_VIS_WIDTH = 150;
    protected int DEFAULT_VIS_HEIGHT = 150;
    protected Panel DisplayPanel;
    protected JPanel ScrollPanel;
    protected ScrollPane SCPane;
    protected JViewport HorizLabels;
    protected JViewport VertLabels;
    protected JPanel[] HorizLabel;
    protected JPanel[] VertLabel;
    protected JComponent[] HorizDrag;
    protected JComponent[] VertDrag;
    protected JPanel HorizPanel;
    protected JPanel VertPanel;
    private JPanel plotpanel;
    private JPanel display;
    private JPanel widgets;
    private JPanel mainpane;
    private JPanel settings;
    private Attribute[] attributes = new Attribute[0];
    private String[] attr_names;
    private Attribute label;
    private Attribute prediction;
    private Color[] colortable;
    private int[] attribute_index;
    private static final String[] ATTRIBUTE_MODE = new String[]{"original", "correlation_label", "correlation_prediction", "weights", "selection"};
    private int number_atts = 0;
    private float[][] samples;
    private float globalmin;
    private float globalmax;
    private float[] labelvalues;
    private float[] predvalues;
    private Attribute sort_attribute_1;
    private Attribute sort_attribute_2;
    private Attribute sort_attribute_3;
    private Attribute color_attribute;
    private JPanel[][] displaypanel;

    public Component getSaveableComponent() {
        return this.DisplayPanel;
    }

    public JPanel getPlotPanel() {
        if (!this.isCompiled()) {
            return null;
        }
        return this.mainpane;
    }

    private void initComponents() {
        this.plotpanel = new JPanel();
        this.plotpanel.setLayout(new BorderLayout(10, 10));
        this.settings = new JPanel();
        this.settings.setLayout(new BorderLayout());
        if (!this.source.isCompiled()) {
            return;
        }
        ExampleSet set = this.source.getExampleSet();
        this.init();
    }

    private void init() {
        JViewport vl;
        JViewport hl;
        this.mainpane = new JPanel();
        this.mainpane.setLayout(new BorderLayout(5, 5));
        this.plotpanel = new JPanel();
        this.plotpanel.setBackground(Color.white);
        this.plotpanel.setLayout(new BoxLayout(this.plotpanel, 1));
        this.mainpane.add((Component)this.plotpanel, "Center");
        JPanel horizShell = new JPanel();
        horizShell.setBackground(Color.white);
        horizShell.setLayout(new BoxLayout(horizShell, 0));
        horizShell.add(Box.createRigidArea(new Dimension(this.LABEL_WIDTH + 6, 0)));
        this.plotpanel.add(horizShell);
        this.HorizPanel = new JPanel(){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                return new Dimension(d.width, SurveyPlot.this.LABEL_HEIGHT);
            }
        };
        this.HorizPanel.setBackground(Color.white);
        this.constructHorizontalLabels();
        this.HorizLabels = hl = new JViewport(){

            public Dimension getMinimumSize() {
                return new Dimension(0, SurveyPlot.this.LABEL_HEIGHT);
            }

            public Dimension getPreferredSize() {
                return new Dimension(0, SurveyPlot.this.LABEL_HEIGHT);
            }

            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, SurveyPlot.this.LABEL_HEIGHT);
            }
        };
        this.HorizLabels.setView(this.HorizPanel);
        horizShell.add(this.HorizLabels);
        horizShell.add(new JComponent(){

            public Dimension getMinimumSize() {
                return new Dimension(6 + SurveyPlot.this.SCPane.getVScrollbarWidth(), 0);
            }

            public Dimension getPreferredSize() {
                return new Dimension(6 + SurveyPlot.this.SCPane.getVScrollbarWidth(), 0);
            }

            public Dimension getMaximumSize() {
                return new Dimension(6 + SurveyPlot.this.SCPane.getVScrollbarWidth(), 0);
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(Color.white);
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        this.plotpanel.add(mainPanel);
        this.plotpanel.add(Box.createRigidArea(new Dimension(0, 6)));
        JPanel vertShell = new JPanel();
        vertShell.setBackground(Color.white);
        vertShell.setLayout(new BoxLayout(vertShell, 1));
        mainPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        mainPanel.add(vertShell);
        this.VertPanel = new JPanel(){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                return new Dimension(SurveyPlot.this.LABEL_WIDTH, d.height);
            }
        };
        this.VertPanel.setBackground(Color.white);
        this.constructVerticalLabels();
        this.VertLabels = vl = new JViewport(){

            public Dimension getMinimumSize() {
                return new Dimension(SurveyPlot.this.LABEL_WIDTH, 0);
            }

            public Dimension getPreferredSize() {
                return new Dimension(SurveyPlot.this.LABEL_WIDTH, 0);
            }

            public Dimension getMaximumSize() {
                return new Dimension(SurveyPlot.this.LABEL_WIDTH, Integer.MAX_VALUE);
            }
        };
        this.VertLabels.setView(this.VertPanel);
        vertShell.add(this.VertLabels);
        vertShell.add(new JComponent(){

            public Dimension getMinimumSize() {
                return new Dimension(0, SurveyPlot.this.SCPane.getHScrollbarHeight());
            }

            public Dimension getPreferredSize() {
                return new Dimension(0, SurveyPlot.this.SCPane.getHScrollbarHeight());
            }

            public Dimension getMaximumSize() {
                return new Dimension(0, SurveyPlot.this.SCPane.getHScrollbarHeight());
            }
        });
        this.ScrollPanel = new JPanel();
        this.ScrollPanel.setBackground(Color.white);
        this.ScrollPanel.setLayout(new BoxLayout(this.ScrollPanel, 0));
        mainPanel.add(this.ScrollPanel);
        mainPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        this.SCPane = new ScrollPane(1){

            public Dimension getPreferredSize() {
                return new Dimension(0, 0);
            }
        };
        Adjustable hadj = this.SCPane.getHAdjustable();
        Adjustable vadj = this.SCPane.getVAdjustable();
        hadj.setBlockIncrement(50);
        hadj.setUnitIncrement(12);
        hadj.addAdjustmentListener(this);
        vadj.setBlockIncrement(50);
        vadj.setUnitIncrement(12);
        vadj.addAdjustmentListener(this);
        this.ScrollPanel.add(this.SCPane);
        this.DisplayPanel = new Panel();
        this.DisplayPanel.setBackground(Color.darkGray);
        this.SCPane.add(this.DisplayPanel);
        this.constructArray();
        this.mainpane.add((Component)this.settings, "East");
        ExampleSet set = this.source.getExampleSet();
        if (this.getParameterAsInt("color_attribute") != 0) {
            this.initColorTable(this.source.getExampleColoring().getStartColorOfAttribute(this.color_attribute), this.source.getExampleColoring().getEndColorOfAttribute(this.color_attribute));
            ColorPanel colorpanel = new ColorPanel(this.color_attribute, this.colortable, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
            if (this.getParameterAsInt("color_attribute") > set.getNumberOfAttributes()) {
                if (set.getLabel() != null && set.getLabel().isNominal() && this.getParameterAsInt("color_attribute") == set.getNumberOfAttributes() + 1) {
                    Color[] colors = new Color[set.getLabel().getValues().size()];
                    Collection values = set.getLabel().getValues();
                    Object[] valuesstr = values.toArray();
                    for (int i = 0; i < valuesstr.length; ++i) {
                        colors[i] = this.source.getExampleColoring().getColorOfLabelValue(set.getLabel(), (String)valuesstr[i]);
                    }
                    colorpanel = new ColorPanel(set.getLabel(), colors, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
                } else if (set.getPredictedLabel() != null && set.getPredictedLabel().isNominal()) {
                    Collection values = set.getPredictedLabel().getValues();
                    Object[] valuesstr = values.toArray();
                    Color[] colors = new Color[set.getPredictedLabel().getValues().size() * set.getPredictedLabel().getValues().size()];
                    String[] valuestring = new String[valuesstr.length * valuesstr.length];
                    for (int i = 0; i < valuesstr.length; ++i) {
                        for (int j = 0; j < valuesstr.length; ++j) {
                            valuestring[i * valuesstr.length + j] = new String((String)valuesstr[i] + " - " + (String)valuesstr[j]);
                            colors[i * valuesstr.length + j] = this.source.getExampleColoring().getColorOfLabelvsPred(set.getLabel(), set.getPredictedLabel(), (String)valuesstr[i], (String)valuesstr[j]);
                        }
                    }
                    colorpanel = new ColorPanel(set.getPredictedLabel(), valuestring, colors, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
                }
            }
            if (set.getPredictedLabel() != null) {
                colorpanel.setPreferredSize(new Dimension(125, colorpanel.getHeight()));
            }
            this.settings.add(colorpanel);
        }
    }

    public void initColorTable(Color startcolor, Color endcolor) {
        int size = 100;
        if (this.color_attribute.isNominal()) {
            size = this.color_attribute.getNumberOfValues();
        }
        this.colortable = new Color[size];
        float red_start = startcolor.getRed();
        float green_start = startcolor.getGreen();
        float blue_start = startcolor.getBlue();
        float red_end = endcolor.getRed();
        float green_end = endcolor.getGreen();
        float blue_end = endcolor.getBlue();
        float d_red = (red_end - red_start) / ((float)size - 1.0f);
        float d_green = (green_end - green_start) / ((float)size - 1.0f);
        float d_blue = (blue_end - blue_start) / ((float)size - 1.0f);
        for (int i = 0; i < this.colortable.length; ++i) {
            this.colortable[i] = new Color((int)red_start, (int)green_start, (int)blue_start);
            red_start += d_red;
            green_start += d_green;
            blue_start += d_blue;
        }
    }

    private void initDisplay() {
        this.display = new JPanel();
        this.display.setLayout(new BorderLayout());
        if (!this.isCompiled()) {
            return;
        }
    }

    protected void refreshCells() {
        Thread thread = new Thread(){

            public void run() {
                for (int i = 0; i < SurveyPlot.this.NumVisX; ++i) {
                    for (int j = 0; j < SurveyPlot.this.NumVisY; ++j) {
                        SurveyPlot.this.displaypanel[i][j].repaint();
                    }
                }
            }
        };
        thread.start();
    }

    private void synchLabelAndCellSizes() {
        for (int j = 0; j < this.NumVisY; ++j) {
            int h = this.VertLabel[j].getSize().height;
            for (int i = 0; i < this.NumVisX; ++i) {
                int w = this.HorizLabel[i].getSize().width;
                this.displaypanel[i][j].setPreferredSize(new Dimension(w, h));
                ((PlotPanel)this.displaypanel[i][j]).setDimension(new Dimension(w, h));
            }
        }
        this.HorizLabels.validate();
        this.VertLabels.validate();
        this.DisplayPanel.doLayout();
        this.SCPane.validate();
        this.refreshCells();
    }

    private void constructArray() {
        this.DisplayPanel.setLayout(new RectangularGridLayout(this.NumVisX, 1, 5, 5));
        for (int j = 0; j < this.NumVisY; ++j) {
            int ph = this.VertLabel[j].getPreferredSize().height;
            for (int i = 0; i < this.NumVisX; ++i) {
                int pw = this.HorizLabel[i].getPreferredSize().width;
                this.displaypanel[i][j].setPreferredSize(new Dimension(pw, ph));
                this.DisplayPanel.add(this.displaypanel[i][j]);
            }
        }
        this.selectCell(0, 0);
    }

    private void constructHorizontalLabels() {
        this.constructHorizontalLabels(null, null);
    }

    private void constructHorizontalLabels(String[] l, int[] widths) {
        int i;
        if (l == null) {
            l = new String[this.NumVisX];
            for (i = 0; i < this.NumVisX; ++i) {
                l[i] = this.attributes[this.attribute_index[i]].getName();
            }
        }
        if (widths == null) {
            widths = new int[this.NumVisX];
            for (i = 0; i < this.NumVisX; ++i) {
                widths[i] = this.DEFAULT_VIS_WIDTH;
            }
        }
        this.HorizPanel.setLayout(new RectangularGridLayout(2 * this.NumVisX, 1, 0, 0));
        this.HorizLabel = new JPanel[this.NumVisX];
        this.HorizDrag = new JComponent[this.NumVisX];
        for (i = 0; i < this.NumVisX; ++i) {
            this.HorizLabel[i] = new JPanel();
            this.HorizLabel[i].setBorder(new LineBorder(Color.black, 1));
            this.HorizLabel[i].setLayout(new BorderLayout());
            this.HorizLabel[i].setPreferredSize(new Dimension(widths[i], this.LABEL_HEIGHT));
            this.HorizLabel[i].add("Center", new JLabel(l[i], 0));
            this.HorizPanel.add(this.HorizLabel[i]);
            this.HorizDrag[i] = new JComponent(){

                public void paint(Graphics g) {
                    Dimension d = this.getSize();
                    g.setColor(Color.black);
                    g.drawRect(0, 0, d.width - 1, d.height - 1);
                    g.setColor(Color.yellow);
                    g.fillRect(1, 1, d.width - 2, d.height - 2);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(5, SurveyPlot.this.LABEL_HEIGHT);
                }
            };
            this.HorizDrag[i].setPreferredSize(new Dimension(5, 0));
            this.HorizDrag[i].addMouseListener(this);
            this.HorizDrag[i].addMouseMotionListener(this);
            this.HorizPanel.add(this.HorizDrag[i]);
        }
    }

    private void constructVerticalLabels() {
        this.constructVerticalLabels(null, null);
    }

    private void constructVerticalLabels(String[] l, int[] heights) {
        int i;
        if (l == null) {
            l = new String[this.NumVisY];
            for (i = 0; i < this.NumVisY; ++i) {
                l[i] = "";
            }
        }
        if (heights == null) {
            heights = new int[this.NumVisY];
            for (i = 0; i < this.NumVisY; ++i) {
                heights[i] = this.DEFAULT_VIS_HEIGHT;
            }
        }
        this.VertPanel.setLayout(new RectangularGridLayout(1, 2 * this.NumVisY, 0, 0));
        this.VertLabel = new JPanel[this.NumVisY];
        this.VertDrag = new JComponent[this.NumVisY];
        for (i = 0; i < this.NumVisY; ++i) {
            this.VertLabel[i] = new JPanel();
            this.VertLabel[i].setBorder(new LineBorder(Color.black, 1));
            this.VertLabel[i].setLayout(new BorderLayout());
            this.VertLabel[i].setPreferredSize(new Dimension(this.LABEL_WIDTH, heights[i]));
            this.VertLabel[i].add("Center", new JLabel(l[i], 0));
            this.VertPanel.add(this.VertLabel[i]);
            this.VertDrag[i] = new JComponent(){

                public void paint(Graphics g) {
                    Dimension d = this.getSize();
                    g.setColor(Color.black);
                    g.drawRect(0, 0, d.width - 1, d.height - 1);
                    g.setColor(Color.yellow);
                    g.fillRect(1, 1, d.width - 2, d.height - 2);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(SurveyPlot.this.LABEL_WIDTH, 5);
                }
            };
            this.VertDrag[i].setBackground(Color.white);
            this.VertDrag[i].setPreferredSize(new Dimension(0, 5));
            this.VertDrag[i].addMouseListener(this);
            this.VertDrag[i].addMouseMotionListener(this);
            this.VertPanel.add(this.VertDrag[i]);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        Adjustable a = e.getAdjustable();
        int value = a.getValue();
        if (a.getOrientation() == 0) {
            this.HorizLabels.setViewPosition(new Point(value, 0));
        } else {
            this.VertLabels.setViewPosition(new Point(0, value));
        }
    }

    public void mousePressed(MouseEvent e) {
        Component c = e.getComponent();
        for (int j = 0; j < this.NumVisY; ++j) {
            for (int i = 0; i < this.NumVisX; ++i) {
                if (c != this.displaypanel[i][j]) continue;
                this.selectCell(i, j);
                return;
            }
        }
        this.oldX = e.getX();
        this.oldY = e.getY();
    }

    public void mouseReleased(MouseEvent e) {
        int j;
        int x = e.getX();
        int y = e.getY();
        Component c = e.getComponent();
        boolean change = false;
        for (j = 0; j < this.NumVisX; ++j) {
            if (c != this.HorizDrag[j]) continue;
            change = true;
            break;
        }
        for (j = 0; j < this.NumVisY; ++j) {
            if (c != this.VertDrag[j]) continue;
            change = true;
            break;
        }
        if (change) {
            this.synchLabelAndCellSizes();
        }
    }

    public void mouseDragged(MouseEvent e) {
        int j;
        Component c = e.getComponent();
        int x = e.getX();
        int y = e.getY();
        for (j = 0; j < this.NumVisX; ++j) {
            if (c != this.HorizDrag[j]) continue;
            Dimension s = this.HorizLabel[j].getSize();
            int oldW = s.width;
            s.width += x - this.oldX;
            if (s.width < 50) {
                s.width = 50;
            }
            this.HorizLabel[j].setSize(s);
            this.HorizLabel[j].setPreferredSize(s);
            this.HorizLabels.validate();
            return;
        }
        for (j = 0; j < this.NumVisY; ++j) {
            if (c != this.VertDrag[j]) continue;
            Dimension s = this.VertLabel[j].getSize();
            int oldH = s.height;
            s.height += y - this.oldY;
            if (s.height < 50) {
                s.height = 50;
            }
            this.VertLabel[j].setSize(s);
            this.VertLabel[j].setPreferredSize(s);
            this.VertLabels.validate();
            return;
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void selectCell(int x, int y) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x >= this.NumVisX) {
            x = this.NumVisX - 1;
        }
        if (y >= this.NumVisY) {
            y = this.NumVisY - 1;
        }
        for (int j = 0; j < this.NumVisY; ++j) {
            for (int i = 0; i < this.NumVisX; ++i) {
                boolean selected = x == i && y == j;
            }
        }
        this.CurX = x;
        this.CurY = y;
    }

    private void createDisplayPanel() {
        this.displaypanel = new JPanel[this.NumVisX][this.NumVisY];
        int attr = 1;
        for (int i = 0; i < this.NumVisY; ++i) {
            for (int j = 0; j < this.NumVisX; ++j) {
                if (i != 0) {
                    this.displaypanel[j][i] = new JPanel();
                } else {
                    this.displaypanel[j][0] = attr <= this.number_atts ? this.createDisplayPanel(this.samples[this.attribute_index[attr - 1]], this.attribute_index[attr - 1]) : new JPanel();
                }
                ++attr;
            }
        }
    }

    private JPanel createDisplayPanel(float[] attr_values, int attr_index) {
        ExampleSet set = this.source.getExampleSet();
        boolean haslabel = this.source.getExampleSet().getLabel() != null;
        boolean haspredlabel = this.source.getExampleSet().getPredictedLabel() != null;
        SurveyAttributePanel plotpanel = null;
        plotpanel = this.getParameterAsBoolean("local_normalization") ? new SurveyAttributePanel(this.source.getExampleSet(), this.source.getExampleColoring(), attr_values) : (haslabel && attr_index < set.getNumberOfAttributes() ? new SurveyAttributePanel(this.source.getExampleSet(), this.source.getExampleColoring(), attr_values, this.globalmin, this.globalmax) : new SurveyAttributePanel(this.source.getExampleSet(), this.source.getExampleColoring(), attr_values));
        plotpanel.setForegroundColor(this.getParameterAsColor("foreground"));
        plotpanel.setBackgroundColor(this.getParameterAsColor("background"));
        String color_attribute = ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).getValues()[this.getParameterAsInt("color_attribute")];
        if (color_attribute.equals("<None>")) {
            this.color_attribute = null;
        } else if (haslabel && color_attribute.equals(this.source.getExampleSet().getLabel().getName())) {
            this.color_attribute = this.label;
            plotpanel.colorByAttribute(this.source.getExampleSet().getLabel(), this.labelvalues);
            plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfAttribute(this.source.getExampleSet().getLabel()));
            plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfAttribute(this.source.getExampleSet().getLabel()));
            plotpanel.initColorTable();
        } else if (haspredlabel && color_attribute.equals(this.source.getExampleSet().getPredictedLabel().getName()) && this.prediction.isNominal()) {
            this.color_attribute = this.prediction;
            Collection values = set.getPredictedLabel().getValues();
            Object[] valuesstr = values.toArray();
            Color[] colors = new Color[set.getPredictedLabel().getValues().size() * set.getPredictedLabel().getValues().size()];
            for (int i = 0; i < valuesstr.length; ++i) {
                for (int j = 0; j < valuesstr.length; ++j) {
                    colors[i * valuesstr.length + j] = this.source.getExampleColoring().getColorOfLabelvsPred(this.label, this.prediction, (String)valuesstr[i], (String)valuesstr[j]);
                }
            }
            float[] pvalues = new float[this.source.getExampleSet().getSize()];
            for (int i = 0; i < this.predvalues.length; ++i) {
                pvalues[i] = this.labelvalues[i] * (float)valuesstr.length + this.predvalues[i];
            }
            plotpanel.colorByAttribute(this.prediction, pvalues, colors);
            plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfPredLabel(this.prediction));
            plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfPredLabel(this.prediction));
        } else if (haspredlabel && color_attribute.equals(this.source.getExampleSet().getPredictedLabel().getName()) && this.prediction.isNumerical()) {
            this.color_attribute = this.prediction;
            plotpanel.colorByAttribute(this.prediction, this.predvalues);
            plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfPredLabel(this.prediction));
            plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfPredLabel(this.prediction));
            plotpanel.initColorTable();
        } else if (!color_attribute.equals("")) {
            this.color_attribute = this.source.getExampleSet().getAttribute(color_attribute);
            plotpanel.colorByAttribute(this.source.getExampleSet().getAttribute(color_attribute), this.samples[this.attribute_index[this.getParameterAsInt("color_attribute") - 1]]);
            plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfAttribute(this.source.getExampleSet().getAttribute(color_attribute)));
            plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfAttribute(this.source.getExampleSet().getAttribute(color_attribute)));
            plotpanel.initColorTable();
        }
        return plotpanel;
    }

    public void quickSort(float[][] array, int sort_index, int links, int rechts) {
        int left = links;
        int right = rechts;
        float pivot = array[sort_index][(links + rechts) / 2];
        while (true) {
            if (array[sort_index][left] < pivot) {
                ++left;
                continue;
            }
            while (array[sort_index][right] > pivot) {
                --right;
            }
            if (left <= right) {
                float temp;
                for (int d = 0; d < this.samples.length; ++d) {
                    temp = array[d][left];
                    array[d][left] = array[d][right];
                    array[d][right] = temp;
                }
                if (this.source.getExampleSet().getLabel() != null) {
                    temp = this.labelvalues[left];
                    this.labelvalues[left] = this.labelvalues[right];
                    this.labelvalues[right] = temp;
                }
                if (this.source.getExampleSet().getPredictedLabel() != null) {
                    temp = this.predvalues[left];
                    this.predvalues[left] = this.predvalues[right];
                    this.predvalues[right] = temp;
                }
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (links < right) {
            this.quickSort(array, sort_index, links, right);
        }
        if (left < rechts) {
            this.quickSort(array, sort_index, left, rechts);
        }
    }

    public void orderValues() {
        if (this.sort_attribute_1 != null) {
            int sort1_index = this.getIndexOfAttribute(this.sort_attribute_1);
            this.quickSort(this.samples, sort1_index, 0, this.samples[0].length - 1);
            if (this.sort_attribute_2 != null) {
                float value;
                int end_index;
                int sort2_index = this.getIndexOfAttribute(this.sort_attribute_2);
                int start_index = 0;
                float lastvalue = this.samples[sort1_index][start_index];
                for (end_index = 1; end_index < this.samples[0].length; ++end_index) {
                    value = this.samples[sort1_index][end_index];
                    if (value != lastvalue) {
                        if (end_index != start_index + 1) {
                            this.quickSort(this.samples, sort2_index, start_index, end_index - 1);
                        }
                        start_index = end_index;
                    }
                    lastvalue = value;
                }
                if (this.sort_attribute_3 != null) {
                    int sort3_index = this.getIndexOfAttribute(this.sort_attribute_3);
                    start_index = 0;
                    lastvalue = this.samples[sort2_index][start_index];
                    for (end_index = 1; end_index < this.samples[0].length; ++end_index) {
                        value = this.samples[sort2_index][end_index];
                        if (value != lastvalue) {
                            if (end_index != start_index + 1) {
                                this.quickSort(this.samples, sort3_index, start_index, end_index - 1);
                            }
                            start_index = end_index;
                        }
                        lastvalue = value;
                    }
                }
            }
        }
    }

    private int getIndexOfAttribute(Attribute attr) {
        for (int index = 0; index < this.attributes.length; ++index) {
            if (!this.attributes[index].getName().equals(attr.getName())) continue;
            return index;
        }
        return -1;
    }

    public List getParameterTypes() {
        LinkedList<ParameterTypeColor> types = new LinkedList<ParameterTypeColor>();
        ParameterTypeSingle type = new ParameterTypeColor("background", "The background-color.", Color.WHITE);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeColor("foreground", "The foreground-color.", Color.DARK_GRAY);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeInt("plot_width", "The width of each 2D-Scatterplot.", 50, 1000, 150);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeDynamicCategory("sort_attribute_1", "Sort the data first by this attribute.", this.getAttributes(), 0);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeDynamicCategory("sort_attribute_2", "Sort the data second by this attribute.", this.getAttributes(), 0);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeDynamicCategory("sort_attribute_3", "Sort the data third by this attribute.", this.getAttributes(), 0);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeBoolean("local_normalization", "The data have to be local normalized, otherwise global normalized.", true);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeDynamicCategory("color_attribute", "This attribute is the color-dimension.", this.getColorAttributes(), 0);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeStringCategory("attribute_mode", "Select the mode to display the attributes.", ATTRIBUTE_MODE, ATTRIBUTE_MODE[0]);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeInt("number_attributes", "This number of the first correlated Attributes with the function values are displayed.", -1, Integer.MAX_VALUE, -1);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeFile("attribute_weights_file", "The file-location of the weights.", true);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeString("attributes", "These attributes are displayed(comma-separated attribute-names).", "");
        types.add((ParameterTypeColor)type);
        return types;
    }

    public void compile() throws CompilerException {
        double[] st_deviation;
        double[] mean;
        String mode;
        this.iscompiling = true;
        ExampleSet set = this.source.getExampleSet();
        boolean haslabel = set.getLabel() != null;
        boolean haspredlabel = set.getPredictedLabel() != null;
        int number_of_samples = set.getSize();
        this.number_atts = set.getNumberOfAttributes();
        if (haslabel) {
            ++this.number_atts;
        }
        if (haspredlabel) {
            ++this.number_atts;
        }
        this.attributes = new Attribute[this.number_atts];
        this.attr_names = new String[this.number_atts];
        for (int att = 0; att < set.getNumberOfAttributes(); ++att) {
            this.attributes[att] = set.getAttribute(att);
            this.attr_names[att] = set.getAttribute(att).getName();
        }
        if (haslabel) {
            this.attributes[set.getNumberOfAttributes()] = set.getLabel();
            this.attr_names[set.getNumberOfAttributes()] = set.getLabel().getName();
        }
        if (haspredlabel) {
            this.attributes[this.number_atts - 1] = set.getPredictedLabel();
            this.attr_names[this.number_atts - 1] = set.getPredictedLabel().getName();
        }
        this.label = set.getLabel();
        this.prediction = set.getPredictedLabel();
        this.samples = new float[this.number_atts][number_of_samples];
        this.labelvalues = new float[number_of_samples];
        this.predvalues = new float[number_of_samples];
        ExampleReader reader = set.getExampleReader();
        for (int sample = 0; sample < number_of_samples; ++sample) {
            Example example = reader.next();
            for (int d = 0; d < set.getNumberOfAttributes(); ++d) {
                this.samples[d][sample] = (float)example.getValue(d);
                if (sample == 0 && d == 0) {
                    this.globalmin = this.samples[0][0];
                    this.globalmax = this.samples[0][0];
                    continue;
                }
                this.globalmin = Math.min(this.globalmin, this.samples[d][sample]);
                this.globalmax = Math.max(this.globalmax, this.samples[d][sample]);
            }
            if (haslabel) {
                this.labelvalues[sample] = (float)example.getLabel();
                this.samples[set.getNumberOfAttributes()][sample] = (float)example.getLabel();
            }
            if (!haspredlabel) continue;
            this.predvalues[sample] = (float)example.getPredictedLabel();
            this.samples[this.number_atts - 1][sample] = (float)example.getPredictedLabel();
        }
        this.attribute_index = new int[this.number_atts];
        for (int i = 0; i < this.attribute_index.length; ++i) {
            this.attribute_index[i] = i;
        }
        int number_attribute = this.getParameterAsInt("number_attributes");
        if (number_attribute == 0) {
            number_attribute = -1;
        }
        if (number_attribute == -1) {
            number_attribute = this.number_atts;
        }
        if ((mode = this.getParameterAsString("attribute_mode")).equals(ATTRIBUTE_MODE[0])) {
            this.number_atts = number_attribute;
        } else if (mode.equals(ATTRIBUTE_MODE[1])) {
            int i;
            if (!haslabel) {
                throw new CompilerException("The ExampleSet must have a numeric label.");
            }
            if (this.label.isNominal()) {
                throw new CompilerException("The ExampleSet must have a numeric label.");
            }
            mean = new double[set.getNumberOfAttributes() + 1];
            st_deviation = new double[set.getNumberOfAttributes() + 1];
            double[] covariance = new double[set.getNumberOfAttributes()];
            for (i = 0; i < set.getNumberOfAttributes(); ++i) {
                mean[i] = this.attributes[i].getAverage();
            }
            mean[mean.length - 1] = this.label.getAverage();
            for (i = 0; i < set.getNumberOfAttributes(); ++i) {
                st_deviation[i] = Math.sqrt(this.attributes[i].getVariance());
            }
            st_deviation[st_deviation.length - 1] = Math.sqrt(this.label.getVariance());
            for (i = 0; i < set.getNumberOfAttributes(); ++i) {
                covariance[i] = 0.0;
                for (int j = 0; j < number_of_samples; ++j) {
                    int n = i;
                    covariance[n] = covariance[n] + ((double)this.samples[i][j] - mean[i]) * ((double)this.labelvalues[j] - mean[mean.length - 1]);
                }
                covariance[i] = covariance[i] / (double)(number_of_samples - 1);
            }
            double[] correlation = new double[set.getNumberOfAttributes()];
            for (int i2 = 0; i2 < correlation.length; ++i2) {
                correlation[i2] = st_deviation[i2] * st_deviation[st_deviation.length - 1];
                correlation[i2] = correlation[i2] == 0.0 ? covariance[i2] : covariance[i2] / correlation[i2];
            }
            this.orderWeights(correlation);
            String props = new String("\n");
            props = props + Utils.getString("Attribute", 25, 0) + "| " + Utils.getString("Correlation with label", 25, 0) + "\n";
            props = props + Utils.duplicateString("-", 25) + "+ " + Utils.duplicateString("-", 25) + "\n";
            for (int i3 = 0; i3 < 100 && i3 < correlation.length; ++i3) {
                props = props + Utils.getString(this.attributes[this.attribute_index[i3]].getName(), 25, 0) + "| " + Utils.getString(Double.toString(correlation[i3]), 25, 1) + "\n";
            }
            Logger.logMessage(props, 3);
            this.number_atts = number_attribute;
        } else if (mode.equals(ATTRIBUTE_MODE[2])) {
            int i;
            if (!haspredlabel) {
                throw new CompilerException("The ExampleSet must have a numeric predicted label.");
            }
            if (this.prediction.isNominal()) {
                throw new CompilerException("The ExampleSet must have a numeric predictedlabel.");
            }
            mean = new double[set.getNumberOfAttributes() + 1];
            st_deviation = new double[set.getNumberOfAttributes() + 1];
            double[] covariance = new double[set.getNumberOfAttributes()];
            for (i = 0; i < set.getNumberOfAttributes(); ++i) {
                mean[i] = this.attributes[i].getAverage();
            }
            mean[mean.length - 1] = this.prediction.getAverage();
            for (i = 0; i < set.getNumberOfAttributes(); ++i) {
                st_deviation[i] = Math.sqrt(this.attributes[i].getVariance());
            }
            st_deviation[st_deviation.length - 1] = Math.sqrt(this.prediction.getVariance());
            for (i = 0; i < set.getNumberOfAttributes(); ++i) {
                covariance[i] = 0.0;
                for (int j = 0; j < number_of_samples; ++j) {
                    int n = i;
                    covariance[n] = covariance[n] + ((double)this.samples[i][j] - mean[i]) * ((double)this.predvalues[j] - mean[mean.length - 1]);
                }
                covariance[i] = covariance[i] / (double)(number_of_samples - 1);
            }
            double[] correlation = new double[set.getNumberOfAttributes()];
            for (int i4 = 0; i4 < correlation.length; ++i4) {
                correlation[i4] = st_deviation[i4] * st_deviation[st_deviation.length - 1];
                correlation[i4] = correlation[i4] == 0.0 ? covariance[i4] : covariance[i4] / correlation[i4];
            }
            this.orderWeights(correlation);
            String props = new String("\n");
            props = props + Utils.getString("Attribute", 25, 0) + "| " + Utils.getString("Correlation prediction", 25, 0) + "\n";
            props = props + Utils.duplicateString("-", 25) + "+ " + Utils.duplicateString("-", 25) + "\n";
            for (int i5 = 0; i5 < 100 && i5 < correlation.length; ++i5) {
                props = props + Utils.getString(this.attributes[this.attribute_index[i5]].getName(), 25, 0) + "| " + Utils.getString(Double.toString(correlation[i5]), 25, 1) + "\n";
            }
            Logger.logMessage(props, 3);
            this.number_atts = number_attribute;
        } else if (mode.equals(ATTRIBUTE_MODE[3])) {
            String weightFileName = this.getParameterAsString("attribute_weights_file");
            File weightFile = new File(weightFileName);
            AttributeWeights result = null;
            try {
                result = AttributeWeights.load(weightFile);
            }
            catch (IOException e) {
                throw new CompilerException(e.getMessage(), e);
            }
            double[] weights = new double[set.getNumberOfAttributes()];
            for (int i = 0; i < weights.length; ++i) {
                weights[i] = result.getWeight(this.attributes[i].getName());
            }
            this.orderWeights(weights);
            String props = new String("\n");
            props = props + Utils.getString("Attribute", 25, 0) + "| " + Utils.getString("Weight", 25, 0) + "\n";
            props = props + Utils.duplicateString("-", 25) + "+ " + Utils.duplicateString("-", 25) + "\n";
            for (int i = 0; i < 100 && i < weights.length; ++i) {
                props = props + Utils.getString(this.attributes[this.attribute_index[i]].getName(), 25, 0) + "| " + Utils.getString(Double.toString(weights[i]), 25, 1) + "\n";
            }
            Logger.logMessage(props, 3);
            this.number_atts = number_attribute;
        } else if (mode.equals(ATTRIBUTE_MODE[4])) {
            int i;
            StringTokenizer st = new StringTokenizer(this.getParameterAsString("attributes"), ",");
            int index = 0;
            while (st.hasMoreTokens()) {
                String a = st.nextToken();
                this.attribute_index[index] = 0;
                for (i = 0; i < this.attributes.length; ++i) {
                    if (!this.attributes[i].getName().equals(a)) continue;
                    this.attribute_index[index] = i;
                    ++index;
                }
            }
            this.number_atts = index;
            if (this.number_atts == 0) {
                throw new CompilerException("No attribute selected!");
            }
            for (i = index; i < this.attribute_index.length; ++i) {
                this.attribute_index[i] = 0;
            }
        }
        this.NumVisX = this.number_atts;
        this.NumVisY = 1;
        this.DEFAULT_VIS_HEIGHT = number_of_samples;
        this.DEFAULT_VIS_WIDTH = this.getParameterAsInt("plot_width");
        int sort1 = this.getParameterAsInt("sort_attribute_1") - 1;
        int sort2 = this.getParameterAsInt("sort_attribute_2") - 1;
        int sort3 = this.getParameterAsInt("sort_attribute_3") - 1;
        if (sort1 == -1) {
            this.sort_attribute_1 = null;
            this.sort_attribute_2 = null;
            this.sort_attribute_3 = null;
        } else {
            this.sort_attribute_1 = this.getSortAttributeByIndex(sort1);
            if (sort2 == -1) {
                this.sort_attribute_2 = null;
                this.sort_attribute_3 = null;
            } else {
                this.sort_attribute_2 = this.getSortAttributeByIndex(sort2);
                this.sort_attribute_3 = sort3 == -1 ? null : this.getSortAttributeByIndex(sort3);
            }
        }
        this.orderValues();
        this.createDisplayPanel();
        this.initComponents();
        this.iscompiling = false;
        this.iscompiled = true;
    }

    public void orderWeights(double[] array, int links, int rechts) {
        int left = links;
        int right = rechts;
        double pivot = array[(links + rechts) / 2];
        pivot = Math.abs(pivot);
        while (true) {
            if (Math.abs(array[left]) > pivot) {
                ++left;
                continue;
            }
            while (Math.abs(array[right]) < pivot) {
                --right;
            }
            if (left <= right) {
                double temp = array[left];
                array[left] = array[right];
                array[right] = temp;
                temp = this.attribute_index[left];
                this.attribute_index[left] = this.attribute_index[right];
                this.attribute_index[right] = (int)temp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (links < right) {
            this.orderWeights(array, links, right);
        }
        if (left < rechts) {
            this.orderWeights(array, left, rechts);
        }
    }

    public void orderWeights(double[] weights) {
        this.orderWeights(weights, 0, weights.length - 1);
    }

    private Attribute getSortAttributeByIndex(int index) {
        boolean haslabel;
        ExampleSet set = this.source.getExampleSet();
        boolean bl = haslabel = set.getLabel() != null;
        if (index < set.getNumberOfAttributes()) {
            return set.getAttribute(index);
        }
        if (haslabel && index == set.getNumberOfAttributes()) {
            return set.getLabel();
        }
        return set.getPredictedLabel();
    }

    public void parentIsCompiled() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
        ((ParameterTypeDynamicCategory)this.getParameterType("sort_attribute_1")).setValues(this.getAttributes());
        ((ParameterTypeDynamicCategory)this.getParameterType("sort_attribute_2")).setValues(this.getAttributes());
        ((ParameterTypeDynamicCategory)this.getParameterType("sort_attribute_3")).setValues(this.getAttributes());
    }

    public void refreshParameter() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
        ((ParameterTypeDynamicCategory)this.getParameterType("sort_attribute_1")).setValues(this.getAttributes());
        ((ParameterTypeDynamicCategory)this.getParameterType("sort_attribute_2")).setValues(this.getAttributes());
        ((ParameterTypeDynamicCategory)this.getParameterType("sort_attribute_3")).setValues(this.getAttributes());
    }

    public String[] getAttributes() {
        if (this.source == null) {
            return new String[]{"<None>"};
        }
        ExampleSet set = this.source.getExampleSet();
        if (set == null) {
            return new String[]{"<None>"};
        }
        int count = 0;
        count += set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            ++count;
        }
        if (set.getPredictedLabel() != null) {
            ++count;
        }
        String[] categories = new String[count + 1];
        categories[0] = "<None>";
        for (int i = 0; i < set.getNumberOfAttributes(); ++i) {
            categories[i + 1] = set.getAttribute(i).getName();
        }
        int index = set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            categories[index + 1] = set.getLabel().getName();
            ++index;
        }
        if (set.getPredictedLabel() != null) {
            categories[index + 1] = set.getPredictedLabel().getName();
        }
        return categories;
    }

    public String[] getColorAttributes() {
        if (this.source == null) {
            return new String[]{"<None>"};
        }
        if (!this.source.isCompiled()) {
            return new String[]{"<None>"};
        }
        ExampleSet set = this.source.getExampleSet();
        if (set == null) {
            return new String[]{"<None>"};
        }
        int count = 1;
        count += set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            ++count;
        }
        if (set.getPredictedLabel() != null) {
            ++count;
        }
        if (set.getLabel() != null && set.getLabel().isNominal() && set.getPredictedLabel() != null && set.getPredictedLabel().isNominal()) {
            ++count;
        }
        String[] categories = new String[count];
        categories[0] = "<None>";
        for (int i = 1; i <= set.getNumberOfAttributes(); ++i) {
            categories[i] = set.getAttribute(i - 1).getName();
        }
        int index = set.getNumberOfAttributes() + 1;
        if (set.getLabel() != null) {
            categories[index] = set.getLabel().getName();
            ++index;
        }
        if (set.getPredictedLabel() != null) {
            categories[index] = set.getPredictedLabel().getName();
            ++index;
        }
        return categories;
    }
}

