/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.NeuroNet.nets.SOM;
import edu.udo.cs.NeuroNet.neurons.KohonenNeuron;
import edu.udo.cs.jvito.plot.ColorPanel;
import edu.udo.cs.jvito.plot.PlotPanel;
import edu.udo.cs.yale.example.Attribute;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.JPanel;

public class SOMPanel
extends PlotPanel {
    private float colorattr_min;
    private float colorattr_max;
    private String attrname;
    private float[][] samples;
    private int width;
    private int height;
    private float deltawidth;
    private float deltaheight;
    private float mindistance;
    private float maxdistance;
    private boolean colormode;
    private boolean colordistance;
    private boolean colornumeric;
    private boolean shownumbersamples;
    private String[] attrnames;
    private SOM som;
    private float[][] cellvalues;
    private int[][][] cellnominals;
    private int[][] cellsample;
    private int[][] cellcount;

    public SOMPanel(SOM som, float[][] samples) {
        this.som = som;
        this.samples = samples;
        this.colormode = false;
        this.colordistance = false;
        this.colornumeric = false;
        this.initcolortable = false;
    }

    public void calculateSampleToCell() {
        block18: {
            block19: {
                int h;
                this.cellsample = new int[this.samples.length][2];
                this.cellcount = new int[this.som.getNumberOfHorizontalNeurons()][this.som.getNumberOfVerticalNeurons()];
                if (this.colormode) {
                    this.cellvalues = new float[this.som.getNumberOfHorizontalNeurons()][this.som.getNumberOfVerticalNeurons()];
                    if (this.colormode && !this.colornumeric) {
                        this.cellnominals = new int[this.som.getNumberOfHorizontalNeurons()][this.som.getNumberOfVerticalNeurons()][this.colortable.length];
                    }
                }
                for (h = 0; h < this.som.getNumberOfHorizontalNeurons(); ++h) {
                    for (int v = 0; v < this.som.getNumberOfVerticalNeurons(); ++v) {
                        this.cellcount[h][v] = 0;
                        if (!this.colormode) continue;
                        this.cellvalues[h][v] = Float.NaN;
                        if (!this.colormode || this.colornumeric) continue;
                        for (int c = 0; c < this.colorattr.getNumberOfValues(); ++c) {
                            this.cellnominals[h][v][c] = 0;
                        }
                    }
                }
                for (int s = 0; s < this.samples.length; ++s) {
                    this.som.setInputValues(this.samples[s]);
                    KohonenNeuron minNeuron = null;
                    float minout = 0.0f;
                    float out = 0.0f;
                    for (int h2 = 0; h2 < this.som.getNumberOfHorizontalNeurons(); ++h2) {
                        for (int v = 0; v < this.som.getNumberOfVerticalNeurons(); ++v) {
                            KohonenNeuron kneuron = this.som.getKohonenNeuron(h2, v);
                            if (minNeuron == null) {
                                minNeuron = kneuron;
                                minout = kneuron.getOutputValue(true);
                                continue;
                            }
                            out = kneuron.getOutputValue(true);
                            if (!(out < minout)) continue;
                            minNeuron = kneuron;
                            minout = out;
                        }
                    }
                    this.cellsample[s][0] = minNeuron.getHorizontalPosition() - 1;
                    this.cellsample[s][1] = minNeuron.getVerticalPosition() - 1;
                    int[] nArray = this.cellcount[this.cellsample[s][0]];
                    int n = this.cellsample[s][1];
                    nArray[n] = nArray[n] + 1;
                    if (!this.colormode) continue;
                    if (this.colorattr.isNumerical()) {
                        if (Float.isNaN(this.cellvalues[this.cellsample[s][0]][this.cellsample[s][1]])) {
                            this.cellvalues[this.cellsample[s][0]][this.cellsample[s][1]] = 0.0f;
                        }
                        float[] fArray = this.cellvalues[this.cellsample[s][0]];
                        int n2 = this.cellsample[s][1];
                        fArray[n2] = fArray[n2] + this.colorvalues[s];
                        continue;
                    }
                    if (!this.colorattr.isNominal()) continue;
                    int[] nArray2 = this.cellnominals[this.cellsample[s][0]][this.cellsample[s][1]];
                    int n3 = (int)this.colorvalues[s];
                    nArray2[n3] = nArray2[n3] + 1;
                }
                if (!this.colormode) break block18;
                if (!this.colorattr.isNumerical()) break block19;
                for (h = 0; h < this.som.getNumberOfHorizontalNeurons(); ++h) {
                    for (int v = 0; v < this.som.getNumberOfVerticalNeurons(); ++v) {
                        if (this.cellcount[h][v] == 0) {
                            this.cellvalues[h][v] = Float.NaN;
                            continue;
                        }
                        if (this.cellvalues[h][v] == Float.NaN) continue;
                        this.cellvalues[h][v] = this.cellvalues[h][v] / (float)this.cellcount[h][v];
                    }
                }
                break block18;
            }
            if (!this.colorattr.isNominal()) break block18;
            int classe = 0;
            for (int h = 0; h < this.som.getNumberOfHorizontalNeurons(); ++h) {
                for (int v = 0; v < this.som.getNumberOfVerticalNeurons(); ++v) {
                    for (int c = 0; c < this.colorattr.getNumberOfValues(); ++c) {
                        if (c == 0) {
                            classe = 0;
                            continue;
                        }
                        if (this.cellnominals[h][v][c] <= this.cellnominals[h][v][classe]) continue;
                        classe = c;
                    }
                    this.cellvalues[h][v] = classe;
                }
            }
        }
    }

    public void setShowNumberOfSamples(boolean show) {
        this.shownumbersamples = show;
    }

    public void setColorDistance(boolean colordistance) {
        this.colordistance = colordistance;
        if (colordistance) {
            this.colormode = false;
            this.calculateDistanceValues();
        }
    }

    public void colorByAttribute(Attribute attribute, float[] attrvalues) {
        this.colornumeric = false;
        if (attribute.isNumerical()) {
            this.colornumeric = true;
        }
        this.colormode = true;
        this.colordistance = false;
        this.colorattr = attribute;
        this.attrname = attribute.getName();
        this.colorvalues = attrvalues;
        super.colorByAttribute(attribute, attrvalues);
    }

    public void colorByAttribute(Attribute attribute, float[] attrvalues, Color[] colortable) {
        this.colornumeric = false;
        if (attribute.isNumerical()) {
            this.colornumeric = true;
        }
        this.colormode = true;
        this.colordistance = false;
        this.colorattr = attribute;
        this.attrname = attribute.getName();
        this.colorvalues = attrvalues;
        super.colorByAttribute(attribute, attrvalues, colortable);
    }

    public JPanel getColorPanel() {
        if (this.colormode) {
            return new ColorPanel(this.colorattr, this.colortable, this.foreground, this.background);
        }
        if (this.colordistance) {
            return new ColorPanel(this.mindistance, this.maxdistance, this.colortable, this.foreground, this.background);
        }
        return new JPanel();
    }

    public void calculateDistanceValues() {
        this.cellvalues = new float[this.som.getNumberOfHorizontalNeurons()][this.som.getNumberOfVerticalNeurons()];
        float dist = 0.0f;
        KohonenNeuron[] neighbour = new KohonenNeuron[8];
        for (int h = 0; h < this.som.getNumberOfHorizontalNeurons(); ++h) {
            for (int v = 0; v < this.som.getNumberOfVerticalNeurons(); ++v) {
                KohonenNeuron kneuron = this.som.getKohonenNeuron(h, v);
                neighbour[0] = this.som.getKohonenNeuron(h - 1, v + 1);
                neighbour[1] = this.som.getKohonenNeuron(h, v + 1);
                neighbour[2] = this.som.getKohonenNeuron(h + 1, v + 1);
                neighbour[3] = this.som.getKohonenNeuron(h + 1, v);
                neighbour[4] = this.som.getKohonenNeuron(h + 1, v - 1);
                neighbour[5] = this.som.getKohonenNeuron(h, v - 1);
                neighbour[6] = this.som.getKohonenNeuron(h - 1, v - 1);
                neighbour[7] = this.som.getKohonenNeuron(h - 1, v);
                int neighbours = 0;
                dist = 0.0f;
                for (int n = 0; n < 8; ++n) {
                    if (neighbour[n] == null) continue;
                    dist += this.getDistance(kneuron.getWeights(), neighbour[n].getWeights());
                    ++neighbours;
                }
                this.cellvalues[h][v] = dist / (float)neighbours;
                if (h == 0 && v == 0) {
                    this.mindistance = this.cellvalues[h][v];
                    this.maxdistance = this.cellvalues[h][v];
                    continue;
                }
                this.mindistance = Math.min(this.cellvalues[h][v], this.mindistance);
                this.maxdistance = Math.max(this.cellvalues[h][v], this.maxdistance);
            }
        }
    }

    private float getDistance(Vector weights1, Vector weights2) {
        float dist = 0.0f;
        for (int w = 0; w < Math.min(weights1.size(), weights2.size()); ++w) {
            float value1 = ((Float)weights1.get(w)).floatValue();
            float value2 = ((Float)weights2.get(w)).floatValue();
            dist += (value1 - value2) * (value1 - value2);
        }
        dist = (float)Math.sqrt(dist);
        return dist;
    }

    public void initColorTable() {
        int size = 100;
        if (this.colordistance) {
            this.colorattr_min = this.mindistance;
            this.colorattr_max = this.maxdistance;
        } else if (this.colormode) {
            if (this.colorattr.isNominal()) {
                size = this.colorattr.getNumberOfValues();
            }
            if (this.colorattr.isNumerical()) {
                this.colorattr_min = (float)this.colorattr.getMinimum();
                this.colorattr_max = (float)this.colorattr.getMaximum();
            }
        } else {
            return;
        }
        this.colortable = new Color[size];
        float red_start = this.startcolor.getRed();
        float green_start = this.startcolor.getGreen();
        float blue_start = this.startcolor.getBlue();
        float red_end = this.endcolor.getRed();
        float green_end = this.endcolor.getGreen();
        float blue_end = this.endcolor.getBlue();
        float d_red = (red_end - red_start) / ((float)size - 1.0f);
        float d_green = (green_end - green_start) / ((float)size - 1.0f);
        float d_blue = (blue_end - blue_start) / ((float)size - 1.0f);
        for (int i = 0; i < this.colortable.length; ++i) {
            this.colortable[i] = new Color((int)red_start, (int)green_start, (int)blue_start);
            red_start += d_red;
            green_start += d_green;
            blue_start += d_blue;
        }
        this.initcolortable = true;
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.width = this.dimension.width;
        this.height = this.dimension.height;
        this.deltawidth = (float)(this.width - 100) / (float)this.som.getNumberOfHorizontalNeurons();
        this.deltaheight = (float)(this.height - 100) / (float)this.som.getNumberOfVerticalNeurons();
        if (this.colordistance && !this.initcolortable) {
            this.initColorTable();
        }
        Font font = new Font("Monospaced", 0, 12);
        g.setFont(font);
        for (int h = 0; h < this.som.getNumberOfHorizontalNeurons(); ++h) {
            for (int v = 0; v < this.som.getNumberOfVerticalNeurons(); ++v) {
                this.drawCell(g, h, v);
            }
        }
        g.setColor(this.foreground);
        float x = 50.0f;
        float y = 50.0f;
        for (int h = 0; h <= this.som.getNumberOfHorizontalNeurons(); ++h) {
            g.drawLine(this.getX((int)x), this.getY((int)y), this.getX((int)x), this.getY((int)y + this.height - 100));
            x += this.deltawidth;
        }
        x = 50.0f;
        y = 50.0f;
        for (int v = 0; v <= this.som.getNumberOfVerticalNeurons(); ++v) {
            g.drawLine(this.getX((int)x), this.getY((int)y), this.getX((int)x + this.width - 100), this.getY((int)y));
            y += this.deltaheight;
        }
    }

    public void drawCell(Graphics g, int horiz, int vert) {
        int x = (int)(50.0f + this.deltawidth * (float)horiz);
        int y = (int)(50.0f + this.deltaheight * (float)vert);
        float value = 0.0f;
        if (this.colordistance) {
            value = this.cellvalues[horiz][vert];
            int index = (int)((value = (value - this.mindistance) / (this.maxdistance - this.mindistance)) * 99.0f);
            if (index < 0) {
                index = 0;
            }
            if (index > 99) {
                index = 99;
            }
            g.setColor(this.colortable[index]);
            g.fillRect(this.getX(x), this.getY(y), (int)this.deltawidth, (int)this.deltaheight);
        } else if (this.colormode) {
            if (this.colorattr.isNumerical()) {
                if (this.cellcount[horiz][vert] == 0) {
                    g.setColor(this.background);
                } else {
                    value = this.cellvalues[horiz][vert];
                    int index = (int)((value = (float)(((double)value - this.colorattr.getMinimum()) / (this.colorattr.getMaximum() - this.colorattr.getMinimum()))) * 99.0f);
                    if (index < 0) {
                        index = 0;
                    }
                    if (index > 99) {
                        index = 99;
                    }
                    g.setColor(this.colortable[index]);
                }
                g.fillRect(this.getX(x), this.getY(y), (int)this.deltawidth, (int)this.deltaheight);
            }
            if (this.colorattr.isNominal()) {
                if (this.cellcount[horiz][vert] == 0) {
                    g.setColor(this.background);
                    g.fillRect(this.getX(x), this.getY(y), (int)this.deltawidth, (int)this.deltaheight);
                } else {
                    int x1 = (int)(50.0f + this.deltawidth * (float)horiz);
                    int y1 = (int)(50.0f + this.deltaheight * (float)vert);
                    for (int c = 0; c < this.colortable.length; ++c) {
                        float dy = (float)this.cellnominals[horiz][vert][c] / (float)this.cellcount[horiz][vert] * this.deltaheight;
                        g.setColor(this.colortable[c]);
                        g.fillRect(this.getX(x1), this.getY(y1), (int)this.deltawidth, (int)dy);
                        y1 += (int)dy;
                    }
                }
            }
        }
        if (this.shownumbersamples) {
            g.setColor(this.foreground);
            g.drawString(Integer.toString(this.cellcount[horiz][vert]), this.getX(x), this.getY(y + 10));
        }
    }
}

