/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.jvito.plot.ColorPanel;
import edu.udo.cs.yale.example.Attribute;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JPanel;

public class PlotPanel
extends JPanel {
    protected String title = new String("");
    protected boolean drawtitle = false;
    protected Attribute colorattr;
    protected float[] colorvalues;
    protected float colorattr_min;
    protected float colorattr_max;
    protected boolean colorbyattribute = false;
    protected boolean initcolortable = false;
    protected Color[] colortable;
    protected Color foreground;
    protected Color background;
    protected Color startcolor;
    protected Color endcolor;
    protected Point origin = new Point(0, 0);
    protected Dimension dimension = null;

    public void setForegroundColor(Color color) {
        this.foreground = color;
    }

    public Color getForegroundColor() {
        return this.foreground;
    }

    public void setBackgroundColor(Color color) {
        this.background = color;
    }

    public Color getBackgroundColor() {
        return this.background;
    }

    public void setStartColor(Color color) {
        this.startcolor = color;
    }

    public Color getStartColor() {
        return this.startcolor;
    }

    public void setEndColor(Color color) {
        this.endcolor = color;
    }

    public Color getEndColor() {
        return this.endcolor;
    }

    public void colorByAttribute(Attribute attribute, float[] attrvalues) {
        if (attribute == null) {
            return;
        }
        this.colorbyattribute = true;
        this.colorattr = attribute;
        this.colorvalues = attrvalues;
    }

    public void colorByAttribute(Attribute attribute, float[] attrvalues, Color[] colortable) {
        if (attribute == null) {
            return;
        }
        this.colorbyattribute = true;
        this.colorattr = attribute;
        this.colorvalues = attrvalues;
        this.colortable = colortable;
    }

    public Attribute getColorAttribute() {
        return this.colorattr;
    }

    public void initColorTable() {
        if (!this.colorbyattribute) {
            return;
        }
        int size = 100;
        if (this.colorattr.isNominal()) {
            size = this.colorattr.getNumberOfValues();
        }
        if (this.colorattr.isNumerical()) {
            this.colorattr_min = (float)this.colorattr.getMinimum();
            this.colorattr_max = (float)this.colorattr.getMaximum();
        }
        if (this.startcolor == null) {
            this.startcolor = Color.red;
        }
        if (this.endcolor == null) {
            this.endcolor = Color.blue;
        }
        this.colortable = new Color[size];
        float red_start = this.startcolor.getRed();
        float green_start = this.startcolor.getGreen();
        float blue_start = this.startcolor.getBlue();
        float red_end = this.endcolor.getRed();
        float green_end = this.endcolor.getGreen();
        float blue_end = this.endcolor.getBlue();
        float d_red = (red_end - red_start) / ((float)size - 1.0f);
        float d_green = (green_end - green_start) / ((float)size - 1.0f);
        float d_blue = (blue_end - blue_start) / ((float)size - 1.0f);
        for (int i = 0; i < this.colortable.length; ++i) {
            this.colortable[i] = new Color((int)red_start, (int)green_start, (int)blue_start);
            red_start += d_red;
            green_start += d_green;
            blue_start += d_blue;
        }
        this.initcolortable = true;
    }

    public JPanel getColorPanel() {
        if (this.colorbyattribute) {
            return new ColorPanel(this.colorattr, this.colortable, this.foreground, this.background);
        }
        return new JPanel();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setDrawTitle(boolean drawtitle) {
        this.drawtitle = drawtitle;
    }

    public boolean getDrawTitle() {
        return this.drawtitle;
    }

    public void paint(Graphics g) {
        if (this.dimension == null) {
            this.setDimension(this.getSize());
        }
        if (this.dimension.width <= 100 || this.dimension.height <= 100) {
            return;
        }
        g.setColor(this.background);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        if (this.drawtitle) {
            g.setColor(this.foreground);
            Font font = new Font("SansSerif", 1, 30);
            g.setFont(font);
            FontMetrics fm = g.getFontMetrics();
            int slen = fm.stringWidth(this.title);
            g.drawString(this.title, this.getX((this.dimension.width - slen) / 2), this.getY(40));
        }
    }

    public void setOrigin(Point origin) {
        this.origin = origin;
    }

    public Point getOrigin() {
        return this.origin;
    }

    public int getX(int x) {
        return this.origin.x + x;
    }

    public int getY(int y) {
        return this.origin.y + y;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public Dimension getDimension() {
        return this.dimension;
    }
}

