/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.jvito.data.ExampleColoring;
import edu.udo.cs.jvito.plot.PlotPanel;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;

public class HistogramNumeric
extends PlotPanel
implements MouseListener {
    private Attribute attribute;
    private float[] values;
    private int[][] labelcounter;
    private int[] frequencies;
    private int min_freq;
    private int max_freq;
    private int width;
    private int height;
    private int pixelgesamt;
    private int pixelchart;
    private boolean manual = false;
    private boolean calculated = false;
    private int number_of_intervals = 5;
    private boolean mousepressed = false;
    private ExampleSet set;
    private ExampleColoring coloring;
    private boolean colorprediction = false;
    private float min;
    private float max;
    private boolean drawvalue = false;
    private float value;

    public HistogramNumeric(ExampleSet set, ExampleColoring coloring, Attribute attribute, float[] values) {
        this.set = set;
        this.coloring = coloring;
        this.attribute = attribute;
        this.values = values;
        this.calculateMinMax();
        this.addMouseListener(this);
        this.addMouseMotionListener(new MyMouseMotionListener());
    }

    public void setDrawLineForValue(float value) {
        this.drawvalue = true;
        this.value = value;
    }

    private void calculateMinMax() {
        this.min = Float.POSITIVE_INFINITY;
        this.max = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < this.values.length; ++i) {
            this.min = Math.min(this.min, this.values[i]);
            this.max = Math.max(this.max, this.values[i]);
        }
    }

    public void setValues(float[] values) {
        this.calculated = false;
        this.values = values;
        this.calculateMinMax();
    }

    public void setColorByPrediction(boolean color) {
        this.colorprediction = color;
    }

    public void colorByAttribute(Attribute attribute, float[] attrvalues) {
        if (!attribute.isNominal()) {
            this.orderValues();
            return;
        }
        if (this.attribute.getName().equals(attribute.getName())) {
            this.orderValues();
            return;
        }
        super.colorByAttribute(attribute, attrvalues);
        this.orderValues();
    }

    public void colorByAttribute(Attribute attribute, float[] attrvalues, Color[] colortable) {
        super.colorByAttribute(attribute, attrvalues, colortable);
        if (!attribute.isNominal()) {
            this.orderValues();
            return;
        }
        super.colorByAttribute(attribute, attrvalues, colortable);
        this.orderValues();
    }

    public void quickSort(float[] array, int links, int rechts) {
        int left = links;
        int right = rechts;
        float pivot = array[(links + rechts) / 2];
        while (true) {
            if (array[left] < pivot) {
                ++left;
                continue;
            }
            while (array[right] > pivot) {
                --right;
            }
            if (left <= right) {
                float temp = array[left];
                array[left] = array[right];
                array[right] = temp;
                if (this.colorbyattribute) {
                    temp = this.colorvalues[left];
                    this.colorvalues[left] = this.colorvalues[right];
                    this.colorvalues[right] = temp;
                }
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (links < right) {
            this.quickSort(array, links, right);
        }
        if (left < rechts) {
            this.quickSort(array, left, rechts);
        }
    }

    public void orderValues() {
        this.quickSort(this.values, 0, this.values.length - 1);
    }

    public void setIntervalsManually(boolean manual) {
        this.manual = manual;
    }

    public void setNumberOfIntervals(int number) {
        this.number_of_intervals = number;
    }

    public int calculateNumberOfIntervals() {
        if (this.calculated) {
            return this.number_of_intervals;
        }
        if (this.manual) {
            return this.number_of_intervals;
        }
        int w = this.width - 120;
        return (this.width - 120) / 10;
    }

    public int[] calculateFrequencies() {
        int[] freq = new int[this.number_of_intervals];
        for (int i = 0; i < freq.length; ++i) {
            freq[i] = 0;
        }
        float delta = (this.max - this.min) / (float)this.number_of_intervals;
        for (int index = 0; index < this.values.length; ++index) {
            float value = (this.values[index] - this.min) / delta;
            int count_index = (int)Math.floor(value);
            int n = count_index = Math.min(count_index, freq.length - 1);
            freq[n] = freq[n] + 1;
        }
        return freq;
    }

    private void calculateLabelCounter() {
        this.labelcounter = new int[this.number_of_intervals][this.colorattr.getNumberOfValues()];
        if (this.colorprediction) {
            this.labelcounter = new int[this.number_of_intervals][this.colorattr.getNumberOfValues() * this.colorattr.getNumberOfValues()];
        }
        for (int i = 0; i < this.number_of_intervals; ++i) {
            for (int j = 0; j < this.labelcounter[0].length; ++j) {
                this.labelcounter[i][j] = 0;
            }
        }
        float delta = (this.max - this.min) / (float)this.number_of_intervals;
        for (int index = 0; index < this.values.length; ++index) {
            float value = (this.values[index] - this.min) / delta;
            int count_index = (int)Math.floor(value);
            count_index = Math.min(count_index, this.number_of_intervals - 1);
            int[] nArray = this.labelcounter[count_index];
            int n = (int)this.colorvalues[index];
            nArray[n] = nArray[n] + 1;
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.width = this.dimension.width;
        this.height = this.dimension.height;
        g.setColor(this.foreground);
        g.drawLine(this.getX(50), this.getY(50), this.getX(50), this.getY(this.height - 50));
        g.drawLine(this.getX(50), this.getY(this.height - 50), this.getX(this.width - 50), this.getY(this.height - 50));
        g.drawLine(this.getX(50), this.getY(50), this.getX(47), this.getY(65));
        g.drawLine(this.getX(50), this.getY(50), this.getX(53), this.getY(65));
        g.drawLine(this.getX(this.width - 50), this.getY(this.height - 50), this.getX(this.width - 65), this.getY(this.height - 53));
        g.drawLine(this.getX(this.width - 50), this.getY(this.height - 50), this.getX(this.width - 65), this.getY(this.height - 47));
        g.drawLine(this.getX(this.width - 70), this.getY(this.height - 45), this.getX(this.width - 70), this.getY(this.height - 55));
        g.drawLine(this.getX(45), this.getY(70), this.getX(55), this.getY(70));
        if (this.drawvalue && this.value >= this.min && this.value <= this.max) {
            float xvalue = (this.value - this.min) / (this.max - this.min) * (float)(this.width - 120);
            g.drawLine(this.getX(50 + (int)xvalue), this.getY(50), this.getX(50 + (int)xvalue), this.getY(this.height - 50));
        }
        Font font = new Font("Monospaced", 0, 15);
        g.setFont(font);
        g.drawString(new Float(this.min).toString(), this.getX(50), this.getY(this.height - 33));
        g.drawString(new Float(this.max).toString(), this.getX(this.width - 70), this.getY(this.height - 33));
        font = new Font("SansSerif", 0, 30);
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        int slen = fm.stringWidth(this.attribute.getName());
        g.drawString(this.attribute.getName(), this.getX((this.width - slen) / 2), this.getY(this.height - 7));
        this.number_of_intervals = this.calculateNumberOfIntervals();
        int max_intervals = (this.width - 100) / 2;
        this.number_of_intervals = Math.min(this.number_of_intervals, max_intervals);
        this.frequencies = this.calculateFrequencies();
        this.min_freq = this.frequencies[0];
        this.max_freq = this.frequencies[0];
        for (int i = 1; i < this.frequencies.length; ++i) {
            if (this.frequencies[i] > this.max_freq) {
                this.max_freq = this.frequencies[i];
            }
            if (this.frequencies[i] >= this.min_freq) continue;
            this.min_freq = this.frequencies[i];
        }
        font = new Font("Monospaced", 0, 15);
        g.setFont(font);
        g.drawString(Integer.toString(this.max_freq), this.getX(10), this.getY(75));
        g.drawString("0", this.getX(10), this.getY(this.height - 45));
        this.pixelgesamt = this.width - 120;
        this.pixelchart = this.pixelgesamt / this.number_of_intervals;
        int pixelheight = this.height - 120;
        if (this.colorbyattribute) {
            this.calculateLabelCounter();
        }
        int rx = 50;
        for (int chart = 0; chart < this.frequencies.length; ++chart) {
            rx = 50 + chart * this.pixelchart;
            int chartheight = Math.round((float)pixelheight * ((float)this.frequencies[chart] / (float)this.max_freq));
            int ry = this.height - 50 - chartheight;
            if (this.colorbyattribute) {
                int labelheight = 0;
                int labely = ry;
                int numbervalues = this.colorattr.getNumberOfValues();
                if (this.colorprediction) {
                    numbervalues = this.colortable.length;
                }
                for (int l = 0; l < numbervalues; ++l) {
                    if (this.set.getLabel() != null && this.set.getLabel().getName().equals(this.colorattr.getName())) {
                        g.setColor(this.coloring.getColorOfLabelValue(this.colorattr, l));
                    } else if (this.set.getPredictedLabel() != null && this.set.getPredictedLabel().getName().equals(this.colorattr.getName())) {
                        if (this.colorattr.isNominal()) {
                            g.setColor(this.colortable[l]);
                        } else {
                            g.setColor(this.coloring.getColorOfPredLabelValue(this.colorattr, l));
                        }
                    } else {
                        g.setColor(this.colortable[l]);
                    }
                    labelheight = Math.round((float)pixelheight * ((float)this.labelcounter[chart][l] / (float)this.max_freq));
                    g.fillRect(this.getX(rx), this.getY(labely), this.pixelchart, labelheight);
                    labely += labelheight;
                }
            }
            g.setColor(this.foreground);
            g.drawRect(this.getX(rx), this.getY(ry), this.pixelchart, chartheight);
        }
        this.paintMouseInfo(null);
    }

    public void paintMouseInfo(MouseEvent event) {
        if (this.mousepressed && event != null) {
            int x = event.getX();
            int y = event.getY();
            Graphics g = this.getGraphics();
            g.setColor(this.background);
            g.fillRect(0, 0, this.width, 15);
            g.setColor(this.foreground);
            Font font = new Font("Monospaced", 0, 15);
            g.setFont(font);
            g.drawString(this.attribute.getName() + ": " + this.getValue(this.getOrigin().x * -1 + x) + "    Frequency: " + this.getFrequency(this.getOrigin().x * -1 + x), 5, 11);
        }
    }

    public float getValue(int x) {
        if (x < 50) {
            return this.values[0];
        }
        if (x > this.width - 70) {
            return this.values[this.values.length - 1];
        }
        float breite = this.values[this.values.length - 1] - this.values[0];
        float value = breite / (float)this.pixelgesamt * (float)(x -= 50) + this.values[0];
        return value;
    }

    public String getBounds(int x) {
        String bounds = "";
        x -= 50;
        float delta = (this.values[this.values.length - 1] - this.values[0]) / (float)this.number_of_intervals;
        int r = 0;
        int l = this.pixelchart;
        for (int i = 0; i < this.number_of_intervals; ++i) {
            if (r < x && x <= l) {
                float rechts = this.getValue(r + 50);
                float links = this.getValue(l + 50);
                return new String(Float.toString(rechts) + " - " + Float.toString(links));
            }
            r = l;
            l += this.pixelchart;
        }
        return bounds;
    }

    public int getFrequency(int x) {
        if (x < 50) {
            return this.frequencies[0];
        }
        if (x > this.width - 70) {
            return this.frequencies[this.number_of_intervals - 1];
        }
        int freq = 0;
        x -= 50;
        float delta = (this.values[this.values.length - 1] - this.values[0]) / (float)this.number_of_intervals;
        int r = 0;
        int l = this.pixelchart;
        for (int i = 0; i < this.number_of_intervals; ++i) {
            if (r < x && x <= l) {
                return this.frequencies[freq];
            }
            r = l;
            l += this.pixelchart;
            ++freq;
        }
        freq = Math.min(this.frequencies.length - 1, freq);
        return this.frequencies[freq];
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        if (event.getButton() == 2) {
            this.mousepressed = true;
            this.paintMouseInfo(event);
        }
    }

    public void mouseReleased(MouseEvent event) {
        this.mousepressed = false;
        this.repaint();
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter {
        private MyMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent event) {
            HistogramNumeric.this.paintMouseInfo(event);
        }
    }
}

