/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.parameter.ParameterTypeColor;
import edu.udo.cs.jvito.parameter.ParameterTypeDynamicCategory;
import edu.udo.cs.jvito.plot.ColorPanel;
import edu.udo.cs.jvito.plot.HistogramNominal;
import edu.udo.cs.jvito.plot.HistogramNumeric;
import edu.udo.cs.jvito.plot.MovingListener;
import edu.udo.cs.jvito.plot.Plot;
import edu.udo.cs.jvito.plot.PlotPanel;
import edu.udo.cs.jvito.plot.RectangularGridLayout;
import edu.udo.cs.jvito.plot.ZoomingListener;
import edu.udo.cs.jvito.util.Logger;
import edu.udo.cs.jvito.util.Utils;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.border.LineBorder;

public class HistogramMatrix
extends Plot
implements AdjustmentListener,
MouseListener,
MouseMotionListener {
    protected int CurX = 0;
    protected int CurY = 0;
    private int oldX;
    private int oldY;
    protected int NumVisX;
    protected int NumVisY;
    protected int LABEL_WIDTH = 30;
    protected int LABEL_HEIGHT = 20;
    protected static final int MIN_VIS_WIDTH = 50;
    protected static final int MIN_VIS_HEIGHT = 50;
    protected int DEFAULT_VIS_WIDTH = 150;
    protected int DEFAULT_VIS_HEIGHT = 150;
    protected Panel DisplayPanel;
    protected JPanel ScrollPanel;
    protected ScrollPane SCPane;
    protected JViewport HorizLabels;
    protected JViewport VertLabels;
    protected JPanel[] HorizLabel;
    protected JPanel[] VertLabel;
    protected JComponent[] HorizDrag;
    protected JComponent[] VertDrag;
    protected JPanel HorizPanel;
    protected JPanel VertPanel;
    private JPanel plotpanel;
    private JPanel display;
    private JPanel widgets;
    private JPanel mainpane;
    private Attribute[] attributes = new Attribute[0];
    private Attribute label;
    private Attribute prediction;
    private Color[] colortable;
    private int number_atts = 0;
    private float[][] samples;
    private float[] labelvalues;
    private float[] predvalues;
    private JPanel[][] displaypanel;
    public static final String[] COLUMN_NAMES = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private Color start_color;
    private Color end_color;
    private Attribute color_att;
    private static final String[] attribute_mode = new String[]{"all attributes", "correlation", "attribute_weights", "selection"};
    private int[] attribute_index;

    public Component getSaveableComponent() {
        return this.DisplayPanel;
    }

    public JPanel getPlotPanel() {
        if (!this.isCompiled()) {
            return null;
        }
        return this.mainpane;
    }

    private void initComponents() {
        this.plotpanel = new JPanel();
        this.plotpanel.setLayout(new BorderLayout(10, 10));
        JPanel settings = new JPanel();
        settings.setLayout(new BorderLayout());
        if (!this.source.isCompiled()) {
            return;
        }
        ExampleSet set = this.source.getExampleSet();
        this.init();
    }

    private void init() {
        JViewport vl;
        JViewport hl;
        this.mainpane = new JPanel();
        this.mainpane.setLayout(new BorderLayout(5, 5));
        this.plotpanel = new JPanel();
        this.plotpanel.setBackground(Color.white);
        this.plotpanel.setLayout(new BoxLayout(this.plotpanel, 1));
        this.mainpane.add((Component)this.plotpanel, "Center");
        JPanel horizShell = new JPanel();
        horizShell.setBackground(Color.white);
        horizShell.setLayout(new BoxLayout(horizShell, 0));
        horizShell.add(Box.createRigidArea(new Dimension(this.LABEL_WIDTH + 6, 0)));
        this.plotpanel.add(horizShell);
        this.HorizPanel = new JPanel(){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                return new Dimension(d.width, HistogramMatrix.this.LABEL_HEIGHT);
            }
        };
        this.HorizPanel.setBackground(Color.white);
        this.constructHorizontalLabels();
        this.HorizLabels = hl = new JViewport(){

            public Dimension getMinimumSize() {
                return new Dimension(0, HistogramMatrix.this.LABEL_HEIGHT);
            }

            public Dimension getPreferredSize() {
                return new Dimension(0, HistogramMatrix.this.LABEL_HEIGHT);
            }

            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, HistogramMatrix.this.LABEL_HEIGHT);
            }
        };
        this.HorizLabels.setView(this.HorizPanel);
        horizShell.add(this.HorizLabels);
        horizShell.add(new JComponent(){

            public Dimension getMinimumSize() {
                return new Dimension(6 + HistogramMatrix.this.SCPane.getVScrollbarWidth(), 0);
            }

            public Dimension getPreferredSize() {
                return new Dimension(6 + HistogramMatrix.this.SCPane.getVScrollbarWidth(), 0);
            }

            public Dimension getMaximumSize() {
                return new Dimension(6 + HistogramMatrix.this.SCPane.getVScrollbarWidth(), 0);
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(Color.white);
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        this.plotpanel.add(mainPanel);
        this.plotpanel.add(Box.createRigidArea(new Dimension(0, 6)));
        JPanel vertShell = new JPanel();
        vertShell.setBackground(Color.white);
        vertShell.setLayout(new BoxLayout(vertShell, 1));
        mainPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        mainPanel.add(vertShell);
        this.VertPanel = new JPanel(){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                return new Dimension(HistogramMatrix.this.LABEL_WIDTH, d.height);
            }
        };
        this.VertPanel.setBackground(Color.white);
        this.constructVerticalLabels();
        this.VertLabels = vl = new JViewport(){

            public Dimension getMinimumSize() {
                return new Dimension(HistogramMatrix.this.LABEL_WIDTH, 0);
            }

            public Dimension getPreferredSize() {
                return new Dimension(HistogramMatrix.this.LABEL_WIDTH, 0);
            }

            public Dimension getMaximumSize() {
                return new Dimension(HistogramMatrix.this.LABEL_WIDTH, Integer.MAX_VALUE);
            }
        };
        this.VertLabels.setView(this.VertPanel);
        vertShell.add(this.VertLabels);
        vertShell.add(new JComponent(){

            public Dimension getMinimumSize() {
                return new Dimension(0, HistogramMatrix.this.SCPane.getHScrollbarHeight());
            }

            public Dimension getPreferredSize() {
                return new Dimension(0, HistogramMatrix.this.SCPane.getHScrollbarHeight());
            }

            public Dimension getMaximumSize() {
                return new Dimension(0, HistogramMatrix.this.SCPane.getHScrollbarHeight());
            }
        });
        this.ScrollPanel = new JPanel();
        this.ScrollPanel.setBackground(Color.white);
        this.ScrollPanel.setLayout(new BoxLayout(this.ScrollPanel, 0));
        mainPanel.add(this.ScrollPanel);
        mainPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        this.SCPane = new ScrollPane(1){

            public Dimension getPreferredSize() {
                return new Dimension(0, 0);
            }
        };
        Adjustable hadj = this.SCPane.getHAdjustable();
        Adjustable vadj = this.SCPane.getVAdjustable();
        hadj.setBlockIncrement(50);
        hadj.setUnitIncrement(12);
        hadj.addAdjustmentListener(this);
        vadj.setBlockIncrement(50);
        vadj.setUnitIncrement(12);
        vadj.addAdjustmentListener(this);
        this.ScrollPanel.add(this.SCPane);
        this.DisplayPanel = new Panel();
        this.DisplayPanel.setBackground(Color.darkGray);
        this.SCPane.add(this.DisplayPanel);
        this.constructMatrix();
        JPanel settings = new JPanel();
        settings.setLayout(new BorderLayout(5, 5));
        this.mainpane.add((Component)settings, "East");
        ExampleSet set = this.source.getExampleSet();
        if (this.getParameterAsInt("color_attribute") != 0) {
            this.initColorTable(this.start_color, this.end_color);
            ColorPanel colorpanel = new ColorPanel(this.color_att, this.colortable, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
            if (this.getParameterAsInt("color_attribute") > set.getNumberOfAttributes()) {
                if (set.getLabel() != null && set.getLabel().isNominal() && this.getParameterAsInt("color_attribute") == set.getNumberOfAttributes() + 1) {
                    Color[] colors = new Color[set.getLabel().getValues().size()];
                    Collection values = set.getLabel().getValues();
                    Object[] valuesstr = values.toArray();
                    for (int i = 0; i < valuesstr.length; ++i) {
                        colors[i] = this.source.getExampleColoring().getColorOfLabelValue(set.getLabel(), (String)valuesstr[i]);
                    }
                    colorpanel = new ColorPanel(set.getLabel(), colors, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
                } else if (set.getPredictedLabel() != null && set.getPredictedLabel().isNominal()) {
                    Collection values = set.getPredictedLabel().getValues();
                    Object[] valuesstr = values.toArray();
                    Color[] colors = new Color[set.getPredictedLabel().getValues().size() * set.getPredictedLabel().getValues().size()];
                    String[] valuestring = new String[valuesstr.length * valuesstr.length];
                    for (int i = 0; i < valuesstr.length; ++i) {
                        for (int j = 0; j < valuesstr.length; ++j) {
                            valuestring[i * valuesstr.length + j] = new String((String)valuesstr[i] + " - " + (String)valuesstr[j]);
                            colors[i * valuesstr.length + j] = this.source.getExampleColoring().getColorOfLabelvsPred(set.getLabel(), set.getPredictedLabel(), (String)valuesstr[i], (String)valuesstr[j]);
                        }
                    }
                    colorpanel = new ColorPanel(set.getPredictedLabel(), valuestring, colors, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
                }
            }
            colorpanel.setPreferredSize(new Dimension(125, colorpanel.getHeight()));
            settings.add(colorpanel);
        }
    }

    public void initColorTable(Color startcolor, Color endcolor) {
        int size = 100;
        if (this.color_att.isNominal()) {
            size = this.color_att.getNumberOfValues();
        }
        this.colortable = new Color[size];
        float red_start = startcolor.getRed();
        float green_start = startcolor.getGreen();
        float blue_start = startcolor.getBlue();
        float red_end = endcolor.getRed();
        float green_end = endcolor.getGreen();
        float blue_end = endcolor.getBlue();
        float d_red = (red_end - red_start) / ((float)size - 1.0f);
        float d_green = (green_end - green_start) / ((float)size - 1.0f);
        float d_blue = (blue_end - blue_start) / ((float)size - 1.0f);
        for (int i = 0; i < this.colortable.length; ++i) {
            this.colortable[i] = new Color((int)red_start, (int)green_start, (int)blue_start);
            red_start += d_red;
            green_start += d_green;
            blue_start += d_blue;
        }
    }

    private void initDisplay() {
        this.display = new JPanel();
        this.display.setLayout(new BorderLayout());
        if (!this.isCompiled()) {
            return;
        }
    }

    protected void refreshCells() {
        Thread thread = new Thread(){

            public void run() {
                for (int i = 0; i < HistogramMatrix.this.NumVisX; ++i) {
                    for (int j = 0; j < HistogramMatrix.this.NumVisY; ++j) {
                        HistogramMatrix.this.displaypanel[i][j].repaint();
                    }
                }
            }
        };
        thread.start();
    }

    private void synchLabelAndCellSizes() {
        for (int j = 0; j < this.NumVisY; ++j) {
            int h = this.VertLabel[j].getSize().height;
            for (int i = 0; i < this.NumVisX; ++i) {
                int w = this.HorizLabel[i].getSize().width;
                this.displaypanel[i][j].setPreferredSize(new Dimension(w, h));
            }
        }
        this.HorizLabels.validate();
        this.VertLabels.validate();
        this.DisplayPanel.doLayout();
        this.SCPane.validate();
        this.refreshCells();
    }

    private void constructMatrix() {
        this.DisplayPanel.setLayout(new RectangularGridLayout(this.NumVisX, this.NumVisY, 5, 5));
        for (int j = 0; j < this.NumVisY; ++j) {
            int ph = this.VertLabel[j].getPreferredSize().height;
            for (int i = 0; i < this.NumVisX; ++i) {
                int pw = this.HorizLabel[i].getPreferredSize().width;
                this.displaypanel[i][j].setPreferredSize(new Dimension(pw, ph));
                this.DisplayPanel.add(this.displaypanel[i][j]);
            }
        }
        this.selectCell(0, 0);
    }

    private void constructHorizontalLabels() {
        this.constructHorizontalLabels(null, null);
    }

    private void constructHorizontalLabels(String[] l, int[] widths) {
        int i;
        if (l == null) {
            l = new String[this.NumVisX];
            for (i = 0; i < this.NumVisX; ++i) {
                l[i] = COLUMN_NAMES[i];
            }
        }
        if (widths == null) {
            widths = new int[this.NumVisX];
            for (i = 0; i < this.NumVisX; ++i) {
                widths[i] = this.DEFAULT_VIS_WIDTH;
            }
        }
        this.HorizPanel.setLayout(new RectangularGridLayout(2 * this.NumVisX, 1, 0, 0));
        this.HorizLabel = new JPanel[this.NumVisX];
        this.HorizDrag = new JComponent[this.NumVisX];
        for (i = 0; i < this.NumVisX; ++i) {
            this.HorizLabel[i] = new JPanel();
            this.HorizLabel[i].setBorder(new LineBorder(Color.black, 1));
            this.HorizLabel[i].setLayout(new BorderLayout());
            this.HorizLabel[i].setPreferredSize(new Dimension(widths[i], this.LABEL_HEIGHT));
            this.HorizLabel[i].add("Center", new JLabel(l[i], 0));
            this.HorizPanel.add(this.HorizLabel[i]);
            this.HorizDrag[i] = new JComponent(){

                public void paint(Graphics g) {
                    Dimension d = this.getSize();
                    g.setColor(Color.black);
                    g.drawRect(0, 0, d.width - 1, d.height - 1);
                    g.setColor(Color.yellow);
                    g.fillRect(1, 1, d.width - 2, d.height - 2);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(5, HistogramMatrix.this.LABEL_HEIGHT);
                }
            };
            this.HorizDrag[i].setPreferredSize(new Dimension(5, 0));
            this.HorizDrag[i].addMouseListener(this);
            this.HorizDrag[i].addMouseMotionListener(this);
            this.HorizPanel.add(this.HorizDrag[i]);
        }
    }

    private void constructVerticalLabels() {
        this.constructVerticalLabels(null, null);
    }

    private void constructVerticalLabels(String[] l, int[] heights) {
        int i;
        if (l == null) {
            l = new String[this.NumVisY];
            for (i = 0; i < this.NumVisY; ++i) {
                l[i] = Integer.toString(i + 1);
            }
        }
        if (heights == null) {
            heights = new int[this.NumVisY];
            for (i = 0; i < this.NumVisY; ++i) {
                heights[i] = this.DEFAULT_VIS_HEIGHT;
            }
        }
        this.VertPanel.setLayout(new RectangularGridLayout(1, 2 * this.NumVisY, 0, 0));
        this.VertLabel = new JPanel[this.NumVisY];
        this.VertDrag = new JComponent[this.NumVisY];
        for (i = 0; i < this.NumVisY; ++i) {
            this.VertLabel[i] = new JPanel();
            this.VertLabel[i].setBorder(new LineBorder(Color.black, 1));
            this.VertLabel[i].setLayout(new BorderLayout());
            this.VertLabel[i].setPreferredSize(new Dimension(this.LABEL_WIDTH, heights[i]));
            this.VertLabel[i].add("Center", new JLabel(l[i], 0));
            this.VertPanel.add(this.VertLabel[i]);
            this.VertDrag[i] = new JComponent(){

                public void paint(Graphics g) {
                    Dimension d = this.getSize();
                    g.setColor(Color.black);
                    g.drawRect(0, 0, d.width - 1, d.height - 1);
                    g.setColor(Color.yellow);
                    g.fillRect(1, 1, d.width - 2, d.height - 2);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(HistogramMatrix.this.LABEL_WIDTH, 5);
                }
            };
            this.VertDrag[i].setBackground(Color.white);
            this.VertDrag[i].setPreferredSize(new Dimension(0, 5));
            this.VertDrag[i].addMouseListener(this);
            this.VertDrag[i].addMouseMotionListener(this);
            this.VertPanel.add(this.VertDrag[i]);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        Adjustable a = e.getAdjustable();
        int value = a.getValue();
        if (a.getOrientation() == 0) {
            this.HorizLabels.setViewPosition(new Point(value, 0));
        } else {
            this.VertLabels.setViewPosition(new Point(0, value));
        }
    }

    public void mousePressed(MouseEvent e) {
        Component c = e.getComponent();
        for (int j = 0; j < this.NumVisY; ++j) {
            for (int i = 0; i < this.NumVisX; ++i) {
                if (c != this.displaypanel[i][j]) continue;
                this.selectCell(i, j);
                return;
            }
        }
        this.oldX = e.getX();
        this.oldY = e.getY();
    }

    public void mouseReleased(MouseEvent e) {
        int j;
        int x = e.getX();
        int y = e.getY();
        Component c = e.getComponent();
        boolean change = false;
        for (j = 0; j < this.NumVisX; ++j) {
            if (c != this.HorizDrag[j]) continue;
            change = true;
            break;
        }
        for (j = 0; j < this.NumVisY; ++j) {
            if (c != this.VertDrag[j]) continue;
            change = true;
            break;
        }
        if (change) {
            this.synchLabelAndCellSizes();
        }
    }

    public void mouseDragged(MouseEvent e) {
        int j;
        Component c = e.getComponent();
        int x = e.getX();
        int y = e.getY();
        for (j = 0; j < this.NumVisX; ++j) {
            if (c != this.HorizDrag[j]) continue;
            Dimension s = this.HorizLabel[j].getSize();
            int oldW = s.width;
            s.width += x - this.oldX;
            if (s.width < 50) {
                s.width = 50;
            }
            this.HorizLabel[j].setSize(s);
            this.HorizLabel[j].setPreferredSize(s);
            this.HorizLabels.validate();
            return;
        }
        for (j = 0; j < this.NumVisY; ++j) {
            if (c != this.VertDrag[j]) continue;
            Dimension s = this.VertLabel[j].getSize();
            int oldH = s.height;
            s.height += y - this.oldY;
            if (s.height < 50) {
                s.height = 50;
            }
            this.VertLabel[j].setSize(s);
            this.VertLabel[j].setPreferredSize(s);
            this.VertLabels.validate();
            return;
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void selectCell(int x, int y) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x >= this.NumVisX) {
            x = this.NumVisX - 1;
        }
        if (y >= this.NumVisY) {
            y = this.NumVisY - 1;
        }
        for (int j = 0; j < this.NumVisY; ++j) {
            for (int i = 0; i < this.NumVisX; ++i) {
                boolean selected = x == i && y == j;
            }
        }
        this.CurX = x;
        this.CurY = y;
    }

    private void createDisplayPanel() {
        ExampleSet set = this.source.getExampleSet();
        String color_attribute = ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).getValues()[this.getParameterAsInt("color_attribute")];
        this.start_color = Color.red;
        this.end_color = Color.blue;
        this.color_att = set.getAttribute(0);
        if (!color_attribute.equals("<None>")) {
            if (set.getLabel() != null && set.getLabel().getName().equals(color_attribute)) {
                this.start_color = this.source.getExampleColoring().getStartColorOfLabel(set.getLabel());
                this.end_color = this.source.getExampleColoring().getEndColorOfLabel(set.getLabel());
                this.color_att = set.getLabel();
            } else if (set.getPredictedLabel() != null && set.getPredictedLabel().getName().equals(color_attribute)) {
                this.start_color = this.source.getExampleColoring().getStartColorOfPredLabel(set.getPredictedLabel());
                this.end_color = this.source.getExampleColoring().getEndColorOfPredLabel(set.getPredictedLabel());
                this.color_att = set.getPredictedLabel();
            } else {
                this.color_att = set.getAttribute(color_attribute);
                this.start_color = this.source.getExampleColoring().getStartColorOfAttribute(set.getAttribute(color_attribute));
                this.end_color = this.source.getExampleColoring().getEndColorOfAttribute(set.getAttribute(color_attribute));
            }
        }
        this.displaypanel = new JPanel[this.NumVisX][this.NumVisY];
        int attr = 1;
        for (int i = 0; i < this.NumVisY; ++i) {
            for (int j = 0; j < this.NumVisX; ++j) {
                if (attr <= this.number_atts) {
                    this.displaypanel[j][i] = this.createDisplayPanel(this.attributes[this.attribute_index[attr - 1]], this.samples[this.attribute_index[attr - 1]]);
                    ++attr;
                    continue;
                }
                System.out.println("nur JPanel");
                this.displaypanel[j][i] = new JPanel();
            }
        }
    }

    private JPanel createDisplayPanel(Attribute attribute, float[] attr_values) {
        ZoomingListener zoominlistener;
        MovingListener movinglistener;
        int i;
        int j;
        Color[] colors;
        Object[] valuesstr;
        Collection values;
        float[] cvalues;
        PlotPanel plotpanel = null;
        float[] att_values = new float[attr_values.length];
        System.arraycopy(attr_values, 0, att_values, 0, attr_values.length);
        ExampleSet set = this.source.getExampleSet();
        String color_attribute = ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).getValues()[this.getParameterAsInt("color_attribute")];
        if (attribute.isNumerical()) {
            plotpanel = new HistogramNumeric(this.source.getExampleSet(), this.source.getExampleColoring(), attribute, att_values);
            if (color_attribute.equals("<None>")) {
                ((HistogramNumeric)plotpanel).orderValues();
            } else if (set.getLabel() != null && color_attribute.equals(set.getLabel().getName())) {
                cvalues = new float[this.labelvalues.length];
                System.arraycopy(this.labelvalues, 0, cvalues, 0, this.labelvalues.length);
                plotpanel.colorByAttribute(set.getLabel(), cvalues);
                plotpanel.setStartColor(this.start_color);
                plotpanel.setEndColor(this.end_color);
                plotpanel.initColorTable();
            } else if (set.getPredictedLabel() != null && color_attribute.equals(set.getPredictedLabel().getName())) {
                values = set.getPredictedLabel().getValues();
                valuesstr = values.toArray();
                colors = new Color[set.getPredictedLabel().getValues().size() * set.getPredictedLabel().getValues().size()];
                for (int i2 = 0; i2 < valuesstr.length; ++i2) {
                    for (j = 0; j < valuesstr.length; ++j) {
                        colors[i2 * valuesstr.length + j] = this.source.getExampleColoring().getColorOfLabelvsPred(set.getLabel(), set.getPredictedLabel(), (String)valuesstr[i2], (String)valuesstr[j]);
                    }
                }
                float[] pvalues = new float[set.getSize()];
                for (i = 0; i < this.predvalues.length; ++i) {
                    pvalues[i] = this.labelvalues[i] * (float)valuesstr.length + this.predvalues[i];
                }
                ((HistogramNumeric)plotpanel).setColorByPrediction(true);
                plotpanel.colorByAttribute(this.source.getExampleSet().getPredictedLabel(), pvalues, colors);
                plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfPredLabel(this.source.getExampleSet().getPredictedLabel()));
                plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfPredLabel(this.source.getExampleSet().getPredictedLabel()));
            } else if (!color_attribute.equals("")) {
                cvalues = new float[this.samples[0].length];
                System.arraycopy(this.samples[this.getParameterAsInt("color_attribute") - 1], 0, cvalues, 0, this.samples[0].length);
                plotpanel.colorByAttribute(set.getAttribute(color_attribute), cvalues);
                plotpanel.setStartColor(this.start_color);
                plotpanel.setEndColor(this.end_color);
                plotpanel.initColorTable();
            }
            plotpanel.setBackgroundColor(this.getParameterAsColor("background"));
            plotpanel.setForegroundColor(this.getParameterAsColor("foreground"));
            ((HistogramNumeric)plotpanel).setIntervalsManually(this.getParameterAsBoolean("interval_manual"));
            ((HistogramNumeric)plotpanel).setNumberOfIntervals(this.getParameterAsInt("intervals"));
            movinglistener = new MovingListener(plotpanel);
            zoominlistener = new ZoomingListener(plotpanel);
            plotpanel.addMouseListener(movinglistener);
            plotpanel.addMouseMotionListener(movinglistener);
            plotpanel.addMouseListener(zoominlistener);
            plotpanel.addMouseMotionListener(zoominlistener);
        }
        if (attribute.isNominal()) {
            plotpanel = new HistogramNominal(this.source.getExampleSet(), this.source.getExampleColoring(), attribute, att_values);
            if (color_attribute.equals("<None>")) {
                ((HistogramNominal)plotpanel).orderValues();
            } else if (set.getLabel() != null && color_attribute.equals(set.getLabel().getName())) {
                cvalues = new float[this.labelvalues.length];
                System.arraycopy(this.labelvalues, 0, cvalues, 0, this.labelvalues.length);
                plotpanel.colorByAttribute(set.getLabel(), cvalues);
                plotpanel.setStartColor(this.start_color);
                plotpanel.setEndColor(this.end_color);
                plotpanel.initColorTable();
            } else if (set.getPredictedLabel() != null && color_attribute.equals(set.getPredictedLabel().getName())) {
                values = set.getPredictedLabel().getValues();
                valuesstr = values.toArray();
                colors = new Color[set.getPredictedLabel().getValues().size() * set.getPredictedLabel().getValues().size()];
                for (int i3 = 0; i3 < valuesstr.length; ++i3) {
                    for (j = 0; j < valuesstr.length; ++j) {
                        colors[i3 * valuesstr.length + j] = this.source.getExampleColoring().getColorOfLabelvsPred(set.getLabel(), set.getPredictedLabel(), (String)valuesstr[i3], (String)valuesstr[j]);
                    }
                }
                float[] pvalues = new float[set.getSize()];
                for (i = 0; i < this.predvalues.length; ++i) {
                    pvalues[i] = this.labelvalues[i] * (float)valuesstr.length + this.predvalues[i];
                }
                ((HistogramNominal)plotpanel).setColorByPrediction(true);
                plotpanel.colorByAttribute(this.source.getExampleSet().getPredictedLabel(), pvalues, colors);
                plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfPredLabel(this.source.getExampleSet().getPredictedLabel()));
                plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfPredLabel(this.source.getExampleSet().getPredictedLabel()));
            } else if (!color_attribute.equals("")) {
                cvalues = new float[this.samples[0].length];
                System.arraycopy(this.samples[this.getParameterAsInt("color_attribute") - 1], 0, cvalues, 0, this.samples[0].length);
                plotpanel.colorByAttribute(set.getAttribute(color_attribute), cvalues);
                plotpanel.setStartColor(this.start_color);
                plotpanel.setEndColor(this.end_color);
                plotpanel.initColorTable();
            }
            plotpanel.setBackgroundColor(this.getParameterAsColor("background"));
            plotpanel.setForegroundColor(this.getParameterAsColor("foreground"));
            movinglistener = new MovingListener(plotpanel);
            zoominlistener = new ZoomingListener(plotpanel);
            plotpanel.addMouseListener(movinglistener);
            plotpanel.addMouseMotionListener(movinglistener);
            plotpanel.addMouseListener(zoominlistener);
            plotpanel.addMouseMotionListener(zoominlistener);
        }
        if (plotpanel == null) {
            return new JPanel();
        }
        return plotpanel;
    }

    public List getParameterTypes() {
        LinkedList<ParameterTypeColor> types = new LinkedList<ParameterTypeColor>();
        ParameterTypeSingle type = new ParameterTypeColor("background", "The background-color.", Color.WHITE);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeColor("foreground", "The foreground-color.", Color.DARK_GRAY);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeInt("plot_height", "The height of each 2D-Scatterplot.", 50, 1000, 150);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeInt("plot_width", "The width of each 2D-Scatterplot.", 50, 1000, 150);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeInt("label_height", "Hotizontal cell label's height.", 20, 100, 20);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeInt("label_width", "Vertical cell label's width.", 25, 100, 30);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeBoolean("interval_manual", "Calculate the histogram with the specified number of imtervals, else calculate number of intervals.", false);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeInt("intervals", "Number of intervals.", 1, 1000, 5);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeDynamicCategory("color_attribute", "The histogram is colored with this attribute.", this.getColorAttributes(), 0);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeStringCategory("attribute_mode", "Select the mode to display the attributes.", attribute_mode, attribute_mode[0]);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeInt("number_attributes", "This number of the first correlated Attributes with the function values are displayed.", -1, Integer.MAX_VALUE, -1);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeFile("attribute_weights_file", "The file-location of the weights.", true);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeString("attributes", "These attributes are displayed(comma-separated attribute-names).", "");
        types.add((ParameterTypeColor)type);
        return types;
    }

    public void compile() throws CompilerException {
        int i;
        String props;
        this.iscompiling = true;
        ExampleSet set = this.source.getExampleSet();
        int number_of_samples = set.getSize();
        this.number_atts = set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            ++this.number_atts;
        }
        if (set.getPredictedLabel() != null) {
            ++this.number_atts;
        }
        this.attributes = new Attribute[this.number_atts];
        this.label = set.getLabel();
        this.prediction = set.getPredictedLabel();
        for (int att = 0; att < set.getNumberOfAttributes(); ++att) {
            this.attributes[att] = set.getAttribute(att);
        }
        int index = set.getNumberOfAttributes();
        if (this.label != null) {
            this.attributes[index] = this.label;
            ++index;
        }
        if (this.prediction != null) {
            this.attributes[index] = this.prediction;
        }
        this.samples = new float[this.number_atts][number_of_samples];
        this.labelvalues = new float[number_of_samples];
        this.predvalues = new float[number_of_samples];
        boolean haslabel = set.getLabel() != null;
        boolean haspredlabel = set.getPredictedLabel() != null;
        ExampleReader reader = set.getExampleReader();
        for (int sample = 0; sample < number_of_samples; ++sample) {
            Example example = reader.next();
            for (int d = 0; d < set.getNumberOfAttributes(); ++d) {
                this.samples[d][sample] = (float)example.getValue(d);
            }
            if (haslabel) {
                this.labelvalues[sample] = (float)example.getLabel();
                this.samples[set.getNumberOfAttributes()][sample] = (float)example.getLabel();
            }
            if (!haslabel && haspredlabel) {
                this.predvalues[sample] = (float)example.getPredictedLabel();
                this.samples[set.getNumberOfAttributes()][sample] = (float)example.getPredictedLabel();
            }
            if (!haslabel || !haspredlabel) continue;
            this.predvalues[sample] = (float)example.getPredictedLabel();
            this.samples[set.getNumberOfAttributes() + 1][sample] = (float)example.getPredictedLabel();
        }
        this.attribute_index = new int[this.number_atts];
        for (int i2 = 0; i2 < this.attribute_index.length; ++i2) {
            this.attribute_index[i2] = i2;
        }
        int number_attribute = this.getParameterAsInt("number_attributes");
        if (number_attribute == 0) {
            number_attribute = -1;
        }
        if (number_attribute == -1) {
            number_attribute = this.number_atts;
        }
        if (this.getParameterAsString("attribute_mode").equals(attribute_mode[0])) {
            this.number_atts = number_attribute;
        }
        if (this.getParameterAsString("attribute_mode").equals(attribute_mode[1])) {
            int i3;
            double[] mean = new double[set.getNumberOfAttributes() + 1];
            double[] st_deviation = new double[set.getNumberOfAttributes() + 1];
            double[] covariance = new double[set.getNumberOfAttributes()];
            for (i3 = 0; i3 < set.getNumberOfAttributes(); ++i3) {
                mean[i3] = this.attributes[i3].getAverage();
            }
            mean[mean.length - 1] = this.attributes[this.attributes.length - 1].getAverage();
            for (i3 = 0; i3 < set.getNumberOfAttributes(); ++i3) {
                st_deviation[i3] = Math.sqrt(this.attributes[i3].getVariance());
            }
            st_deviation[st_deviation.length - 1] = Math.sqrt(this.attributes[this.attributes.length - 1].getVariance());
            for (i3 = 0; i3 < set.getNumberOfAttributes(); ++i3) {
                covariance[i3] = 0.0;
                for (int j = 0; j < number_of_samples; ++j) {
                    int n = i3;
                    covariance[n] = covariance[n] + ((double)this.samples[i3][j] - mean[i3]) * ((double)this.samples[this.number_atts - 1][j] - mean[mean.length - 1]);
                }
                covariance[i3] = covariance[i3] / (double)(number_of_samples - 1);
            }
            double[] correlation = new double[set.getNumberOfAttributes()];
            for (int i4 = 0; i4 < correlation.length; ++i4) {
                correlation[i4] = st_deviation[i4] * st_deviation[st_deviation.length - 1];
                correlation[i4] = correlation[i4] == 0.0 ? covariance[i4] : covariance[i4] / correlation[i4];
            }
            this.orderWeights(correlation);
            props = new String("\n");
            props = props + Utils.getString("Attribute", 25, 0) + "| " + Utils.getString("Correlation", 25, 0) + "\n";
            props = props + Utils.duplicateString("-", 25) + "+ " + Utils.duplicateString("-", 25) + "\n";
            for (i = 0; i < 100 && i < correlation.length; ++i) {
                props = props + Utils.getString(this.attributes[this.attribute_index[i]].getName(), 25, 0) + "| " + Utils.getString(Double.toString(correlation[i]), 25, 1) + "\n";
            }
            Logger.logMessage(props, 3);
            this.number_atts = number_attribute;
        }
        if (this.getParameterAsString("attribute_mode").equals(attribute_mode[2])) {
            String weightFileName = this.getParameterAsString("attribute_weights_file");
            File weightFile = new File(weightFileName);
            AttributeWeights result = null;
            try {
                result = AttributeWeights.load(weightFile);
            }
            catch (IOException e) {
                throw new CompilerException(e.getMessage(), e);
            }
            double[] weights = new double[set.getNumberOfAttributes()];
            for (int i5 = 0; i5 < weights.length; ++i5) {
                weights[i5] = result.getWeight(this.attributes[i5].getName());
            }
            this.orderWeights(weights);
            props = new String("\n");
            props = props + Utils.getString("Attribute", 25, 0) + "| " + Utils.getString("Weight", 25, 0) + "\n";
            props = props + Utils.duplicateString("-", 25) + "+ " + Utils.duplicateString("-", 25) + "\n";
            for (i = 0; i < 100 && i < weights.length; ++i) {
                props = props + Utils.getString(this.attributes[this.attribute_index[i]].getName(), 25, 0) + "| " + Utils.getString(Double.toString(weights[i]), 25, 1) + "\n";
            }
            Logger.logMessage(props, 3);
            this.number_atts = number_attribute;
        }
        if (this.getParameterAsString("attribute_mode").equals(attribute_mode[3])) {
            StringTokenizer st = new StringTokenizer(this.getParameterAsString("attributes"), ",");
            index = 0;
            while (st.hasMoreTokens()) {
                String att = st.nextToken();
                this.attribute_index[index] = 0;
                for (int i6 = 0; i6 < this.attributes.length; ++i6) {
                    if (!this.attributes[i6].getName().equals(att)) continue;
                    this.attribute_index[index] = i6;
                    ++index;
                }
            }
            this.number_atts = index;
            if (this.number_atts == 0) {
                throw new CompilerException("No attribute selected!");
            }
            for (int i7 = index; i7 < this.attribute_index.length; ++i7) {
                this.attribute_index[i7] = 0;
            }
        }
        this.NumVisY = this.NumVisX = (int)Math.sqrt(this.number_atts);
        while (this.NumVisX * this.NumVisY < this.number_atts) {
            ++this.NumVisY;
        }
        this.LABEL_HEIGHT = this.getParameterAsInt("label_height");
        this.LABEL_WIDTH = this.getParameterAsInt("label_width");
        this.DEFAULT_VIS_WIDTH = this.getParameterAsInt("plot_width");
        this.DEFAULT_VIS_HEIGHT = this.getParameterAsInt("plot_height");
        this.createDisplayPanel();
        this.initComponents();
        this.iscompiling = false;
        this.iscompiled = true;
    }

    public void orderWeights(double[] array, int links, int rechts) {
        int left = links;
        int right = rechts;
        double pivot = array[(links + rechts) / 2];
        pivot = Math.abs(pivot);
        while (true) {
            if (Math.abs(array[left]) > pivot) {
                ++left;
                continue;
            }
            while (Math.abs(array[right]) < pivot) {
                --right;
            }
            if (left <= right) {
                double temp = array[left];
                array[left] = array[right];
                array[right] = temp;
                temp = this.attribute_index[left];
                this.attribute_index[left] = this.attribute_index[right];
                this.attribute_index[right] = (int)temp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (links < right) {
            this.orderWeights(array, links, right);
        }
        if (left < rechts) {
            this.orderWeights(array, left, rechts);
        }
    }

    public void orderWeights(double[] weights) {
        this.orderWeights(weights, 0, weights.length - 1);
    }

    public void parentIsCompiled() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
    }

    public void refreshParameter() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
    }

    public String[] getColorAttributes() {
        if (this.source == null) {
            return new String[]{"<None>"};
        }
        if (!this.source.isCompiled()) {
            return new String[]{"<None>"};
        }
        ExampleSet set = this.source.getExampleSet();
        if (set == null) {
            return new String[]{"<None>"};
        }
        int count = 1;
        count += set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            ++count;
        }
        if (set.getPredictedLabel() != null) {
            ++count;
        }
        String[] categories = new String[count];
        categories[0] = "<None>";
        for (int i = 1; i <= set.getNumberOfAttributes(); ++i) {
            categories[i] = set.getAttribute(i - 1).getName();
        }
        int index = set.getNumberOfAttributes() + 1;
        if (set.getLabel() != null) {
            categories[index] = set.getLabel().getName();
            ++index;
        }
        if (set.getPredictedLabel() != null) {
            categories[index] = set.getPredictedLabel().getName();
            ++index;
        }
        return categories;
    }
}

