/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.parameter.ParameterTypeDynamicCategory;
import edu.udo.cs.jvito.plot.ColorPanel;
import edu.udo.cs.jvito.plot.MovingListener;
import edu.udo.cs.jvito.plot.ParallelCoordinatesPanel;
import edu.udo.cs.jvito.plot.SimplePlot;
import edu.udo.cs.jvito.plot.ZoomingListener;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;

public class AndrewsCurvesPlot
extends SimplePlot {
    private JPanel mainpane;
    private JPanel settings;
    private String[] attr_names = new String[0];
    private int number_atts = 0;
    private int number_of_samples = 0;
    private float[][] samples;
    private float[] labelvalues;
    private float[] predvalues;
    private float[] min_sample;
    private float[] max_sample;
    private String[] classes;
    private String labelname;
    private int c_attr = 0;
    private JComboBox c_cbox;
    private JList attlist;
    private static final String[] NORMALIZATION = new String[]{"local", "global"};
    private int allpoints;
    private float min_fourier;
    private float max_fourier;
    private float[] colorvalues;

    public JPanel getPlotPanel() {
        if (!this.isCompiled()) {
            return null;
        }
        return this.mainpane;
    }

    private void initComponents() {
        this.initDisplay();
        this.mainpane = new JPanel();
        this.mainpane.setLayout(new BorderLayout(5, 5));
        this.settings = new JPanel();
        this.settings.setLayout(new BorderLayout(5, 5));
        this.mainpane.add((Component)this.settings, "East");
        JPanel settings2 = new JPanel();
        settings2.setLayout(new GridLayout(2, 1, 5, 5));
        this.settings.add((Component)settings2, "Center");
        ExampleSet set = this.source.getExampleSet();
        if (this.getParameterAsInt("color_attribute") != 0) {
            JPanel colorpanel = this.plotpanel.getColorPanel();
            if (this.getParameterAsInt("color_attribute") > set.getNumberOfAttributes()) {
                if (set.getLabel() != null && set.getLabel().isNominal() && this.getParameterAsInt("color_attribute") == set.getNumberOfAttributes() + 1) {
                    Color[] colors = new Color[set.getLabel().getValues().size()];
                    Collection values = set.getLabel().getValues();
                    Object[] valuesstr = values.toArray();
                    for (int i = 0; i < valuesstr.length; ++i) {
                        colors[i] = this.source.getExampleColoring().getColorOfLabelValue(set.getLabel(), (String)valuesstr[i]);
                    }
                    colorpanel = new ColorPanel(set.getLabel(), colors, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
                } else if (set.getPredictedLabel() != null && set.getPredictedLabel().isNominal()) {
                    Collection values = set.getPredictedLabel().getValues();
                    Object[] valuesstr = values.toArray();
                    Color[] colors = new Color[set.getPredictedLabel().getValues().size() * set.getPredictedLabel().getValues().size()];
                    String[] valuestring = new String[valuesstr.length * valuesstr.length];
                    for (int i = 0; i < valuesstr.length; ++i) {
                        for (int j = 0; j < valuesstr.length; ++j) {
                            valuestring[i * valuesstr.length + j] = new String((String)valuesstr[i] + " - " + (String)valuesstr[j]);
                            colors[i * valuesstr.length + j] = this.source.getExampleColoring().getColorOfLabelvsPred(set.getLabel(), set.getPredictedLabel(), (String)valuesstr[i], (String)valuesstr[j]);
                        }
                    }
                    colorpanel = new ColorPanel(set.getPredictedLabel(), valuestring, colors, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
                }
            }
            colorpanel.setPreferredSize(new Dimension(125, colorpanel.getHeight()));
            settings2.add(colorpanel);
        }
        this.mainpane.add((Component)this.plotpanel, "Center");
    }

    private void initDisplay() {
        ExampleSet set = this.source.getExampleSet();
        boolean haslabel = this.source.getExampleSet().getLabel() != null;
        boolean haspredlabel = this.source.getExampleSet().getPredictedLabel() != null;
        this.plotpanel = new ParallelCoordinatesPanel(this.source.getExampleSet(), this.source.getExampleColoring(), this.samples, this.min_fourier, this.max_fourier);
        ((ParallelCoordinatesPanel)this.plotpanel).setDrawCoordinates(false);
        this.plotpanel.setTitle(this.getParameterAsString("title"));
        this.plotpanel.setDrawTitle(this.getParameterAsBoolean("show title"));
        this.plotpanel.setForegroundColor(this.getParameterAsColor("foreground"));
        this.plotpanel.setBackgroundColor(this.getParameterAsColor("background"));
        MovingListener movinglistener = new MovingListener(this.plotpanel);
        ZoomingListener zoominlistener = new ZoomingListener(this.plotpanel);
        this.plotpanel.addMouseListener(movinglistener);
        this.plotpanel.addMouseMotionListener(movinglistener);
        this.plotpanel.addMouseListener(zoominlistener);
        this.plotpanel.addMouseMotionListener(zoominlistener);
        String color_attribute = ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).getValues()[this.getParameterAsInt("color_attribute")];
        if (!color_attribute.equals("<None>")) {
            if (haslabel && color_attribute.equals(set.getLabel().getName())) {
                this.plotpanel.colorByAttribute(set.getLabel(), this.labelvalues);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfAttribute(set.getLabel()));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfAttribute(set.getLabel()));
                this.plotpanel.initColorTable();
            } else if (haspredlabel && color_attribute.equals(set.getPredictedLabel().getName()) && set.getPredictedLabel().isNominal()) {
                Collection values = set.getPredictedLabel().getValues();
                Object[] valuesstr = values.toArray();
                Color[] colors = new Color[set.getPredictedLabel().getValues().size() * set.getPredictedLabel().getValues().size()];
                for (int i = 0; i < valuesstr.length; ++i) {
                    for (int j = 0; j < valuesstr.length; ++j) {
                        colors[i * valuesstr.length + j] = this.source.getExampleColoring().getColorOfLabelvsPred(set.getLabel(), set.getPredictedLabel(), (String)valuesstr[i], (String)valuesstr[j]);
                    }
                }
                float[] pvalues = new float[this.number_of_samples];
                for (int i = 0; i < this.predvalues.length; ++i) {
                    pvalues[i] = this.labelvalues[i] * (float)valuesstr.length + this.predvalues[i];
                }
                this.plotpanel.colorByAttribute(set.getPredictedLabel(), pvalues, colors);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfPredLabel(set.getPredictedLabel()));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfPredLabel(set.getPredictedLabel()));
            } else if (haspredlabel && color_attribute.equals(set.getPredictedLabel().getName()) && set.getPredictedLabel().isNumerical()) {
                this.plotpanel.colorByAttribute(set.getPredictedLabel(), this.predvalues);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfPredLabel(set.getPredictedLabel()));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfPredLabel(set.getPredictedLabel()));
                this.plotpanel.initColorTable();
            } else {
                this.plotpanel.colorByAttribute(set.getAttribute(color_attribute), this.colorvalues);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfAttribute(set.getAttribute(color_attribute)));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfAttribute(set.getAttribute(color_attribute)));
                this.plotpanel.initColorTable();
            }
        }
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeInt("support_points", "Number of support points for the fourier transform between two parallel coordinates.", 1, 100, 5);
        types.add(type);
        type = new ParameterTypeStringCategory("normalization", "Choose the normalization for the data.", NORMALIZATION, NORMALIZATION[0]);
        types.add(type);
        type = new ParameterTypeDynamicCategory("color_attribute", "This attribute is the color-dimension.", this.getColorAttributes(), 0);
        types.add(type);
        return types;
    }

    public void compile() throws CompilerException {
        if (!this.source.isCompiled()) {
            return;
        }
        this.iscompiling = true;
        ExampleSet set = this.source.getExampleSet();
        boolean haslabel = set.getLabel() != null;
        boolean haspredlabel = set.getPredictedLabel() != null;
        this.number_of_samples = set.getSize();
        this.number_atts = set.getNumberOfAttributes();
        this.attr_names = new String[this.number_atts];
        this.c_attr = Math.max(0, this.getParameterAsInt("color_attribute") - 1);
        for (int att = 0; att < this.number_atts; ++att) {
            this.attr_names[att] = set.getAttribute(att).getName();
        }
        if (haslabel || haspredlabel) {
            this.initClassNames();
        }
        int support_points = this.getParameterAsInt("support_points");
        this.allpoints = (this.number_atts - 1) * support_points + 1;
        this.samples = new float[this.allpoints][this.number_of_samples];
        this.min_sample = new float[this.number_atts];
        this.max_sample = new float[this.number_atts];
        this.labelvalues = new float[this.number_of_samples];
        this.predvalues = new float[this.number_of_samples];
        for (int d = 0; d < this.number_atts; ++d) {
            Attribute a = set.getAttribute(d);
            if (a.isNumerical()) {
                this.min_sample[d] = (float)a.getMinimum();
                this.max_sample[d] = (float)a.getMaximum();
                continue;
            }
            this.min_sample[d] = 0.0f;
            this.max_sample[d] = (float)a.getNumberOfValues() - 1.0f;
        }
        if (this.getParameterAsString("normalization").equals(NORMALIZATION[1])) {
            int d;
            float min = Float.MAX_VALUE;
            float max = Float.MIN_VALUE;
            for (d = 0; d < this.number_atts; ++d) {
                min = Math.min(min, this.min_sample[d]);
                max = Math.max(max, this.max_sample[d]);
            }
            for (d = 0; d < this.number_atts; ++d) {
                this.min_sample[d] = min;
                this.max_sample[d] = max;
            }
        }
        ExampleReader reader = set.getExampleReader();
        float leftbound = (float)(-Math.PI);
        float rightbound = (float)Math.PI;
        float delta = (rightbound - leftbound) / (float)(this.allpoints - 1);
        float[] min_four = new float[this.allpoints];
        float[] max_four = new float[this.allpoints];
        for (int d = 0; d < this.allpoints; ++d) {
            min_four[d] = Float.MAX_VALUE;
            max_four[d] = Float.MIN_VALUE;
        }
        int color_att = this.getParameterAsInt("color_attribute") - 1;
        if (color_att >= 0 && color_att < this.number_atts) {
            this.colorvalues = new float[this.number_of_samples];
        }
        for (int sample = 0; sample < this.number_of_samples; ++sample) {
            Example example = reader.next();
            float time = leftbound;
            for (int d = 0; d < this.allpoints; ++d) {
                this.samples[d][sample] = this.getFourierTransform(example, time, this.max_sample, this.min_sample);
                min_four[d] = Math.min(min_four[d], this.samples[d][sample]);
                max_four[d] = Math.max(max_four[d], this.samples[d][sample]);
                time += delta;
            }
            if (color_att >= 0 && color_att < this.number_atts) {
                this.colorvalues[sample] = (float)example.getValue(color_att);
            }
            if (haslabel) {
                this.labelvalues[sample] = (float)example.getLabel();
            }
            if (!haspredlabel) continue;
            this.predvalues[sample] = (float)example.getPredictedLabel();
        }
        this.min_fourier = Float.MAX_VALUE;
        this.max_fourier = Float.MIN_VALUE;
        for (int d = 0; d < this.allpoints; ++d) {
            this.min_fourier = Math.min(min_four[d], this.min_fourier);
            this.max_fourier = Math.max(max_four[d], this.max_fourier);
        }
        this.initComponents();
        this.iscompiling = false;
        this.iscompiled = true;
    }

    private void initClassNames() {
        Attribute att = null;
        if (this.source.getExampleSet().getPredictedLabel() != null) {
            att = this.source.getExampleSet().getPredictedLabel();
        }
        if (this.source.getExampleSet().getLabel() != null) {
            att = this.source.getExampleSet().getLabel();
        }
        if (att == null) {
            return;
        }
        this.classes = new String[att.getNumberOfValues()];
        Collection col = att.getValues();
        Iterator iter = col.iterator();
        int index = 0;
        while (iter.hasNext()) {
            this.classes[index] = (String)iter.next();
            ++index;
        }
    }

    public void parentIsCompiled() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
    }

    public void refreshParameter() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
    }

    public String[] getColorAttributes() {
        if (this.source == null) {
            return new String[]{"<None>"};
        }
        if (!this.source.isCompiled()) {
            return new String[]{"<None>"};
        }
        ExampleSet set = this.source.getExampleSet();
        if (set == null) {
            return new String[]{"<None>"};
        }
        int count = 1;
        count += set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            ++count;
        }
        if (set.getPredictedLabel() != null) {
            ++count;
        }
        String[] categories = new String[count];
        categories[0] = "<None>";
        for (int i = 1; i <= set.getNumberOfAttributes(); ++i) {
            categories[i] = set.getAttribute(i - 1).getName();
        }
        int index = set.getNumberOfAttributes() + 1;
        if (set.getLabel() != null) {
            categories[index] = set.getLabel().getName();
            ++index;
        }
        if (set.getPredictedLabel() != null) {
            categories[index] = set.getPredictedLabel().getName();
            ++index;
        }
        return categories;
    }

    public float getFourierTransform(Example example, float time, float[] maxima, float[] minima) {
        float fourier = 0.0f;
        int counter = 1;
        for (int i = 0; i < this.number_atts; ++i) {
            if (i == 0) {
                fourier += ((float)example.getValue(i) - minima[0]) / maxima[0] / (float)Math.sqrt(2.0);
                continue;
            }
            if ((i + 1) % 2 == 0) {
                fourier += ((float)example.getValue(i) - minima[i]) / (maxima[i] - minima[i]) * (float)Math.sin(time * (float)counter);
                continue;
            }
            fourier += ((float)example.getValue(i) - minima[i]) / (maxima[i] - minima[i]) * (float)Math.cos(time * (float)counter);
            ++counter;
        }
        return fourier;
    }
}

