/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.data.ExampleColoring;
import edu.udo.cs.jvito.gui.AttributeRangeDialog;
import edu.udo.cs.jvito.gui.ColorEditor;
import edu.udo.cs.jvito.gui.ColorRenderer;
import edu.udo.cs.jvito.gui.ValueColoringNominalEditor;
import edu.udo.cs.jvito.gui.ValueColoringNumericalEditor;
import edu.udo.cs.jvito.gui.ValueColoringTableModel;
import edu.udo.cs.jvito.util.Resources;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ValueColoringTable
extends JTable {
    private JDialog parent;
    private ExampleColoring coloring;
    private ExampleSet exampleset;
    private ValueColoringTableModel model;
    ColorRenderer colorrenderer;
    private Vector editor;

    public ValueColoringTable(JDialog parent, ExampleSet exampleset, ExampleColoring coloring) {
        this.parent = parent;
        this.coloring = coloring;
        this.exampleset = exampleset;
        this.model = new ValueColoringTableModel(exampleset, coloring, this);
        this.setModel(this.model);
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowHeight(this.getRowHeight() + 8);
        this.initRenderer();
    }

    private void initRenderer() {
        this.colorrenderer = new ColorRenderer(true);
        this.editor = new Vector();
        for (int i = 0; i < this.getRowCount(); ++i) {
            ValueColoringTableModel.AttValueColor valuecolor = (ValueColoringTableModel.AttValueColor)this.model.getValueRangeObjects().get(i);
            if (valuecolor.isRange()) {
                this.editor.add(new ValueColoringNumericalEditor(this.parent, valuecolor.attribute, valuecolor.min + "," + valuecolor.max));
                continue;
            }
            this.editor.add(new ValueColoringNominalEditor(((ValueColoringTableModel.AttValueColor)this.model.getValueRangeObjects().get((int)i)).attribute));
        }
    }

    public TableCellEditor getCellEditor(int row, int column) {
        if (column == 2) {
            return new ColorEditor((Color)this.getValueAt(row, column));
        }
        if (column == 1) {
            return (TableCellEditor)this.editor.get(row);
        }
        return super.getCellEditor();
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 2) {
            return this.colorrenderer;
        }
        if (column == 1) {
            return (TableCellRenderer)this.editor.get(row);
        }
        return new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                comp.setBackground(Color.LIGHT_GRAY);
                return comp;
            }
        };
    }

    public void insert() {
        int index = this.getSelectedRow();
        if (index < 0 || index >= this.getRowCount()) {
            index = this.getRowCount();
        }
        Object[] atts = new String[this.exampleset.getNumberOfAttributes()];
        for (int i = 0; i < atts.length; ++i) {
            atts[i] = new String(this.exampleset.getAttribute(i).getName());
        }
        String att = (String)JOptionPane.showInputDialog(this.parent, Resources.getString("EXAMPLECOLORING_SELECT"), Resources.getString("EXAMPLECOLORING_SELECT_TITLE"), -1, null, atts, atts[0]);
        if (att == null) {
            return;
        }
        int myindex = -1;
        for (int i = 0; i < atts.length; ++i) {
            if (!att.equals(atts[i])) continue;
            myindex = i;
        }
        Attribute attribute = this.exampleset.getAttribute(myindex);
        if (attribute.isNominal()) {
            String value = (String)JOptionPane.showInputDialog(this.parent, Resources.getString("EXAMPLECOLORING_SELECT_VALUE"), Resources.getString("EXAMPLECOLORING_SELECT_TITLE"), -1, null, attribute.getValues().toArray(), attribute.getValues().toArray()[0]);
            if (value == null) {
                return;
            }
            if (this.model.insertRow(attribute, index, value)) {
                this.editor.insertElementAt(new ValueColoringNominalEditor(attribute), index);
                this.model.fireTableDataChanged();
            }
        }
        if (attribute.isNumerical()) {
            AttributeRangeDialog dialog = new AttributeRangeDialog(this.parent, attribute);
            if (dialog.getExitAction() != 0) {
                return;
            }
            if (this.model.insertRow(attribute, index, dialog.getMinimum(), dialog.getMaximum())) {
                String text = dialog.getMinimum() + "," + dialog.getMaximum();
                this.editor.insertElementAt(new ValueColoringNumericalEditor(this.parent, attribute, text), index);
                this.model.fireTableDataChanged();
            }
        }
    }

    public void remove() {
        int index = this.getSelectedRow();
        if (index >= 0 && index < this.getRowCount()) {
            this.model.removeRow(index);
        }
    }
}

