/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.util.Resources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class StartWindow
extends JWindow {
    private Image logo;
    private static Image javaLogo;
    private String message = "Starting up.";
    private String productName;
    private String version;
    private WindowPanel panel;

    public StartWindow() {
        this(Resources.getString("APPLICATION_TITLE"), Resources.getString("APPLICATION_VERSION"), Resources.getImage("JVITO_LOGO_SMALL"));
    }

    public StartWindow(String productName, String version, Image logo) {
        javaLogo = Resources.getImage("JAVA_LOGO");
        this.logo = logo;
        this.panel = new WindowPanel();
        JPanel toppanel = new JPanel(new BorderLayout());
        toppanel.add((Component)this.panel, "Center");
        toppanel.setBorder(BorderFactory.createBevelBorder(0));
        this.getContentPane().add(toppanel);
        this.pack();
        this.setSize(400, 300);
        this.setLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2.0 - (double)(this.getWidth() / 2)), (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 2.0 - (double)(this.getHeight() / 2)));
    }

    public void setMessage(String message) {
        this.message = message;
        this.repaint();
    }

    private class WindowPanel
    extends JPanel {
        private WindowPanel() {
        }

        public void paint(Graphics g) {
            g.setColor(new Color(250, 250, 250));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (StartWindow.this.logo != null) {
                g.drawImage(StartWindow.this.logo, 40, 25, 350, 219, null);
            } else {
                g.setColor(Color.DARK_GRAY);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            g.setColor(Color.DARK_GRAY);
            g.setFont(new Font("Arial", 1, 25));
            g.drawString(Resources.getString("APPLICATION_TITLE") + " " + Resources.getString("APPLICATION_VERSION"), 10, 30);
            g.setFont(new Font("Arial", 1, 18));
            g.drawString(Resources.getString("APPLICATION_TITLE_LONG"), 10, 50);
            g.setFont(new Font("Arial", 0, 10));
            g.drawString(StartWindow.this.message, 10, 65);
            g.setFont(new Font("SansSerif", 0, 10));
            g.drawString("Copyright (C) 2004 by", 10, 245);
            g.drawString("Daniel Hakenjos", 10, 260);
            g.drawString("Ingo Mierswa and Katharina Morik", 10, 275);
            g.drawString("Use is subject to the GNU General Public License", 10, 290);
            if (javaLogo != null) {
                g.drawImage(javaLogo, 340, 230, null);
            }
        }
    }
}

