/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.exception.KeyException;
import edu.udo.cs.jvito.gui.Application;
import edu.udo.cs.jvito.gui.JPEGTab;
import edu.udo.cs.jvito.gui.LogTab;
import edu.udo.cs.jvito.gui.PreferenceTab;
import edu.udo.cs.jvito.util.Logger;
import edu.udo.cs.jvito.util.Preferences;
import edu.udo.cs.jvito.util.Resources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;

public class PreferencesDialog
extends JDialog
implements ActionListener {
    private LinkedList tabs;
    private JButton ok;
    private JButton apply;
    private JButton cancel;
    private JTabbedPane tabbedpane;
    private Application parent;

    public PreferencesDialog(Application parent) {
        super(parent, Resources.getString("PREFERENCES_DIALOG"), true);
        this.parent = parent;
        this.tabs = new LinkedList();
        this.initComponents();
    }

    private void initComponents() {
        this.ok = new JButton(Resources.getString("OK"));
        this.ok.addActionListener(this);
        this.apply = new JButton(Resources.getString("APPLY"));
        this.apply.addActionListener(this);
        this.cancel = new JButton(Resources.getString("CANCEL"));
        this.cancel.addActionListener(this);
        JPanel east = new JPanel();
        east.setLayout(new BoxLayout(east, 0));
        east.add(this.ok);
        east.add(this.apply);
        east.add(this.cancel);
        JPanel south = new JPanel();
        south.setLayout(new BorderLayout());
        south.add((Component)east, "East");
        JPanel toppanel = new JPanel();
        toppanel.setLayout(new BorderLayout(5, 5));
        toppanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        toppanel.add((Component)south, "South");
        this.tabbedpane = new JTabbedPane();
        this.addPreferenceTab(new LogTab(this));
        this.addPreferenceTab(new JPEGTab(this.parent));
        toppanel.add((Component)this.tabbedpane, "Center");
        this.getContentPane().add(toppanel);
        this.pack();
        Preferences pref = JViTo.getApplication().getPreferences();
        try {
            this.setSize(pref.getInt("preferences_dialog_width"), pref.getInt("preferences_dialog_height"));
        }
        catch (KeyException error) {
            this.setSize(250, 250);
        }
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dim.width - this.getSize().width) / 2, (dim.height - this.getSize().height) / 2);
        this.setVisible(true);
    }

    private void addPreferenceTab(PreferenceTab tab) {
        this.tabs.add(tab);
        this.tabbedpane.addTab(tab.toString(), tab);
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals(Resources.getString("OK"))) {
            Iterator iter = this.tabs.iterator();
            while (iter.hasNext()) {
                PreferenceTab tab = (PreferenceTab)iter.next();
                tab.ok();
            }
            this.dispose();
        } else if (cmd.equals(Resources.getString("APPLY"))) {
            Iterator iter = this.tabs.iterator();
            while (iter.hasNext()) {
                PreferenceTab tab = (PreferenceTab)iter.next();
                tab.apply();
            }
        } else if (cmd.equals(Resources.getString("CANCEL"))) {
            Iterator iter = this.tabs.iterator();
            while (iter.hasNext()) {
                PreferenceTab tab = (PreferenceTab)iter.next();
                tab.cancel();
            }
            this.dispose();
        } else {
            Logger.logMessage("The command is not valid", 7);
        }
    }

    public void dispose() {
        Preferences pref = this.parent.getPreferences();
        pref.setInt("preferences_dialog_width", this.getSize().width);
        pref.setInt("preferences_dialog_height", this.getSize().height);
        super.dispose();
    }
}

