/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.OperatorDescription;
import edu.udo.cs.jvito.data.Source;
import edu.udo.cs.jvito.gui.ExecutableMenuItem;
import edu.udo.cs.jvito.plot.Plot;
import edu.udo.cs.jvito.util.Logger;
import javax.swing.ImageIcon;
import javax.swing.JMenu;

public class OperatorMenuItem
extends ExecutableMenuItem {
    private OperatorDescription description;

    public OperatorMenuItem(JMenu parent, OperatorDescription description) {
        super(description.getName());
        this.description = description;
        this.setIcon(new ImageIcon(description.getIcon()));
        parent.add(this);
    }

    public void execute() {
        try {
            if (this.description.getType().equals("data")) {
                Source source = (Source)this.description.getOperatorClass().newInstance();
                source.setName(JViTo.getApplication().navigator.getValidTreeNodeName(this.description.getName()));
                source.setImage(this.description.getIcon());
                JViTo.getApplication().navigator.addSource(source);
                Logger.logMessage("Added data-operator: " + source.getName(), 3);
            }
            if (this.description.getType().equals("plot")) {
                Plot plot = (Plot)this.description.getOperatorClass().newInstance();
                plot.setName(JViTo.getApplication().navigator.getValidTreeNodeName(this.description.getName()));
                plot.setImage(this.description.getIcon());
                JViTo.getApplication().navigator.addPlot(plot);
                Logger.logMessage("Added plot-operator: " + plot.getName(), 3);
            }
        }
        catch (InstantiationException error) {
            Logger.logException("Can't instantiate " + this.description.getOperatorClass().getName() + " ", error);
            error.printStackTrace();
        }
        catch (IllegalAccessException error) {
            Logger.logException("Illegal Access ", error);
        }
    }
}

