/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.gui.Application;
import edu.udo.cs.jvito.gui.PreferenceTab;
import edu.udo.cs.jvito.util.Resources;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JPEGTab
extends PreferenceTab
implements ChangeListener {
    private Application app;
    private JSlider jslider;
    private JLabel label;

    public JPEGTab(Application app) {
        this.app = app;
        this.initComponents();
    }

    private void initComponents() {
        this.jslider = new JSlider(0, 0, 100, this.app.getJPEGQuality());
        this.jslider.setMajorTickSpacing(25);
        this.jslider.setMinorTickSpacing(5);
        this.jslider.setPaintTicks(true);
        this.jslider.setPaintLabels(true);
        this.jslider.addChangeListener(this);
        this.label = new JLabel("");
        this.setLabelText();
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 1, 10, 10));
        panel.add(this.label);
        panel.add(this.jslider);
        this.add((Component)panel, "Center");
    }

    private void setLabelText() {
        this.label.setText(Resources.getString("JPEG_QUALITY_LABEL") + " " + this.jslider.getValue() + "%");
    }

    public void apply() {
        this.app.setJPEGQuality(this.jslider.getValue());
    }

    public void cancel() {
    }

    public void ok() {
        this.apply();
    }

    public String toString() {
        return Resources.getString("JPEG_QUALITY");
    }

    public void stateChanged(ChangeEvent e) {
        this.setLabelText();
    }
}

