/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.data.ExampleColoring;
import edu.udo.cs.jvito.util.Resources;
import edu.udo.cs.yale.example.ExampleSet;
import java.awt.Color;
import javax.swing.table.AbstractTableModel;

public class AttributeColoringTableModel
extends AbstractTableModel {
    private ExampleSet exampleset;
    private ExampleColoring coloring;

    public AttributeColoringTableModel(ExampleSet exampleset, ExampleColoring coloring) {
        this.exampleset = exampleset;
        this.coloring = coloring;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int index) {
        if (index == 0) {
            return Resources.getString("EXAMPLECOLORING_ATTRIBUTES");
        }
        if (index == 1) {
            return Resources.getString("EXAMPLECOLORING_START_COLOR");
        }
        return Resources.getString("EXAMPLECOLORING_END_COLOR");
    }

    public int getRowCount() {
        if (this.exampleset == null) {
            return 0;
        }
        return this.exampleset.getNumberOfAttributes() + 1;
    }

    public Object getValueAt(int row, int column) {
        if (column == 0) {
            if (row == 0) {
                return Resources.getString("EXAMPLECOLORING_ALL");
            }
            return this.exampleset.getAttribute(row - 1).getName();
        }
        if (column == 1) {
            if (row == 0) {
                return this.coloring.getStartColorForAllAttributes();
            }
            return this.coloring.getStartColorOfAttribute(this.exampleset.getAttribute(row - 1));
        }
        if (column == 2) {
            if (row == 0) {
                return this.coloring.getEndColorForAllAttributes();
            }
            return this.coloring.getEndColorOfAttribute(this.exampleset.getAttribute(row - 1));
        }
        return "";
    }

    public boolean isCellEditable(int row, int column) {
        return column != 0;
    }

    public void setValueAt(Object aValue, int row, int column) {
        if (column != 0) {
            if (column == 1) {
                if (row == 0) {
                    this.coloring.setStartColorForAllAttributes((Color)aValue);
                    this.fireTableDataChanged();
                    JViTo.getApplication().setDirty();
                } else if (!this.coloring.getStartColorOfAttribute(this.exampleset.getAttribute(row - 1)).equals((Color)aValue)) {
                    this.coloring.setStartColorOfAttribute(this.exampleset.getAttribute(row - 1), (Color)aValue);
                    JViTo.getApplication().setDirty();
                }
            } else if (column == 2) {
                if (row == 0) {
                    this.coloring.setEndColorForAllAttributes((Color)aValue);
                    this.fireTableDataChanged();
                    JViTo.getApplication().setDirty();
                } else if (!this.coloring.getEndColorOfAttribute(this.exampleset.getAttribute(row - 1)).equals((Color)aValue)) {
                    this.coloring.setEndColorOfAttribute(this.exampleset.getAttribute(row - 1), (Color)aValue);
                    JViTo.getApplication().setDirty();
                }
            }
        }
    }
}

