/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.data.ExampleColoring;
import edu.udo.cs.jvito.gui.AttributeColoringTableModel;
import edu.udo.cs.jvito.gui.ColorEditor;
import edu.udo.cs.jvito.gui.ColorRenderer;
import edu.udo.cs.yale.example.ExampleSet;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class AttributeColoringTable
extends JTable {
    private ExampleColoring coloring;
    private ExampleSet exampleset;
    private AttributeColoringTableModel model;
    ColorRenderer colorrenderer;

    public AttributeColoringTable(ExampleSet exampleset, ExampleColoring coloring) {
        this.coloring = coloring;
        this.exampleset = exampleset;
        this.model = new AttributeColoringTableModel(exampleset, coloring);
        this.setModel(this.model);
        this.getTableHeader().setReorderingAllowed(false);
        if (exampleset.getNumberOfAttributes() < 20) {
            this.setRowHeight(this.getRowHeight() + 8);
        }
        this.initRenderer();
    }

    private void initRenderer() {
        this.colorrenderer = new ColorRenderer(true);
    }

    public TableCellEditor getCellEditor(int row, int column) {
        if (column == 0) {
            return super.getCellEditor();
        }
        return new ColorEditor((Color)this.getValueAt(row, column));
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 0) {
            return new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    comp.setBackground(Color.LIGHT_GRAY);
                    return comp;
                }
            };
        }
        return this.colorrenderer;
    }
}

