/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.OperatorsReader;
import edu.udo.cs.jvito.Project;
import edu.udo.cs.jvito.compile.Compileable;
import edu.udo.cs.jvito.compile.JViToCompiler;
import edu.udo.cs.jvito.data.FileSource;
import edu.udo.cs.jvito.data.GivenExampleSet;
import edu.udo.cs.jvito.data.GivenJMySVMModel;
import edu.udo.cs.jvito.data.Source;
import edu.udo.cs.jvito.exception.KeyException;
import edu.udo.cs.jvito.exception.XMLException;
import edu.udo.cs.jvito.gui.Browser;
import edu.udo.cs.jvito.gui.CompilingDialog;
import edu.udo.cs.jvito.gui.DataTableWindow;
import edu.udo.cs.jvito.gui.DescriptionPanel;
import edu.udo.cs.jvito.gui.ExampleColoringDialog;
import edu.udo.cs.jvito.gui.InputDialog;
import edu.udo.cs.jvito.gui.Inspector;
import edu.udo.cs.jvito.gui.InspectorWindow;
import edu.udo.cs.jvito.gui.JViToMenu;
import edu.udo.cs.jvito.gui.JViToToolBar;
import edu.udo.cs.jvito.gui.LogViewer;
import edu.udo.cs.jvito.gui.Navigator;
import edu.udo.cs.jvito.gui.NavigatorWindow;
import edu.udo.cs.jvito.gui.PlotTreeNode;
import edu.udo.cs.jvito.gui.PlotWindow;
import edu.udo.cs.jvito.gui.ProjectTreeNode;
import edu.udo.cs.jvito.gui.SourceTreeNode;
import edu.udo.cs.jvito.gui.StartWindow;
import edu.udo.cs.jvito.gui.XMLFileFilter;
import edu.udo.cs.jvito.gui.attributeeditor.AttributeEditorWindow;
import edu.udo.cs.jvito.parameter.ParameterObject;
import edu.udo.cs.jvito.plot.Plot;
import edu.udo.cs.jvito.util.Logger;
import edu.udo.cs.jvito.util.Preferences;
import edu.udo.cs.jvito.util.Resources;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.JViToPlotable;
import edu.udo.cs.yale.operator.learner.kernel.JMySVMModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.DefaultDesktopManager;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.freehep.util.export.ExportDialog;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Application
extends JFrame {
    private StartWindow startwindow;
    public JViToMenu menu;
    private JViToToolBar toolbar;
    public Navigator navigator;
    public Inspector inspector;
    public LogViewer logviewer;
    public DescriptionPanel desc_panel;
    private Preferences pref;
    private JDesktopPane desktop;
    private NavigatorWindow navi_window;
    private InspectorWindow insp_window;
    private JViToCompiler compiler;
    private File projectfile;
    private boolean opened = false;
    private boolean open = false;
    private boolean dirty = false;
    private LinkedList input = new LinkedList();
    private int jpeg_quality = 75;
    public static final int SYSTEM_EXIT_ON_EXIT = 0;
    public static final int DISPOSE_ON_EXIT = 1;
    private int exit_type = 0;
    static /* synthetic */ Class class$edu$udo$cs$jvito$gui$Application;

    public Application() {
        super(Resources.getString("APPLICATION_TITLE"));
        this.startwindow = new StartWindow();
        this.startwindow.setVisible(true);
        this.open = true;
    }

    public void setTypeHowToExit(int exit_type) {
        this.exit_type = exit_type;
    }

    public int getTypeHowToExit() {
        return this.exit_type;
    }

    public void init() {
        this.loadOperatorsXML();
        this.initPreferences();
        this.initComponents();
        this.projectfile = null;
        Application.testJava3D();
    }

    private void loadOperatorsXML() {
        this.startwindow.setMessage("Loading Operators...");
        try {
            URL url = (class$edu$udo$cs$jvito$gui$Application == null ? (class$edu$udo$cs$jvito$gui$Application = Application.class$("edu.udo.cs.jvito.gui.Application")) : class$edu$udo$cs$jvito$gui$Application).getClassLoader().getResource(Resources.getString("OPERATORS_XML"));
            InputStream input = url.openStream();
            OperatorsReader.registerOperators(Resources.getString("OPERATORS_XML"), input);
        }
        catch (FileNotFoundException e) {
            Logger.logException("File '" + Resources.getString("OPERATORS_XML") + "' not found.", e);
        }
        catch (IOException error) {
            Logger.logException(error.getMessage(), error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPreferences() {
        this.startwindow.setMessage("Loading Preferences...");
        String preffile = System.getProperty("JVITO_PREFERENCES");
        if (preffile != null) {
            File file = new File(preffile);
            if (file.exists() && !file.isDirectory()) {
                this.pref = new Preferences(preffile);
                try {
                    this.pref.load();
                }
                catch (XMLException error) {
                    Logger.logException("Can't load the preferences-file!", error);
                }
                try {
                    this.jpeg_quality = this.pref.getInt("jpeg_quality");
                }
                catch (KeyException error) {
                    this.jpeg_quality = 75;
                    this.pref.setInt("jpeg_quality", this.jpeg_quality);
                }
                Logger.logMessage("Preferences loaded!", 1);
            } else if (!file.exists() && !file.isDirectory()) {
                this.pref = new Preferences(preffile);
                Logger.logMessage("Preferences-file is not existing!", 5);
                try {
                    this.pref.save();
                }
                catch (IOException error) {
                    Logger.logException("Can't save the preferences-file.", error);
                }
                finally {
                    Logger.logMessage("Preferences-file was created.!", 1);
                }
            } else {
                this.pref = new Preferences(System.getProperty("user.home") + "/jvito_preferences.xml");
            }
        } else {
            this.pref = new Preferences(System.getProperty("user.home") + "/jvito_preferences.xml");
            System.out.println(this.pref.getFileName());
        }
        Logger.init(this.pref);
        String wdir = System.getProperty("user.home");
        try {
            wdir = this.pref.getString("workingdir");
        }
        catch (KeyException error) {
            wdir = System.getProperty("user.home");
        }
        File file = new File(wdir);
        if (file.isDirectory() && file.exists()) {
            JViTo.setWorkingDir(wdir);
        } else {
            Logger.logMessage("No working directory: " + wdir.toString(), 7);
        }
    }

    private void initComponents() {
        this.startwindow.setMessage(Resources.getString("STARTWINDOW_MAINFRAME"));
        this.setWindowTitle();
        this.setIconImage(Resources.getImage("JVITO_EGGS_SMALL"));
        this.menu = new JViToMenu(this);
        this.toolbar = new JViToToolBar(this);
        this.setJMenuBar(this.menu);
        this.setDefaultCloseOperation(0);
        this.desktop = new JDesktopPane();
        this.desktop.setDesktopManager(new DefaultDesktopManager());
        JPanel toolpanel = new JPanel();
        toolpanel.setLayout(new BorderLayout());
        toolpanel.add((Component)this.toolbar, "West");
        JPanel toppanel = new JPanel();
        toppanel.setLayout(new BorderLayout());
        toppanel.add((Component)this.desktop, "Center");
        toppanel.add((Component)toolpanel, "North");
        this.getContentPane().add(toppanel);
        this.addWindowListener(new WindowClosingListener());
        this.logviewer = new LogViewer(this);
        Logger.initGUI();
        try {
            this.logviewer.setSize(this.pref.getInt("logviewer_width"), this.pref.getInt("logviewer_height"));
            this.logviewer.setLocation(this.pref.getInt("logviewer_x"), this.pref.getInt("logviewer_y"));
        }
        catch (KeyException error) {
            this.logviewer.setSize(900, 400);
            this.logviewer.setLocation(0, 0);
            this.pref.setInt("logviewer_x", this.logviewer.getLocation().x);
            this.pref.setInt("logviewer_y", this.logviewer.getLocation().y);
            this.pref.setInt("logviewer_width", this.logviewer.getSize().width);
            this.pref.setInt("logviewer_height", this.logviewer.getSize().height);
        }
        this.logviewer.setClosable(false);
        this.logviewer.setResizable(true);
        this.logviewer.setVisible(true);
        this.desktop.add(this.logviewer);
        this.menu.updateWindowMenu();
        this.pack();
        try {
            this.setSize(this.pref.getInt("jvito_window_width"), this.pref.getInt("jvito_window_height"));
            this.setLocation(this.pref.getInt("jvito_window_x"), this.pref.getInt("jvito_window_y"));
        }
        catch (KeyException error) {
            if (this.getToolkit().isFrameStateSupported(6)) {
                this.setExtendedState(6);
            }
            this.setSize(500, 500);
        }
        this.startwindow.dispose();
        this.setVisible(true);
    }

    private void initComponentsDesktop(Project project) {
        this.navigator = new Navigator(new ProjectTreeNode(project));
        this.inspector = new Inspector(this, (Project)((ProjectTreeNode)this.navigator.getModel().getRoot()).getUserObject());
        this.desc_panel = new DescriptionPanel((Project)((ProjectTreeNode)this.navigator.getModel().getRoot()).getUserObject());
        this.navigator.setInspector(this.inspector);
        this.navigator.setDescriptionPanel(this.desc_panel);
        this.navi_window = new NavigatorWindow(this.navigator);
        this.insp_window = new InspectorWindow(this.inspector, this.desc_panel);
        try {
            this.navi_window.setLocation(this.pref.getInt("navi_window_x"), this.pref.getInt("navi_window_y"));
            this.navi_window.setSize(this.pref.getInt("navi_window_width"), this.pref.getInt("navi_window_height"));
        }
        catch (KeyException error) {
            this.navi_window.setLocation(0, 0);
            this.navi_window.setSize(300, 450);
        }
        this.navi_window.setClosable(false);
        this.navi_window.setResizable(true);
        this.navi_window.setVisible(true);
        try {
            this.insp_window.setLocation(this.pref.getInt("insp_window_x"), this.pref.getInt("insp_window_y"));
            this.insp_window.setSize(this.pref.getInt("insp_window_width"), this.pref.getInt("insp_window_height"));
        }
        catch (KeyException error) {
            this.insp_window.setLocation(0, 450);
            this.insp_window.setSize(300, this.desktop.getSize().height - 550);
        }
        this.insp_window.setClosable(false);
        this.insp_window.setResizable(true);
        this.insp_window.setVisible(true);
    }

    public static boolean testJava3D() {
        Package p;
        boolean b;
        Class testClass = Application.testClass("javax.vecmath.Point3d");
        boolean bl = testClass != null ? Application.testClass("javax.media.j3d.SceneGraphObject") != null : (b = false);
        if (b && (p = testClass.getPackage()) != null) {
            try {
                b = p.isCompatibleWith("1.2");
            }
            catch (NumberFormatException nfe) {
                b = false;
            }
        }
        if (!b) {
            int confirm = JOptionPane.showConfirmDialog(JViTo.getApplication(), Resources.getString("JAVA_3D_TEXT"), Resources.getString("JAVA_3D_TITLE"), 2, 1);
            if (confirm == 0) {
                Browser.showDialog(Resources.getURL("JAVA_3D_URL"));
            }
            return false;
        }
        return b;
    }

    private static Class testClass(String classname) {
        Class<?> c = null;
        try {
            c = Class.forName(classname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return c;
    }

    public void setWindowTitle() {
        String title = Resources.getString("APPLICATION_TITLE");
        title = this.projectfile != null ? title + " [" + this.projectfile.getName() + "]" : title + " [" + Resources.getString("FILE_UNNAMED") + "]";
        this.setTitle(title);
    }

    public void promptNew() {
        this.setDirty();
        Project proj = new Project(Resources.getString("PROJECT"));
        proj.setCreationParameter(null);
        proj.setChangesParameter(null);
        this.promptNew(proj);
        Logger.logMessage("Created new project.", 3);
    }

    public void addOperator(JViToPlotable plotable) {
        Source source = null;
        if (plotable instanceof ExampleSet) {
            source = new GivenExampleSet((ExampleSet)plotable);
        }
        if (plotable instanceof JMySVMModel) {
            source = new GivenJMySVMModel((JMySVMModel)plotable);
        }
        if (source != null) {
            JViTo.getApplication().navigator.addSource(source);
        }
    }

    public void promptNew(Project project) {
        if (this.opened) {
            this.promptClose();
        }
        this.initComponentsDesktop(project);
        this.desktop.add(this.navi_window);
        this.desktop.add(this.insp_window);
        this.menu.enableNew();
        this.menu.updateWindowMenu();
        this.toolbar.enableNew();
        this.opened = true;
    }

    public void promptOpen() {
        File file = null;
        JFileChooser chooser = new JFileChooser(JViTo.getWorkingDir());
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        file = chooser.getSelectedFile();
        this.promptOpen(file);
    }

    public void promptOpen(File file) {
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, "The file " + file.getName() + " don't exists!", "File not exists...", 0);
            return;
        }
        JViTo.setWorkingDir(file.toString());
        Project project = new Project();
        try {
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
                project.loadXMLDocument(document.getDocumentElement());
            }
            catch (IOException e) {
                throw new XMLException(e.getMessage(), e);
            }
            catch (ParserConfigurationException e) {
                throw new XMLException(e.toString(), e);
            }
            catch (SAXException e) {
                throw new XMLException("Cannot parse document: " + e, e);
            }
        }
        catch (XMLException e) {
            JOptionPane.showMessageDialog(this, "Error while loading the XML-Document: " + file.getName() + "\n" + e.getMessage(), "Error...", 0);
            return;
        }
        this.promptNew(project);
        this.projectfile = file;
        this.dirty = false;
        JViTo.setWorkingDir(file.getParent().toString());
        this.setWindowTitle();
        this.menu.setMenuItemEnabled("MENU_FILE_SAVE", false);
        this.toolbar.setButtonEnabled("TOOLBAR_SAVE", false);
        Logger.logMessage("Opened file: " + file.toString(), 3);
    }

    public void promptSave() {
        if (this.projectfile != null && this.projectfile.exists()) {
            try {
                this.getProject().setChangesParameter(null);
                FileOutputStream out = new FileOutputStream(this.projectfile);
                out.write(this.getProject().getXML("").getBytes());
                out.close();
                Logger.logMessage("Project saved: " + this.projectfile.toString(), 1);
                this.dirty = false;
                this.menu.setMenuItemEnabled("MENU_FILE_SAVE", false);
                this.toolbar.setButtonEnabled("TOOLBAR_SAVE", false);
            }
            catch (IOException e) {
                Logger.logException("Error while saving the Project", e);
            }
        } else {
            this.promptSaveAs();
        }
    }

    public void promptSaveAs() {
        int confirm;
        File file = null;
        JFileChooser chooser = new JFileChooser(JViTo.getWorkingDir());
        XMLFileFilter filter = new XMLFileFilter();
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal != 0) {
            return;
        }
        file = chooser.getSelectedFile();
        if (file.exists() && (confirm = JOptionPane.showConfirmDialog(this, Resources.getString("DIALOG_OVERWRITE_QUESTION") + " " + file.getName() + "?", Resources.getString("DIALOG_OVERWRITE_TITLE"), 0)) != 0) {
            return;
        }
        if (file != null) {
            try {
                this.getProject().setChangesParameter(null);
                FileOutputStream out = new FileOutputStream(file);
                out.write(this.getProject().getXML("").getBytes());
                out.close();
                Logger.logMessage("Project saved as: " + file.toString(), 1);
            }
            catch (IOException e) {
                Logger.logException("Error while saving the Project", e);
            }
        }
        this.projectfile = new File(file.toString());
        JViTo.setWorkingDir(file.getParent().toString());
        this.setWindowTitle();
        this.dirty = false;
        this.menu.setMenuItemEnabled("MENU_FILE_SAVE", false);
        this.toolbar.setButtonEnabled("TOOLBAR_SAVE", false);
    }

    public void promptClose() {
        if (this.isDirty()) {
            int ret = JOptionPane.showConfirmDialog(this, Resources.getString("DIALOG_SAVE_QUESTION"), Resources.getString("DIALOG_SAVE_TITLE"), 1, 3);
            if (ret == 2) {
                return;
            }
            if (ret == 0) {
                this.promptSave();
            }
        }
        this.setPreferences();
        this.desktop.removeAll();
        this.desktop.add(this.logviewer);
        this.desktop.repaint();
        this.projectfile = null;
        this.setWindowTitle();
        this.menu.enableClose();
        this.menu.updateWindowMenu();
        this.toolbar.enableClose();
        this.opened = false;
        this.dirty = false;
        Logger.logMessage("Closed the project.", 3);
    }

    public boolean isOpen() {
        return this.open;
    }

    private void setPreferences() {
        if (this.opened) {
            this.pref.setInt("navi_window_x", this.navi_window.getLocation().x);
            this.pref.setInt("navi_window_y", this.navi_window.getLocation().y);
            this.pref.setInt("navi_window_width", this.navi_window.getSize().width);
            this.pref.setInt("navi_window_height", this.navi_window.getSize().height);
            this.pref.setInt("insp_window_x", this.insp_window.getLocation().x);
            this.pref.setInt("insp_window_y", this.insp_window.getLocation().y);
            this.pref.setInt("insp_window_width", this.insp_window.getSize().width);
            this.pref.setInt("insp_window_height", this.insp_window.getSize().height);
        }
        this.pref.setInt("logviewer_x", this.logviewer.getLocation().x);
        this.pref.setInt("logviewer_y", this.logviewer.getLocation().y);
        this.pref.setInt("logviewer_width", this.logviewer.getSize().width);
        this.pref.setInt("logviewer_height", this.logviewer.getSize().height);
        this.pref.setInt("jvito_window_x", this.getLocation().x);
        this.pref.setInt("jvito_window_y", this.getLocation().y);
        this.pref.setInt("jvito_window_width", this.getSize().width);
        this.pref.setInt("jvito_window_height", this.getSize().height);
        this.pref.setString("workingdir", JViTo.getWorkingDir());
        File f = Logger.getLogFile();
        String file = new String("");
        if (f != null) {
            file = f.toString();
        }
        this.pref.setString("logfile", file);
        this.pref.setInt("logverbosity", Logger.getVerbosityLevel());
        String recent = this.menu.getRecentFiles().toString();
        this.pref.setString("recent_files", recent);
    }

    public Preferences getPreferences() {
        return this.pref;
    }

    public void promptExit() {
        if (this.opened) {
            this.promptClose();
        }
        this.pref.setInt("logviewer_x", this.logviewer.getLocation().x);
        this.pref.setInt("logviewer_y", this.logviewer.getLocation().y);
        this.pref.setInt("logviewer_width", this.logviewer.getSize().width);
        this.pref.setInt("logviewer_height", this.logviewer.getSize().height);
        this.pref.setInt("jpeg_quality", this.jpeg_quality);
        try {
            this.pref.save();
            Logger.logMessage("Preferences saved.", 1);
        }
        catch (IOException error) {
            Logger.logException("Can't save the preferences!", error);
        }
        Logger.logMessage("Exiting JViTo.", 1);
        this.open = false;
        if (this.exit_type == 1) {
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void promptCompile(int task) {
        void var3_3;
        ParameterObject object;
        MutableTreeNode node = this.navigator.getSelectedTreeNode();
        if (this.navigator.isProjectNodeSelected()) {
            object = ((ProjectTreeNode)node).getProject();
        } else if (this.navigator.isSourceNodeSelected()) {
            object = ((SourceTreeNode)node).getSource();
        } else if (this.navigator.isPlotNodeSelected()) {
            object = ((PlotTreeNode)node).getPlot();
        } else {
            return;
        }
        this.compiler = new JViToCompiler((Compileable)var3_3, task);
        Logger.logMessage("Start compiling: " + this.compiler.getTaskName(), 1);
        Thread t = new Thread(this.compiler);
        CompilingDialog dialog = new CompilingDialog(this, this.compiler, t);
        t.start();
        dialog.setVisible(true);
        if (this.compiler.getException() != null) {
            Logger.logException("Error while compiling", this.compiler.getException());
        } else {
            Logger.logMessage("Done.", 1);
        }
        this.navigator.refresh();
    }

    public void promptShowData() {
        if (!this.navigator.isSourceNodeSelected()) {
            return;
        }
        Source source = ((SourceTreeNode)this.navigator.getSelectedTreeNode()).getSource();
        if (!(source instanceof FileSource)) {
            if (!source.isCompiled()) {
                return;
            }
            ExampleSet set = source.getExampleSet();
            if (set == null) {
                return;
            }
            AttributeEditorWindow window = new AttributeEditorWindow((JFrame)this, set);
            try {
                window.setSize(this.pref.getInt("attributeeditor_width"), this.pref.getInt("attributeeditor_height"));
            }
            catch (KeyException error) {
                window.setSize(500, 500);
            }
            try {
                window.setLocation(this.pref.getInt("attributeeditor_x"), this.pref.getInt("attributeeditor_y"));
            }
            catch (KeyException error) {
                window.setLocation(0, 0);
            }
            window.setVisible(true);
            return;
        }
        String file = source.getParameterAsString("attributes");
        if (file.equals("")) {
            file = null;
        }
        File f = null;
        if (file != null) {
            f = new File(file);
        }
        AttributeEditorWindow window = new AttributeEditorWindow(this, source, f);
        window.setVisible(true);
    }

    public void updateDataTableWindow(Source source) {
        JInternalFrame[] frames = this.desktop.getAllFrames();
        for (int f = 0; f < frames.length; ++f) {
            if (!(frames[f] instanceof DataTableWindow) || !frames[f].getTitle().equals(Resources.getString("DATATABLE") + " " + source.getOldName())) continue;
            frames[f].setTitle(Resources.getString("DATATABLE") + " " + source.getName());
        }
    }

    public void updatePlotWindow(Plot plot) {
        JInternalFrame[] frames = this.desktop.getAllFrames();
        for (int f = 0; f < frames.length; ++f) {
            if (!(frames[f] instanceof PlotWindow) || !frames[f].getTitle().equals(plot.getOldName())) continue;
            frames[f].setTitle(plot.getName());
        }
    }

    public void promptShowVisualizationComponent() {
        if (!this.navigator.isSourceNodeSelected()) {
            return;
        }
        Source source = ((SourceTreeNode)this.navigator.getSelectedTreeNode()).getSource();
        if (!source.isCompiled()) {
            return;
        }
        JInternalFrame[] frames = this.desktop.getAllFrames();
        for (int f = 0; f < frames.length; ++f) {
            if (!(frames[f] instanceof PlotWindow) || !((PlotWindow)frames[f]).getTitle().equals(source.getName())) continue;
            ((PlotWindow)frames[f]).toFront();
            try {
                ((PlotWindow)frames[f]).setSelected(true);
            }
            catch (Exception error) {
                Logger.logException(error.getMessage(), error);
            }
            this.menu.updateWindowMenu();
            return;
        }
        PlotWindow window = new PlotWindow(source);
        try {
            window.setSize(this.pref.getInt("plotwindow_width"), this.pref.getInt("plotwindow_height"));
        }
        catch (KeyException error) {
            window.setSize(700, 400);
        }
        window.setLocation(300, 0);
        this.desktop.add(window);
        source.setJInternalFrame(window);
        window.show();
        this.menu.updateWindowMenu();
        Logger.logMessage("Showing Visualization Component: " + source.getName(), 1);
    }

    public void promptShowPlot() {
        if (!this.navigator.isPlotNodeSelected()) {
            return;
        }
        Plot plot = ((PlotTreeNode)this.navigator.getSelectedTreeNode()).getPlot();
        if (!plot.isCompiled()) {
            return;
        }
        JInternalFrame[] frames = this.desktop.getAllFrames();
        for (int f = 0; f < frames.length; ++f) {
            if (!(frames[f] instanceof PlotWindow) || !((PlotWindow)frames[f]).getTitle().equals(plot.getName())) continue;
            ((PlotWindow)frames[f]).toFront();
            try {
                ((PlotWindow)frames[f]).setSelected(true);
            }
            catch (Exception error) {
                Logger.logException(error.getMessage(), error);
            }
            this.menu.updateWindowMenu();
            return;
        }
        PlotWindow window = new PlotWindow(plot);
        try {
            window.setSize(this.pref.getInt("plotwindow_width"), this.pref.getInt("plotwindow_height"));
        }
        catch (KeyException error) {
            window.setSize(700, 400);
        }
        window.setLocation(300, 0);
        this.desktop.add(window);
        plot.setJInternalFrame(window);
        window.show();
        this.menu.updateWindowMenu();
        Logger.logMessage("Showing plot: " + plot.getName(), 1);
    }

    public void promptSaveAllPlots() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.navigator.getModel().getRoot();
        LinkedList<DefaultMutableTreeNode> nodes = new LinkedList<DefaultMutableTreeNode>();
        nodes.add(node);
        while (nodes.size() > 0) {
            node = (DefaultMutableTreeNode)nodes.removeFirst();
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultMutableTreeNode childnode = (DefaultMutableTreeNode)node.getChildAt(i);
                nodes.addLast(childnode);
                if (!(childnode instanceof PlotTreeNode)) continue;
                Plot plot = ((PlotTreeNode)childnode).getPlot();
                this.saveComponent(this, "Save Plot...", plot.getSaveableComponent(), plot.getName());
            }
        }
        Logger.logMessage("Saved all images of all plots.", 1);
    }

    public void promptSavePlot() {
        if (!this.navigator.isPlotNodeSelected()) {
            return;
        }
        Plot plot = ((PlotTreeNode)this.navigator.getSelectedTreeNode()).getPlot();
        if (!plot.isCompiled()) {
            return;
        }
        this.saveComponent(this, "Save Plot...", plot.getSaveableComponent(), plot.getName());
        Logger.logMessage("Saved the image of plot: " + plot.getName(), 1);
    }

    public void saveComponent(Component parent, String title, Component tosave, String filename) {
        if (tosave == null) {
            return;
        }
        ExportDialog exportDialog = new ExportDialog("JViTo");
        if (parent == null) {
            parent = this;
        }
        exportDialog.showExportDialog(parent, title, tosave, filename);
    }

    public Project getProject() {
        return ((ProjectTreeNode)this.navigator.getModel().getRoot()).getProject();
    }

    public File getProjectFile() {
        return this.projectfile;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty() {
        this.menu.setMenuItemEnabled("MENU_FILE_SAVE", true);
        this.toolbar.setButtonEnabled("TOOLBAR_SAVE", true);
        this.dirty = true;
    }

    public JDesktopPane getJDesktopPane() {
        return this.desktop;
    }

    public void addInput(Collection input) {
        Iterator iter = input.iterator();
        int objects = 0;
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof JViToPlotable)) continue;
            this.input.add(obj);
            ++objects;
        }
        if (objects > 0) {
            if (!this.opened) {
                int confirm = JOptionPane.showConfirmDialog(this, Resources.getString("DIALOG_INPUT_AVAILABLE") + "\n" + Resources.getString("DIALOG_INPUT_NEW_PROJECT"), Resources.getString("DIALOG_INPUT_AVAILABLE_TITLE"), 0);
                if (confirm == 0) {
                    this.promptNew();
                    this.showInputDialog();
                }
            } else {
                int confirm = JOptionPane.showConfirmDialog(this, Resources.getString("DIALOG_INPUT_AVAILABLE") + "\n" + Resources.getString("DIALOG_INPUT_SHOW"), Resources.getString("DIALOG_INPUT_AVAILABLE_TITLE"), 0);
                if (confirm == 0) {
                    this.showInputDialog();
                }
            }
        }
    }

    public Collection getInput() {
        return this.input;
    }

    public void showInputDialog() {
        InputDialog inputdialog = new InputDialog(this, this.input);
    }

    public void setJPEGQuality(int quality) {
        if (quality >= 0 && quality <= 100) {
            this.jpeg_quality = quality;
        }
    }

    public int getJPEGQuality() {
        return this.jpeg_quality;
    }

    public void promptShowExampleColoring() {
        if (!this.navigator.isSourceNodeSelected()) {
            return;
        }
        Source source = ((SourceTreeNode)this.navigator.getSelectedTreeNode()).getSource();
        if (!source.isCompiled()) {
            return;
        }
        ExampleColoringDialog dialog = new ExampleColoringDialog(this, source.getExampleSet(), source.getExampleColoring());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class WindowClosingListener
    extends WindowAdapter {
        private boolean exitSystem;

        public WindowClosingListener(boolean exitSystem) {
            this.exitSystem = exitSystem;
        }

        public WindowClosingListener() {
            this(true);
        }

        public void windowClosing(WindowEvent event) {
            Application.this.promptExit();
        }
    }
}

