/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.data;

import edu.udo.cs.jvito.data.ExampleColoring;
import edu.udo.cs.jvito.data.Source;
import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.mySVM.SVM.SVMInterface;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ListDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.Model;
import edu.udo.cs.yale.operator.learner.kernel.JMySVMModel;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class HyperplaneProjection
extends Source {
    private ExampleSet projectedset;
    private int number_of_samples;
    private int number_atts;
    private double[][] samples;
    private double[] datacenter;
    private double[] weights;
    private double bias;
    private JMySVMModel jmysvmmodel;

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeFile type = new ParameterTypeFile("model_file", "The JMySVMModel-File.", "");
        types.add(type);
        return types;
    }

    public void compile() throws CompilerException {
        int i;
        this.iscompiling = true;
        if (this.source == null) {
            throw new CompilerException("Cannot compile HyperplaneProjection. This operator must be achild of a data-operator.");
        }
        ExampleSet set = this.source.getExampleSet();
        this.number_of_samples = set.getSize();
        this.number_atts = set.getNumberOfAttributes();
        boolean haslabel = set.getLabel() != null;
        boolean haspredlabel = true;
        if (haslabel) {
            ++this.number_atts;
        }
        if (haspredlabel) {
            ++this.number_atts;
        }
        this.samples = new double[this.number_of_samples][this.number_atts];
        this.datacenter = new double[set.getNumberOfAttributes()];
        this.readModel();
        if (set.getPredictedLabel() == null) {
            try {
                this.jmysvmmodel.setPredictionParameter("function_value", "true");
                Attribute predictedLabel = this.jmysvmmodel.createPredictedLabel(set);
                this.jmysvmmodel.apply(set);
                set.recalculateAllAttributeStatistics();
            }
            catch (OperatorException e) {
                throw new CompilerException(e.getMessage(), e);
            }
        }
        ExampleReader reader = set.getExampleReader();
        for (int sample = 0; sample < this.number_of_samples; ++sample) {
            Example example = reader.next();
            for (i = 0; i < set.getNumberOfAttributes(); ++i) {
                this.samples[sample][i] = example.getValue(i);
            }
            if (haslabel) {
                this.samples[sample][set.getNumberOfAttributes()] = example.getLabel();
            }
            this.samples[sample][this.number_atts - 1] = example.getPredictedLabel();
        }
        this.calculateHyperplaneSamples();
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        for (i = 0; i < set.getNumberOfAttributes(); ++i) {
            attributes.add(AttributeFactory.createAttribute(set.getAttribute(i).getName(), 4));
        }
        if (haslabel) {
            attributes.add(set.getLabel());
        }
        attributes.add(set.getPredictedLabel());
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        LinkedList<DoubleArrayDataRow> data = null;
        data = new LinkedList<DoubleArrayDataRow>();
        for (int n = 0; n < this.number_of_samples; ++n) {
            data.add(new DoubleArrayDataRow(this.samples[n]));
        }
        table.readExamples(new ListDataRowReader(data.iterator()));
        this.projectedset = table.createCompleteExampleSet(set.getLabel(), set.getPredictedLabel(), null, null);
        this.projectedset.recalculateAllAttributeStatistics();
        this.iscompiling = false;
        this.iscompiled = true;
    }

    private void readModel() throws CompilerException {
        String filename = this.getParameterAsString("model_file");
        File modelFile = new File(filename);
        Model model = null;
        try {
            model = Model.readModel(modelFile);
        }
        catch (IOException e) {
            throw new CompilerException(e.getMessage(), e);
        }
        catch (OperatorException e) {
            throw new CompilerException(e.getMessage(), e);
        }
        if (!(model instanceof JMySVMModel)) {
            throw new CompilerException("");
        }
        this.jmysvmmodel = (JMySVMModel)model;
        SVMInterface svm2 = this.jmysvmmodel.createSVM();
        svm2.init(this.jmysvmmodel.getKernel(), this.jmysvmmodel.getExampleSet());
        this.weights = svm2.getWeights();
        this.bias = svm2.getB();
    }

    private void calculateHyperplaneSamples() {
        double ww = 0.0;
        for (int i = 0; i < this.weights.length; ++i) {
            ww += this.weights[i] * this.weights[i];
        }
        ExampleSet set = this.source.getExampleSet();
        int nr_atts = set.getNumberOfAttributes();
        for (int s = 0; s < this.number_of_samples; ++s) {
            int i;
            double wx = 0.0;
            for (i = 0; i < nr_atts; ++i) {
                wx += this.weights[i] * this.samples[s][i];
            }
            double t = (-1.0 * this.bias - wx) / ww;
            for (i = 0; i < nr_atts; ++i) {
                this.samples[s][i] = this.samples[s][i] + t * this.weights[i];
            }
        }
    }

    public ExampleColoring getExampleColoring() {
        return this.source.getExampleColoring();
    }

    public ExampleSet getExampleSet() {
        return this.projectedset;
    }
}

