/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.data;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.XMLDocument;
import edu.udo.cs.jvito.data.Source;
import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.exception.XMLException;
import edu.udo.cs.jvito.util.Logger;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;

public class GivenExampleSet
extends Source {
    public GivenExampleSet(ExampleSet exampleset) {
        this.name = JViTo.getApplication().navigator.getValidTreeNodeName("ExampleSet");
        exampleset.recalculateAllAttributeStatistics();
        this.exampleset = exampleset;
    }

    public GivenExampleSet(ExampleSet exampleset, String name) {
        this.name = JViTo.getApplication().navigator.getValidTreeNodeName(name);
        exampleset.recalculateAllAttributeStatistics();
        this.exampleset = exampleset;
    }

    public void compile() throws CompilerException {
        String filename = this.getParameterAsString("example_set_file");
        String attDescFile = this.getParameterAsString("attribute_description_file");
        if (filename.equals("") || attDescFile.equals("")) {
            Logger.logMessage("For writing the ExampleSet and the attributes you must specify the 'example_set_file' and the 'attribute_description_file'", 3);
            return;
        }
        Logger.logMessage("Writing the ExampleSet and the attributes.", 3);
        try {
            File dataFile = new File(filename);
            File attFile = new File(attDescFile);
            this.exampleset.writeToFile(dataFile, attFile);
        }
        catch (IOException e) {
            throw new CompilerException("", e);
        }
        Logger.logMessage("Ready.", 3);
    }

    public String getXML(String indent) {
        String xml = new String("");
        xml = xml + indent + "<source name=\"" + this.name + "\" class=\"edu.udo.cs.jvito.data.FileSource\">\n";
        xml = xml + indent + "\t" + "<description text=\"\"/>\n";
        xml = xml + indent + "\t" + "<parameter key=\"attributes\"\tvalue=\"" + this.getParameterAsString("attribute_description_file") + "\"/>\n";
        LinkedList childs = this.getXMLDocChilds();
        Iterator iter = childs.iterator();
        while (iter.hasNext()) {
            XMLDocument doc = (XMLDocument)iter.next();
            xml = xml + doc.getXML(indent + "\t");
        }
        xml = xml + indent + "</source>\n";
        return xml;
    }

    public boolean isCompiled() {
        return true;
    }

    public boolean isCompiling() {
        return false;
    }

    public void loadXMLDocument(Element element) throws XMLException {
        throw new XMLException("You never could load the operator 'GivenExampleSet'.");
    }

    public List getParameterTypes() {
        LinkedList<ParameterTypeFile> list = new LinkedList<ParameterTypeFile>();
        ParameterTypeFile type = new ParameterTypeFile("example_set_file", "File to save the example set to.", true);
        list.add(type);
        type = new ParameterTypeFile("attribute_description_file", "File to save the attribute descriptions to.", true);
        list.add(type);
        return list;
    }
}

