/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.data;

import edu.udo.cs.jvito.data.ExampleColoring;
import edu.udo.cs.jvito.data.Source;
import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.util.Logger;
import edu.udo.cs.yale.example.ExampleFormatter;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SparseFormatDataRowReader;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class ExampleSetWriter
extends Source {
    private static String[] formatNames = new String[SparseFormatDataRowReader.FORMAT_NAMES.length + 2];
    private String filename;
    private String attDescFile;

    public void compile() throws CompilerException {
        this.iscompiling = false;
        ExampleSet eSet = this.source.getExampleSet();
        this.filename = this.getParameterAsString("example_set_file");
        this.attDescFile = this.getParameterAsString("attribute_description_file");
        try {
            File dataFile = new File(this.filename);
            File attFile = this.attDescFile != null ? new File(this.attDescFile) : null;
            int format = this.getParameterAsInt("format");
            Logger.logMessage("Writing example set in format '" + formatNames[format] + "'.", 4);
            if (format == 0) {
                eSet.writeToFile(dataFile, attFile);
            } else if (format == formatNames.length - 1) {
                if (this.attDescFile != null) {
                    Logger.logMessage("special_format used. Ignoring attribute description file.", 7);
                }
                this.writeSpecialFormat(eSet, dataFile);
            } else {
                eSet.writeToFileSparse(format - 1, dataFile, attFile);
            }
        }
        catch (IOException e) {
            throw new CompilerException(e.getMessage(), e);
        }
        this.iscompiling = false;
        this.iscompiled = true;
    }

    private void writeSpecialFormat(ExampleSet exampleSet, File dataFile) throws CompilerException {
        ExampleFormatter formatter;
        String format = this.getParameterAsString("special_format");
        if (format == null) {
            throw new CompilerException("Specify the format!");
        }
        try {
            formatter = ExampleFormatter.compile(format, exampleSet);
        }
        catch (Throwable e) {
            throw new CompilerException(e.getMessage(), e);
        }
        try {
            PrintWriter out = new PrintWriter(new FileWriter(dataFile));
            ExampleReader reader = exampleSet.getExampleReader();
            while (reader.hasNext()) {
                out.print(formatter.format(reader.next()));
            }
            out.close();
        }
        catch (IOException e) {
            throw new CompilerException(e.getMessage(), e);
        }
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeFile("example_set_file", "File to save the example set to.", false));
        types.add(new ParameterTypeFile("attribute_description_file", "File to save the attribute descriptions to.", true));
        types.add(new ParameterTypeCategory("format", "Format to use for output.", formatNames, 0));
        types.add(new ParameterTypeString("special_format", "Format string to use for output.", true));
        return types;
    }

    public ExampleColoring getExampleColoring() {
        return this.source.getExampleColoring();
    }

    public ExampleSet getExampleSet() {
        return this.source.getExampleSet();
    }

    static {
        ExampleSetWriter.formatNames[0] = "dense";
        for (int i = 0; i < SparseFormatDataRowReader.FORMAT_NAMES.length; ++i) {
            ExampleSetWriter.formatNames[i + 1] = "sparse_" + SparseFormatDataRowReader.FORMAT_NAMES[i];
        }
        ExampleSetWriter.formatNames[ExampleSetWriter.formatNames.length - 1] = "special_format";
    }
}

