/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.data;

import edu.udo.cs.jvito.XMLDocument;
import edu.udo.cs.jvito.data.ColoringScheme;
import edu.udo.cs.jvito.exception.XMLException;
import edu.udo.cs.jvito.util.Resources;
import edu.udo.cs.yale.example.Attribute;
import java.awt.Color;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExampleColoring
implements XMLDocument,
ColoringScheme {
    private Color startcolor_allatts;
    private Color endcolor_allatts;
    private HashMap startcolor_atts;
    private HashMap endcolor_atts;
    private Color startlabel;
    private Color endlabel;
    private Color startpredlabel;
    private Color endpredlabel;
    private HashMap attvaluemap;
    private HashMap attranges;
    private HashMap idmap;
    public static final Color DEFAULT_COLOR = Color.white;

    public ExampleColoring() {
        this.init();
    }

    public void init() {
        this.startcolor_allatts = Resources.getColor("START_COLOR");
        this.endcolor_allatts = Resources.getColor("END_COLOR");
        this.startcolor_atts = new HashMap();
        this.endcolor_atts = new HashMap();
        this.startlabel = Resources.getColor("START_COLOR");
        this.endlabel = Resources.getColor("END_COLOR");
        this.startpredlabel = Resources.getColor("START_COLOR");
        this.endpredlabel = Resources.getColor("END_COLOR");
        this.attvaluemap = new HashMap();
        this.attranges = new HashMap();
        this.idmap = new HashMap();
    }

    public Color getColorForAttributeRange(Attribute attribute, double value) {
        if (attribute.isNominal()) {
            return DEFAULT_COLOR;
        }
        if (!this.attranges.containsKey(attribute.getName())) {
            return DEFAULT_COLOR;
        }
        LinkedList list = (LinkedList)this.attranges.get(attribute.getName());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            MinMaxRangeColor range = (MinMaxRangeColor)iter.next();
            if (!(range.min <= value) || !(value <= range.max)) continue;
            return range.color;
        }
        return DEFAULT_COLOR;
    }

    public boolean conflictsWithAttributeRange(Attribute attribute, double min, double max) {
        if (attribute.isNominal()) {
            return true;
        }
        if (!this.attranges.containsKey(attribute.getName())) {
            return false;
        }
        LinkedList list = (LinkedList)this.attranges.get(attribute.getName());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            MinMaxRangeColor range = (MinMaxRangeColor)iter.next();
            if (range.min < min && min < range.max) {
                return true;
            }
            if (range.min < max && max <= range.max) {
                return true;
            }
            if (!(min < range.min) || !(range.max < max)) continue;
            return true;
        }
        return true;
    }

    public LinkedList getRangeForAttribute(Attribute attribute) {
        if (attribute.isNominal()) {
            return new LinkedList();
        }
        if (!this.attranges.containsKey(attribute.getName())) {
            return new LinkedList();
        }
        return (LinkedList)this.attranges.get(attribute.getName());
    }

    public Color getColorForAttributeValue(Attribute attribute, String value) {
        if (attribute.isNumerical()) {
            return DEFAULT_COLOR;
        }
        if (!this.attvaluemap.containsKey(attribute.getName() + value)) {
            return DEFAULT_COLOR;
        }
        return (Color)this.attvaluemap.get(attribute.getName() + value);
    }

    public boolean hasColorForAttributeValue(Attribute attribute, String value) {
        return this.attvaluemap.containsKey(attribute.getName() + value);
    }

    public Color getColorForId(int id) {
        if (!this.idmap.containsKey(new Integer(id))) {
            return DEFAULT_COLOR;
        }
        return (Color)this.idmap.get(new Integer(id));
    }

    public Color getColorOfLabelValue(Attribute label, String value) {
        if (label.isNumerical()) {
            return DEFAULT_COLOR;
        }
        if (!this.attvaluemap.containsKey(label.getName() + value)) {
            return DEFAULT_COLOR;
        }
        return (Color)this.attvaluemap.get(label.getName() + value);
    }

    public Color getColorOfLabelValue(Attribute label, double value) {
        if (label.isNumerical()) {
            return DEFAULT_COLOR;
        }
        String vvalue = (String)label.getValues().toArray()[(int)value];
        if (!this.attvaluemap.containsKey(label.getName() + vvalue)) {
            return DEFAULT_COLOR;
        }
        return (Color)this.attvaluemap.get(label.getName() + vvalue);
    }

    public Color getColorOfLabelvsPred(Attribute label, Attribute predlabel, String value, String pred_value) {
        if (label.isNumerical()) {
            return DEFAULT_COLOR;
        }
        if (predlabel.isNumerical()) {
            return DEFAULT_COLOR;
        }
        String key = label.getName() + predlabel.getName() + value + pred_value;
        if (!this.attvaluemap.containsKey(key)) {
            return DEFAULT_COLOR;
        }
        return (Color)this.attvaluemap.get(key);
    }

    public Color getColorOfPredLabelValue(Attribute predlabel, String value) {
        if (predlabel.isNumerical()) {
            return DEFAULT_COLOR;
        }
        if (!this.attvaluemap.containsKey(predlabel.getName() + value)) {
            return DEFAULT_COLOR;
        }
        return (Color)this.attvaluemap.get(predlabel.getName() + value);
    }

    public Color getColorOfPredLabelValue(Attribute predlabel, double value) {
        if (predlabel.isNumerical()) {
            return DEFAULT_COLOR;
        }
        String vvalue = (String)predlabel.getValues().toArray()[(int)value];
        if (!this.attvaluemap.containsKey(predlabel.getName() + vvalue)) {
            return DEFAULT_COLOR;
        }
        return (Color)this.attvaluemap.get(predlabel.getName() + vvalue);
    }

    public Color getEndColorForAllAttributes() {
        return this.endcolor_allatts;
    }

    public Color getEndColorOfAttribute(Attribute attribute) {
        if (!this.endcolor_atts.containsKey(attribute.getName())) {
            return this.endcolor_allatts;
        }
        return (Color)this.endcolor_atts.get(attribute.getName());
    }

    public Color getEndColorOfLabel(Attribute label) {
        return this.endlabel;
    }

    public Color getEndColorOfPredLabel(Attribute predlabel) {
        return this.endpredlabel;
    }

    public Color getStartColorForAllAttributes() {
        return this.startcolor_allatts;
    }

    public Color getStartColorOfAttribute(Attribute attribute) {
        if (!this.startcolor_atts.containsKey(attribute.getName())) {
            return this.startcolor_allatts;
        }
        return (Color)this.startcolor_atts.get(attribute.getName());
    }

    public Color getStartColorOfLabel(Attribute label) {
        return this.startlabel;
    }

    public Color getStartColorOfPredLabel(Attribute predlabel) {
        return this.startpredlabel;
    }

    public boolean setColorForAttributeRange(Attribute attribute, double min, double max, Color color) {
        MinMaxRangeColor range;
        LinkedList list = new LinkedList();
        if (this.attranges.containsKey(attribute.getName())) {
            list = (LinkedList)this.attranges.get(attribute.getName());
        }
        Iterator iter = list.iterator();
        boolean conflicts = false;
        while (iter.hasNext()) {
            range = (MinMaxRangeColor)iter.next();
            if (range.min < min && min < range.max) {
                return false;
            }
            if (range.min < max && max <= range.max) {
                return false;
            }
            if (!(min < range.min) || !(range.max < max)) continue;
            return false;
        }
        if (conflicts) {
            return false;
        }
        range = new MinMaxRangeColor(min, max, color);
        list.add(range);
        this.attranges.put(attribute.getName(), list);
        return true;
    }

    public Color removeAttributeRange(Attribute attribute, double min, double max) {
        LinkedList list = new LinkedList();
        if (!this.attranges.containsKey(attribute.getName())) {
            return DEFAULT_COLOR;
        }
        list = (LinkedList)this.attranges.get(attribute.getName());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            MinMaxRangeColor range = (MinMaxRangeColor)iter.next();
            if (range.min != min || max != range.max) continue;
            list.remove(range);
            this.attranges.put(attribute.getName(), list);
            return range.color;
        }
        return DEFAULT_COLOR;
    }

    public void setColorForAttributeValue(Attribute attribute, String value, Color color) {
        if (attribute.isNumerical()) {
            return;
        }
        this.attvaluemap.put(attribute.getName() + value, color);
    }

    public Color removeColorForAttributeValue(Attribute attribute, String value) {
        if (!this.attvaluemap.containsKey(attribute.getName() + value)) {
            return DEFAULT_COLOR;
        }
        return (Color)this.attvaluemap.remove(attribute.getName() + value);
    }

    public void setColorForId(int id, Color color) {
        this.idmap.put(new Integer(id), color);
    }

    public void setColorOfLabelValue(Attribute label, String value, Color color) {
        if (label.isNumerical()) {
            return;
        }
        this.attvaluemap.put(label.getName() + value, color);
    }

    public void setColorOfLabelValue(Attribute label, double value, Color color) {
        if (label.isNumerical()) {
            return;
        }
        String vvalue = (String)label.getValues().toArray()[(int)value];
        this.attvaluemap.put(label.getName() + vvalue, color);
    }

    public void setColorOfLabelvsPred(Attribute label, Attribute predlabel, String value, String pred_value, Color color) {
        if (label.isNumerical()) {
            return;
        }
        if (predlabel.isNumerical()) {
            return;
        }
        String key = label.getName() + predlabel.getName() + value + pred_value;
        this.attvaluemap.put(key, color);
    }

    public void setColorOfPredLabelValue(Attribute predlabel, String value, Color color) {
        if (predlabel.isNumerical()) {
            return;
        }
        this.attvaluemap.put(predlabel.getName() + value, color);
    }

    public void setEndColorForAllAttributes(Color color) {
        this.endcolor_allatts = color;
        Object[] keys = this.endcolor_atts.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            this.endcolor_atts.remove((String)keys[i]);
        }
    }

    public void setEndColorOfAttribute(Attribute attribute, Color color) {
        this.endcolor_atts.put(attribute.getName(), color);
    }

    public void setEndColorOfLabel(Attribute label, Color color) {
        this.endlabel = color;
    }

    public void setEndColorOfPredLabel(Attribute predlabel, Color color) {
        this.endpredlabel = color;
    }

    public void setStartColorForAllAttributes(Color color) {
        this.startcolor_allatts = color;
        Object[] keys = this.endcolor_atts.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            this.startcolor_atts.remove((String)keys[i]);
        }
    }

    public void setStartColorOfAttribute(Attribute attribute, Color color) {
        this.startcolor_atts.put(attribute.getName(), color);
    }

    public void setStartColorOfLabel(Attribute label, Color color) {
        this.startlabel = color;
    }

    public void setStartColorOfPredLabel(Attribute predlabel, Color color) {
        this.startpredlabel = color;
    }

    public String getXML(String indent) {
        Color color;
        String key;
        StringBuffer result = new StringBuffer();
        String breakpointString = "";
        result.append(indent + "<examplecoloring " + "class=\"" + this.getClass().getName() + "\">\n");
        result.append(indent + "\t" + "<property name=\"startcolor_allatts\" type=\"Color\" value=\"" + this.startcolor_allatts.getRed() + "," + this.startcolor_allatts.getGreen() + "," + this.startcolor_allatts.getBlue() + "\"/>\n");
        result.append(indent + "\t" + "<property name=\"endcolor_allatts\" type=\"Color\" value=\"" + this.endcolor_allatts.getRed() + "," + this.endcolor_allatts.getGreen() + "," + this.endcolor_allatts.getBlue() + "\"/>\n");
        result.append(indent + "\t" + "<property name=\"startlabel\" type=\"Color\" value=\"" + this.startlabel.getRed() + "," + this.startlabel.getGreen() + "," + this.startlabel.getBlue() + "\"/>\n");
        result.append(indent + "\t" + "<property name=\"endlabel\" type=\"Color\" value=\"" + this.endlabel.getRed() + "," + this.endlabel.getGreen() + "," + this.endlabel.getBlue() + "\"/>\n");
        result.append(indent + "\t" + "<property name=\"startpredlabel\" type=\"Color\" value=\"" + this.startpredlabel.getRed() + "," + this.startpredlabel.getGreen() + "," + this.startpredlabel.getBlue() + "\"/>\n");
        result.append(indent + "\t" + "<property name=\"endpredlabel\" type=\"Color\" value=\"" + this.endpredlabel.getRed() + "," + this.endpredlabel.getGreen() + "," + this.endpredlabel.getBlue() + "\"/>\n");
        Set set = this.startcolor_atts.keySet();
        Iterator<Object> iter = set.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            color = (Color)this.startcolor_atts.get(key);
            result.append(indent + "\t" + "<property name=\"startcolor_atts\" key=\"" + key + "\" type=\"Color\" value=\"" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "\"/>\n");
        }
        set = this.endcolor_atts.keySet();
        iter = set.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            color = (Color)this.endcolor_atts.get(key);
            result.append(indent + "\t" + "<property name=\"endcolor_atts\" key=\"" + key + "\" type=\"Color\" value=\"" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "\"/>\n");
        }
        set = this.attvaluemap.keySet();
        iter = set.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            color = (Color)this.attvaluemap.get(key);
            result.append(indent + "\t" + "<property name=\"attvaluemap\" key=\"" + key + "\" type=\"Color\" value=\"" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "\"/>\n");
        }
        set = this.attranges.keySet();
        iter = set.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            LinkedList list = (LinkedList)this.attranges.get(key);
            Iterator listiter = list.iterator();
            while (listiter.hasNext()) {
                MinMaxRangeColor range = (MinMaxRangeColor)listiter.next();
                color = range.color;
                result.append(indent + "\t" + "<property name=\"attranges\" key=\"" + key + "\" min=\"" + range.min + "\" max=\"" + range.max + "\" type=\"Color\" value=\"" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "\"/>\n");
            }
        }
        set = this.idmap.keySet();
        iter = set.iterator();
        while (iter.hasNext()) {
            Integer inte = (Integer)iter.next();
            color = (Color)this.idmap.get(inte);
            result.append(indent + "\t" + "<property name=\"idmap\" key=\"" + inte + "\" type=\"Color\" value=\"" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "\"/>\n");
        }
        LinkedList childs = this.getXMLDocChilds();
        iter = childs.iterator();
        while (iter.hasNext()) {
            XMLDocument doc = (XMLDocument)iter.next();
            result.append(doc.getXML(indent + "\t"));
        }
        result.append(indent + "</examplecoloring>\n");
        return result.toString();
    }

    public void loadXMLDocument(Element element) throws XMLException {
        if (!element.getTagName().toLowerCase().equals("examplecoloring")) {
            throw new XMLException("<examplecoloring> expected!");
        }
        this.init();
        NodeList innerTags = element.getChildNodes();
        for (int i = 0; i < innerTags.getLength(); ++i) {
            Node node = innerTags.item(i);
            if (!(node instanceof Element)) continue;
            Element inner = (Element)node;
            if (inner.getTagName().toLowerCase().equals("property")) {
                int id;
                String key;
                Attr keyAttr;
                Attr nameAttr = inner.getAttributeNode("name");
                if (nameAttr == null) {
                    throw new XMLException("Attribute 'name' of <property> tag is not defined! ");
                }
                String name = nameAttr.getValue();
                Attr colorAttr = inner.getAttributeNode("value");
                if (colorAttr == null) {
                    throw new XMLException("Attribute 'value' of <property> tag is not defined! ");
                }
                StringTokenizer st = new StringTokenizer(colorAttr.getValue(), ",");
                int red = -1;
                int green = -1;
                int blue = -1;
                try {
                    if (!st.hasMoreTokens()) {
                        throw new XMLException("The color-value is not valid: " + colorAttr.getValue() + "\n Specify red, green and blue in comma separated manner!");
                    }
                    red = Integer.parseInt(st.nextToken());
                    if (!st.hasMoreTokens()) {
                        throw new XMLException("The color-value is not valid: " + colorAttr.getValue() + "\n Specify red, green and blue in comma separated manner!");
                    }
                    green = Integer.parseInt(st.nextToken());
                    if (!st.hasMoreTokens()) {
                        throw new XMLException("The color-value is not valid: " + colorAttr.getValue() + "\n Specify red, green and blue in comma separated manner!");
                    }
                    blue = Integer.parseInt(st.nextToken());
                }
                catch (NumberFormatException error) {
                    throw new XMLException("", error);
                }
                Color color = new Color(red, green, blue);
                if (name.equals("startcolor_allatts")) {
                    this.startcolor_allatts = color;
                    continue;
                }
                if (name.equals("endcolor_allatts")) {
                    this.endcolor_allatts = color;
                    continue;
                }
                if (name.equals("startlabel")) {
                    this.startlabel = color;
                    continue;
                }
                if (name.equals("endlabel")) {
                    this.endlabel = color;
                    continue;
                }
                if (name.equals("startpredlabel")) {
                    this.startpredlabel = color;
                    continue;
                }
                if (name.equals("endpredlabel")) {
                    this.endpredlabel = color;
                    continue;
                }
                if (name.equals("startcolor_atts")) {
                    keyAttr = inner.getAttributeNode("key");
                    if (keyAttr == null) {
                        throw new XMLException("Attribute 'key' is not defined for the <property> tag with name='startcolor_atts'");
                    }
                    key = keyAttr.getValue();
                    this.startcolor_atts.put(key, color);
                    continue;
                }
                if (name.equals("endcolor_atts")) {
                    keyAttr = inner.getAttributeNode("key");
                    if (keyAttr == null) {
                        throw new XMLException("Attribute 'key' is not defined for the <property> tag with name='endcolor_atts'");
                    }
                    key = keyAttr.getValue();
                    this.endcolor_atts.put(key, color);
                    continue;
                }
                if (name.equals("attvaluemap")) {
                    keyAttr = inner.getAttributeNode("key");
                    if (keyAttr == null) {
                        throw new XMLException("Attribute 'key' is not defined for the <property> tag with name='attvaluemap'");
                    }
                    key = keyAttr.getValue();
                    this.attvaluemap.put(key, color);
                    continue;
                }
                if (name.equals("attranges")) {
                    double max;
                    double min;
                    keyAttr = inner.getAttributeNode("key");
                    if (keyAttr == null) {
                        throw new XMLException("Attribute 'key' is not defined for the <property> tag with name='attranges'");
                    }
                    key = keyAttr.getValue();
                    Attr minAttr = inner.getAttributeNode("min");
                    if (minAttr == null) {
                        throw new XMLException("Attribute 'min' is not defined for the <property> tag with name='attranges'");
                    }
                    try {
                        min = Double.parseDouble(minAttr.getValue());
                    }
                    catch (NumberFormatException error) {
                        throw new XMLException(error.getMessage(), error);
                    }
                    Attr maxAttr = inner.getAttributeNode("max");
                    if (maxAttr == null) {
                        throw new XMLException("Attribute 'max' is not defined for the <property> tag with name='attranges'");
                    }
                    try {
                        max = Double.parseDouble(maxAttr.getValue());
                    }
                    catch (NumberFormatException error) {
                        throw new XMLException(error.getMessage(), error);
                    }
                    MinMaxRangeColor range = new MinMaxRangeColor(min, max, color);
                    LinkedList rangelist = new LinkedList();
                    if (this.attranges.containsKey(key)) {
                        rangelist = (LinkedList)this.attranges.get(key);
                    }
                    rangelist.add(range);
                    this.attranges.put(key, rangelist);
                    continue;
                }
                if (!name.equals("idmap")) continue;
                keyAttr = inner.getAttributeNode("key");
                if (keyAttr == null) {
                    throw new XMLException("Attribute 'key' is not defined for the <property> tag with name='idmap'");
                }
                key = keyAttr.getValue();
                try {
                    id = Integer.parseInt(key);
                }
                catch (NumberFormatException error) {
                    throw new XMLException(error.getMessage(), error);
                }
                this.idmap.put(new Integer(id), color);
                continue;
            }
            throw new XMLException("Ilegal inner tag for <examplecoloring>: " + inner.getTagName());
        }
    }

    public LinkedList getXMLDocChilds() {
        return new LinkedList();
    }

    public void writeXML(PrintWriter out, String indent) {
    }

    public class MinMaxRangeColor {
        public double min;
        public double max;
        public Color color;

        public MinMaxRangeColor(double min, double max, Color color) {
            this.min = min;
            this.max = max;
            this.color = color;
        }
    }
}

