/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito;

import edu.udo.cs.jvito.exception.XMLException;
import edu.udo.cs.jvito.util.Logger;
import edu.udo.cs.jvito.util.Resources;
import java.awt.Image;
import java.io.File;
import org.w3c.dom.Element;

public class OperatorDescription {
    public static final String DATA = "data";
    public static final String PLOT = "plot";
    private String type;
    private String name;
    private Class clazz;
    private String description;
    private String group;
    private Image icon = null;
    private String iconDir;

    public OperatorDescription(Element element) throws ClassNotFoundException, XMLException {
        if (!element.getTagName().equals("operator")) {
            throw new XMLException("elements tag name must be \"operator\"");
        }
        this.type = element.getAttribute("type");
        this.name = element.getAttribute("name");
        this.clazz = Class.forName(element.getAttribute("class"));
        this.description = element.getAttribute("description");
        this.group = element.getAttribute("group");
        this.iconDir = element.getAttribute("image");
        if (this.type == null || !this.type.equals(DATA) && !this.type.equals(PLOT)) {
            throw new XMLException("attribute 'type' must be \"data\" or \"plot\".");
        }
        if (this.name == null || this.name.equals("")) {
            throw new XMLException("attribute 'name' must be specified.");
        }
        if (this.description == null || this.description.equals("")) {
            throw new XMLException("attribute 'description' must be specified.");
        }
        if (this.group == null || this.group.equals("")) {
            throw new XMLException("attribute 'group' must be specified.");
        }
        if (this.iconDir == null || this.iconDir.equals("")) {
            this.icon = null;
        } else {
            try {
                this.iconDir = File.separator + "edu" + File.separator + "udo" + File.separator + "cs" + File.separator + "jvito" + File.separator + "resources" + this.iconDir;
                this.icon = Resources.getImageByDir(this.iconDir);
            }
            catch (NullPointerException error) {
                Logger.logMessage("Can't load this image " + this.iconDir + ".", 5);
                this.icon = null;
            }
        }
        if (this.icon == null) {
            this.icon = this.type.equals(DATA) ? Resources.getImage("TREE_SOURCE") : (this.type.equals(PLOT) ? Resources.getImage("TREE_PLOT") : Resources.getImage("STANDARD"));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Class getOperatorClass() {
        return this.clazz;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGroup() {
        return this.group;
    }

    public Image getIcon() {
        return this.icon;
    }

    public String getIconDir() {
        return this.iconDir;
    }
}

