/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.kxml2.kdom.Document;
import org.kxml2.kdom.Element;

public class Preferences
extends Document {
    private final String VALUE = "value";
    private final String TYPE = "type";
    private final String TYPE_STRING = "String";
    private final String TYPE_INT = "int";
    private final String TYPE_FLOAT = "float";
    private Element prefs;

    public Preferences() {
        this.prefs = this.createElement(null, "Preferences");
        this.addChild(this.getChildCount(), 2, this.prefs);
    }

    public Preferences(String string) {
        try {
            int n;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            KXmlParser kXmlParser = new KXmlParser();
            kXmlParser.setInput(bufferedInputStream, "utf-8");
            this.parse(kXmlParser);
            ((InputStream)bufferedInputStream).close();
            this.prefs = this.getElement(null, "Preferences");
            while (this.getChildCount() > 1) {
                for (n = 0; n < this.getChildCount(); ++n) {
                    if (this.getChild(n) == this.prefs) continue;
                    this.removeChild(n);
                }
            }
            for (n = 0; n < this.prefs.getChildCount(); ++n) {
                if (this.prefs.getChild(n) instanceof Element) continue;
                this.prefs.removeChild(n);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.prefs = this.createElement(null, "Preferences");
            this.addChild(this.getChildCount(), 2, this.prefs);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void save(String string) {
        try {
            File file = new File(string);
            if (file.exists()) {
                file.delete();
            }
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            KXmlSerializer kXmlSerializer = new KXmlSerializer();
            kXmlSerializer.setOutput(bufferedOutputStream, "utf-8");
            kXmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            this.addChild(0, 9, "Preferences File - written " + new Date() + " by " + System.getProperty("user.name"));
            this.write(kXmlSerializer);
            kXmlSerializer.flush();
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Element getElement(String string) {
        try {
            return this.prefs.getElement(null, string);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public String getString(String string) {
        return this.getString(string, null);
    }

    public String getString(String string, String string2) {
        Element element = this.getElement(string);
        if (element == null) {
            return string2;
        }
        String string3 = element.getAttributeValue(null, "type");
        if (string3 == null || !string3.equals("String")) {
            return string2;
        }
        return element.getAttributeValue(null, "value");
    }

    public void putString(String string, String string2) {
        if (this.getElement(string) != null) {
            this.prefs.removeChild(this.prefs.indexOf(null, string, 0));
        }
        Element element = this.prefs.createElement(null, string);
        element.setAttribute(null, "type", "String");
        element.setAttribute(null, "value", string2);
        this.prefs.addChild(this.prefs.getChildCount(), 2, element);
    }

    public int getInt(String string) {
        return this.getInt(string, -1);
    }

    public int getInt(String string, int n) {
        Element element = this.getElement(string);
        if (element == null) {
            return n;
        }
        String string2 = element.getAttributeValue(null, "type");
        if (string2 == null || !string2.equals("int")) {
            return n;
        }
        return Integer.parseInt(element.getAttributeValue(null, "value"));
    }

    public void putInt(String string, int n) {
        if (this.getElement(string) != null) {
            this.prefs.removeChild(this.prefs.indexOf(null, string, 0));
        }
        Element element = this.prefs.createElement(null, string);
        element.setAttribute(null, "type", "int");
        element.setAttribute(null, "value", String.valueOf(n));
        this.prefs.addChild(this.prefs.getChildCount(), 2, element);
    }

    public float getFloat(String string) {
        return this.getFloat(string, -1.0f);
    }

    public float getFloat(String string, float f) {
        Element element = this.getElement(string);
        if (element == null) {
            return f;
        }
        String string2 = element.getAttributeValue(null, "type");
        if (string2 == null || !string2.equals("float")) {
            return f;
        }
        return Float.parseFloat(element.getAttributeValue(null, "value"));
    }

    public void putFloat(String string, float f) {
        if (this.getElement(string) != null) {
            this.prefs.removeChild(this.prefs.indexOf(null, string, 0));
        }
        Element element = this.prefs.createElement(null, string);
        element.setAttribute(null, "type", "float");
        element.setAttribute(null, "value", String.valueOf(f));
        this.prefs.addChild(this.prefs.getChildCount(), 2, element);
    }
}

